/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.handlers.AnalyticsAuthorizationHandler;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthenticationDialog
extends Dialog {
    public static final int CONNECT_ID = 2;
    public static final int CANCEL_ID = 1;
    private Text email;
    private Text password;
    private Text serverUrl;
    private Label lblHelp;
    private Button btnConnect;
    private Button btnCancel;
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private AnalyticsTokenInfo tokenInfo;
    private boolean showPassword;

    public AuthenticationDialog(Shell parentShell, boolean showPassword) {
        super(parentShell);
        this.showPassword = showPassword;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnConnect = this.createButton(parent, 2, StringConstants.BTN_CONNECT, true);
        this.btnCancel = this.createButton(parent, 1, StringConstants.BTN_CANCEL, false);
        this.enableLogin();
        this.addControlListeners();
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData bodyGridData = new GridData(4, 4, true, true);
        bodyGridData.widthHint = 500;
        body.setLayoutData((Object)bodyGridData);
        body.setLayout((Layout)new GridLayout(1, false));
        Composite infoComposite = new Composite(body, 0);
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblInformation = new Label(infoComposite, 64);
        lblInformation.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        lblInformation.setText(StringConstants.LBL_INFORMATION);
        this.lblHelp = new Label(infoComposite, 0);
        GridData gdLblHelp = new GridData(16384, 128, false, false, 1, 1);
        this.lblHelp.setLayoutData((Object)gdLblHelp);
        this.lblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        this.lblHelp.setCursor(Display.getDefault().getSystemCursor(21));
        Composite inputComposite = new Composite(body, 0);
        inputComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        inputComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblServerUrl = new Label(inputComposite, 0);
        lblServerUrl.setText(StringConstants.LBL_SERVER_URL);
        this.serverUrl = new Text(inputComposite, 2048);
        this.serverUrl.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblUsername = new Label(inputComposite, 0);
        lblUsername.setText(StringConstants.LBL_EMAIL);
        this.email = new Text(inputComposite, 2048);
        this.email.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblPassword = new Label(inputComposite, 0);
        lblPassword.setText(StringConstants.LBL_PASSWORD);
        GridData gdLblPassword = new GridData(4, 4, false, false);
        lblPassword.setLayoutData((Object)gdLblPassword);
        this.password = new Text(inputComposite, 0x400800);
        GridData gdPassword = new GridData(4, 4, true, false);
        this.password.setLayoutData((Object)gdPassword);
        Link linkPolicy = new Link(body, 64);
        linkPolicy.setLayoutData((Object)new GridData(4, 4, true, false));
        linkPolicy.setText(StringConstants.LBL_POLICY);
        linkPolicy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)event.text);
            }
        });
        try {
            boolean encryptionEnabled = this.analyticsSettingStore.isEncryptionEnabled();
            this.serverUrl.setText(this.analyticsSettingStore.getServerEndpoint(encryptionEnabled));
            this.password.setText(this.analyticsSettingStore.getPassword(encryptionEnabled));
            if (StringUtils.isEmpty((String)this.analyticsSettingStore.getEmail(encryptionEnabled))) {
                this.email.setText(ApplicationInfo.getAppProperty((String)"email"));
            } else {
                this.email.setText(this.analyticsSettingStore.getEmail(encryptionEnabled));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        gdLblPassword.exclude = !this.showPassword;
        this.serverUrl.setEnabled(this.showPassword);
        this.email.setEnabled(this.showPassword);
        lblPassword.setVisible(this.showPassword);
        gdPassword.exclude = !this.showPassword;
        this.password.setVisible(this.showPassword);
        return body;
    }

    private void updateDataStore(String email, String password) {
        try {
            boolean encryptionEnabled = true;
            this.analyticsSettingStore.enableIntegration(true);
            this.analyticsSettingStore.enableEncryption(encryptionEnabled);
            this.analyticsSettingStore.setServerEndPoint(this.serverUrl.getText(), encryptionEnabled);
            this.analyticsSettingStore.setEmail(email, encryptionEnabled);
            this.analyticsSettingStore.setPassword(password, encryptionEnabled);
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void addControlListeners() {
        this.email.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthenticationDialog.this.handleEnteredUsername();
            }
        });
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthenticationDialog.this.handleEnteredPassword();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationDialog.this.handleConnect();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationDialog.this.cancelPressed();
            }
        });
        this.lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)StringConstants.ANALYTICS_DOCUMENTATION_LINK);
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.INTEGRATION_DIALOG_TITLE);
    }

    private void enableLogin() {
        if (!StringUtils.isBlank((String)this.email.getText()) && !StringUtils.isBlank((String)this.password.getText())) {
            this.btnConnect.setEnabled(true);
        } else {
            this.btnConnect.setEnabled(false);
        }
    }

    private void handleConnect() {
        String emailText = this.email.getText();
        String passwordText = this.password.getText();
        String serverUrlText = this.serverUrl.getText();
        this.updateDataStore(emailText, passwordText);
        this.setReturnCode(2);
        AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrlText, emailText, passwordText, this.analyticsSettingStore);
        this.setTokenInfo(tokenInfo);
        if (tokenInfo != null) {
            this.closeDialog();
        }
    }

    private void handleEnteredUsername() {
        this.enableLogin();
    }

    private void handleEnteredPassword() {
        this.enableLogin();
    }

    private void closeDialog() {
        this.close();
    }

    public AnalyticsTokenInfo getTokenInfo() {
        return this.tokenInfo;
    }

    public void setTokenInfo(AnalyticsTokenInfo tokenInfo) {
        this.tokenInfo = tokenInfo;
    }
}

