/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WebServiceAPIControl
extends Composite
implements EventHandler {
    private static final int DEFAULT_REQUEST_METHOD_SELECTION_INDEX = 0;
    private CCombo cbRequestMethod;
    private Text txtRequestURL;
    private ToolItem btnSend;
    private GridData layoutData;
    private boolean sendingState;
    private Menu menuSend;
    private MenuItem mniSendAndVerify;
    private ToolItem btnAddRequestToTestCase;
    private Menu menuAddRequestToTestCase;
    private MenuItem mniAddRequestToNewTestCase;
    private MenuItem mniAddRequestToExistingTestCase;
    private ToolItem btnSaveDraft;
    private WebServiceRequestEntity originalWsObject;
    private WebServiceSettingStore store;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();

    public WebServiceAPIControl(Composite parent, WebServiceRequestEntity requestEntity) {
        super(parent, 0);
        this.originalWsObject = requestEntity;
        this.store = this.getWebServiceSettingStore();
        boolean isSOAP = this.isSOAP();
        boolean isDraft = this.isDraft();
        String url = isSOAP ? this.originalWsObject.getWsdlAddress() : this.originalWsObject.getRestUrl();
        this.createControl(url, isDraft);
        this.setInput(isSOAP);
        this.eventBroker.subscribe("WEBSERVICE/UPDATE_METHODS", (EventHandler)this);
    }

    private boolean isSOAP() {
        return "SOAP".equals(this.originalWsObject.getServiceType());
    }

    private boolean isDraft() {
        return this.originalWsObject instanceof DraftWebServiceRequestEntity;
    }

    private void createControl(String url, boolean isDraft) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.cbRequestMethod = new CCombo((Composite)this, 2048);
        this.cbRequestMethod.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridData gdRequestMethod = new GridData(4, 0x1000000, false, false);
        gdRequestMethod.widthHint = 100;
        gdRequestMethod.heightHint = 22;
        this.cbRequestMethod.setLayoutData((Object)gdRequestMethod);
        this.cbRequestMethod.setEditable(true);
        this.txtRequestURL = new Text((Composite)this, 2048);
        GridData gdRequestURL = new GridData(4, 0x1000000, true, true);
        gdRequestURL.heightHint = 20;
        this.txtRequestURL.setLayoutData((Object)gdRequestURL);
        this.txtRequestURL.setMessage(StringConstants.PA_LBL_URL);
        if (!StringUtils.trim((String)url).isEmpty()) {
            this.txtRequestURL.setText(url);
        }
        ToolBar toolbar = new ToolBar((Composite)this, 131072);
        this.btnSend = new ToolItem(toolbar, 4);
        this.setSendButtonState(false);
        this.menuSend = new Menu((Control)this.btnSend.getParent().getShell());
        this.mniSendAndVerify = new MenuItem(this.menuSend, 8);
        this.mniSendAndVerify.setText(StringConstants.MENU_ITEM_TEST_REQUEST_AND_VERIFY);
        this.mniSendAndVerify.setID(0);
        this.btnSend.setData((Object)this.menuSend);
        if (!isDraft) {
            this.btnAddRequestToTestCase = new ToolItem(toolbar, 4);
            this.btnAddRequestToTestCase.setImage(ImageConstants.WS_ADD_TO_TEST_CASE_24);
            this.menuAddRequestToTestCase = new Menu((Control)this.btnAddRequestToTestCase.getParent().getShell());
            this.mniAddRequestToNewTestCase = new MenuItem(this.menuAddRequestToTestCase, 8);
            this.mniAddRequestToNewTestCase.setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_NEW_TEST_CASE);
            this.mniAddRequestToNewTestCase.setID(0);
            this.mniAddRequestToExistingTestCase = new MenuItem(this.menuAddRequestToTestCase, 8);
            this.mniAddRequestToExistingTestCase.setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_EXISTING_TEST_CASE);
            this.mniAddRequestToExistingTestCase.setID(1);
            this.btnAddRequestToTestCase.setData((Object)this.menuAddRequestToTestCase);
        }
        if (isDraft) {
            this.btnSaveDraft = new ToolItem(toolbar, 8);
            this.btnSaveDraft.setImage(ImageConstants.IMG_24_SAVE);
            this.btnSaveDraft.setToolTipText(ComposerWebserviceMessageConstants.BTN_SAVE_DRAFT_REQUEST);
        }
        toolbar.setLayoutData((Object)new GridData(0x1000000, 131072, false, true));
    }

    public void addRequestMethodFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.cbRequestMethod.addFocusListener(focusListener);
    }

    public void addRequestMethodModifyListener(ModifyListener modifyListener) {
        if (modifyListener == null) {
            return;
        }
        this.cbRequestMethod.addModifyListener(modifyListener);
    }

    public void addRequestMethodSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.cbRequestMethod.addSelectionListener(selectionListener);
    }

    public void addRequestURLModifyListener(ModifyListener modifyListener) {
        if (modifyListener == null) {
            return;
        }
        this.txtRequestURL.addModifyListener(modifyListener);
    }

    public void addSendSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnSend.addSelectionListener(selectionListener);
    }

    public void addSendAndVerifySelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniSendAndVerify.addSelectionListener(selectionListener);
    }

    public void addAddRequestToTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnAddRequestToTestCase.addSelectionListener(selectionListener);
    }

    public void addAddRequestToNewTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniAddRequestToNewTestCase.addSelectionListener(selectionListener);
    }

    public void addAddRequestToExistingTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniAddRequestToExistingTestCase.addSelectionListener(selectionListener);
    }

    public void addSaveDraftSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnSaveDraft.addSelectionListener(selectionListener);
    }

    private void setInput(boolean isSOAP) {
        this.cbRequestMethod.setItems(isSOAP ? WebServiceRequestEntity.SOAP_REQUEST_METHODS : this.getRestRequestMethods());
        this.cbRequestMethod.select(0);
        if (!isSOAP) {
            this.cbRequestMethod.setEditable(true);
            this.cbRequestMethod.setText(this.originalWsObject.getRestRequestMethod());
        }
    }

    private String[] getRestRequestMethods() {
        List methods;
        try {
            methods = this.store.getWebServiceMethods();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            methods = this.store.getDefaultWebServiceMethods();
        }
        return (String[])methods.stream().map(WebServiceMethod::getName).toArray(String[]::new);
    }

    private WebServiceSettingStore getWebServiceSettingStore() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return WebServiceSettingStore.create((String)project.getFolderLocation());
    }

    public void setRequestMethodSelection(int index) {
        this.cbRequestMethod.select(index);
    }

    public int getSelectedRequestMethodIndex() {
        return this.cbRequestMethod.getSelectionIndex();
    }

    public String getRequestMethod() {
        return this.cbRequestMethod.getText();
    }

    public String getRequestURL() {
        return this.txtRequestURL.getText();
    }

    public void setLayoutDataColumnsSpan(int numberOfColumn) {
        this.layoutData.horizontalSpan = numberOfColumn;
        this.layout();
    }

    public CCombo getRequestMethodControl() {
        return this.cbRequestMethod;
    }

    public Text getRequestURLControl() {
        return this.txtRequestURL;
    }

    public ToolItem getSendControl() {
        return this.btnSend;
    }

    protected void checkSubclass() {
    }

    public void setSendButtonState(boolean sendingState) {
        this.sendingState = sendingState;
        if (this.sendingState) {
            this.btnSend.setToolTipText(StringConstants.STOP);
            this.btnSend.setImage(ImageConstants.IMG_24_STOP);
        } else {
            this.btnSend.setToolTipText(ComposerWebserviceMessageConstants.BTN_SEND_TEST_REQUEST);
            this.btnSend.setImage(ImageConstants.IMG_24_PLAY);
        }
        this.btnSend.getParent().update();
    }

    public boolean getSendingState() {
        return this.sendingState;
    }

    public Menu getSendMenu() {
        return this.menuSend;
    }

    public Menu getAddRequestToTestCaseMenu() {
        return this.menuAddRequestToTestCase;
    }

    public void handleEvent(Event event) {
        if ("WEBSERVICE/UPDATE_METHODS".equals(event.getTopic()) && !this.isSOAP()) {
            this.cbRequestMethod.setItems(this.getRestRequestMethods());
        }
    }
}

