/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.util.groovy.editor;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parts.RestServicePart;
import com.kms.katalon.composer.webservice.parts.SoapServicePart;
import com.kms.katalon.composer.webservice.parts.WSRequestChildPart;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class WSRequestPartUI {
    public static final int MAX_LABEL_LENGTH = 40;
    private static final String BUNDLE_URI_WEBSERVICE = "bundleclass://com.kms.katalon.composer.webservice/";
    private static final String WEBSERVICE_REST_OBJECT_PART_URI = "bundleclass://com.kms.katalon.composer.webservice/" + RestServicePart.class.getName();
    private static final String WEBSERVICE_SOAP_OBJECT_PART_URI = "bundleclass://com.kms.katalon.composer.webservice/" + SoapServicePart.class.getName();
    private static final String CHILD_PART_OBJECT_URI = "bundleclass://com.kms.katalon.composer.webservice/" + WSRequestChildPart.class.getName();
    private WebServiceRequestEntity requestObject;
    private MCompositePart compositePart;
    private MPart apiControlsPart;
    private MPartStack bottomLeftPartStack;
    private MPart authorizationPart;
    private MPart headersPart;
    private MPart bodyPart;
    private MPart variablePart;
    private MPart variableEditorPart;
    private MCompositePart verificationPart;
    private MPart scriptEditorPart;
    private MPart snippetPart;
    private MPart responsePart;
    private CTabFolder tabFolder;
    private MPartSashContainer leftPartSashContainer;
    private MPart verificationToolbarPart;

    private WSRequestPartUI(MPartStack stack, WebServiceRequestEntity requestObject) throws IOException, CoreException {
        EPartService partService = PartServiceSingleton.getInstance().getPartService();
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        this.requestObject = requestObject;
        String compositePartId = this.getCompositePartId(requestObject);
        this.compositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
        this.compositePart.setElementId(compositePartId);
        if (requestObject instanceof DraftWebServiceRequestEntity) {
            String label = WSRequestPartUI.getShortenLabel(requestObject);
            this.compositePart.setLabel("(Draft) " + label);
        } else {
            this.compositePart.setLabel(requestObject.getName());
        }
        this.compositePart.setCloseable(true);
        if ("SOAP".equals(requestObject.getServiceType())) {
            this.compositePart.setContributionURI(WEBSERVICE_SOAP_OBJECT_PART_URI);
        } else {
            this.compositePart.setContributionURI(WEBSERVICE_REST_OBJECT_PART_URI);
        }
        this.compositePart.setIconURI(ImageConstants.URL_16_WS_TEST_OBJECT);
        if (requestObject instanceof DraftWebServiceRequestEntity) {
            this.compositePart.setTooltip("(Draft) " + ((DraftWebServiceRequestEntity)requestObject).getNameAsUrl());
        } else {
            this.compositePart.setTooltip(requestObject.getIdForDisplay());
        }
        this.compositePart.getTags().add("removeOnHide");
        stack.getChildren().add(this.compositePart);
        String mainPartSashContainerId = this.getMainPartSashContainerId(requestObject);
        MPartSashContainer mainPartSashContainer = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
        mainPartSashContainer.setElementId(mainPartSashContainerId);
        mainPartSashContainer.setHorizontal(true);
        this.compositePart.getChildren().add(mainPartSashContainer);
        String leftPartSashContainerId = this.getLeftPartSashContainerId(requestObject);
        this.leftPartSashContainer = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
        this.leftPartSashContainer.setElementId(leftPartSashContainerId);
        this.leftPartSashContainer.setContainerData("6500");
        this.leftPartSashContainer.setHorizontal(false);
        mainPartSashContainer.getChildren().add(this.leftPartSashContainer);
        String apiControlsPartId = this.getApiControlsPartId(requestObject);
        this.apiControlsPart = (MPart)modelService.createModelElement(MPart.class);
        this.apiControlsPart.setElementId(apiControlsPartId);
        this.apiControlsPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.apiControlsPart.getTags().add("NoMove");
        this.leftPartSashContainer.getChildren().add(this.apiControlsPart);
        String bottomLeftPartStackId = this.getBottomLeftPartStackId(requestObject);
        this.bottomLeftPartStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        this.bottomLeftPartStack.setElementId(bottomLeftPartStackId);
        this.bottomLeftPartStack.getTags().add("NoMove");
        this.leftPartSashContainer.getChildren().add(this.bottomLeftPartStack);
        String authorizationPartId = this.getAuthorizationPartId(requestObject);
        this.authorizationPart = (MPart)modelService.createModelElement(MPart.class);
        this.authorizationPart.setElementId(authorizationPartId);
        this.authorizationPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.authorizationPart.setLabel(ComposerWebserviceMessageConstants.TAB_AUTHORIZATION);
        this.authorizationPart.setCloseable(false);
        this.bottomLeftPartStack.getChildren().add(this.authorizationPart);
        String headersPartId = this.getHeadersPartId(requestObject);
        this.headersPart = (MPart)modelService.createModelElement(MPart.class);
        this.headersPart.setElementId(headersPartId);
        this.headersPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.headersPart.setLabel(StringConstants.PA_LBL_HTTP_HEADER);
        this.headersPart.setCloseable(false);
        this.headersPart.getTags().add("NoMove");
        this.bottomLeftPartStack.getChildren().add(this.headersPart);
        String bodyPartId = this.getBodyPartId(requestObject);
        this.bodyPart = (MPart)modelService.createModelElement(MPart.class);
        this.bodyPart.setElementId(bodyPartId);
        this.bodyPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.bodyPart.setLabel(StringConstants.PA_LBL_HTTP_BODY);
        this.bodyPart.setCloseable(false);
        this.bodyPart.getTags().add("NoMove");
        this.bottomLeftPartStack.getChildren().add(this.bodyPart);
        String verificationPartId = this.getVerificationPartId(requestObject);
        this.verificationPart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
        this.verificationPart.setElementId(verificationPartId);
        this.verificationPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.verificationPart.setLabel(StringConstants.PA_LBL_VERIFICATION);
        this.verificationPart.setCloseable(false);
        this.verificationPart.getTags().add("NoMove");
        this.bottomLeftPartStack.getChildren().add(this.verificationPart);
        String verificationPartSashContainerId = this.getVerificationPartSashContainerId(requestObject);
        MPartSashContainer verificationPartSashContainer = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
        verificationPartSashContainer.setElementId(verificationPartSashContainerId);
        verificationPartSashContainer.setHorizontal(true);
        verificationPartSashContainer.getTags().add("NoMove");
        this.verificationPart.getChildren().add(verificationPartSashContainer);
        String scriptEditorPartId = this.getScriptEditorPartId(requestObject);
        IFile tempScriptFile = this.createTempScriptFile(requestObject);
        tempScriptFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        this.scriptEditorPart = editor.createEditorPart((IFile)tempScriptFile, (EPartService)partService);
        this.scriptEditorPart.setElementId(scriptEditorPartId);
        verificationPartSashContainer.getChildren().add(this.scriptEditorPart);
        String snippetPartId = this.getSnippetPartId(requestObject);
        this.snippetPart = (MPart)modelService.createModelElement(MPart.class);
        this.snippetPart.setElementId(snippetPartId);
        this.snippetPart.setContributionURI(CHILD_PART_OBJECT_URI);
        verificationPartSashContainer.getChildren().add(this.snippetPart);
        String verificationToolbarPartId = this.getVerificationToolbarPartId(requestObject);
        this.verificationToolbarPart = (MPart)modelService.createModelElement(MPart.class);
        this.verificationToolbarPart.setElementId(verificationToolbarPartId);
        this.verificationToolbarPart.setContributionURI(CHILD_PART_OBJECT_URI);
        String variablePartId = this.getVariablePartId(requestObject);
        this.variablePart = (MPart)modelService.createModelElement(MPart.class);
        this.variablePart.setElementId(variablePartId);
        this.variablePart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.variablePart.setLabel(StringConstants.PA_LBL_VARIABLE);
        this.variablePart.setCloseable(false);
        this.variablePart.getTags().add("NoMove");
        this.bottomLeftPartStack.getChildren().add(this.variablePart);
        String variableEditorPartID = this.getVariableEditorPartID(requestObject);
        this.variableEditorPart = (MPart)modelService.createModelElement(MPart.class);
        this.variableEditorPart.setElementId(variableEditorPartID);
        this.variableEditorPart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.variableEditorPart.setLabel(StringConstants.PA_LBL_VARIABLE_EDITOR);
        this.variableEditorPart.setCloseable(false);
        this.variableEditorPart.getTags().add("NoMove");
        this.bottomLeftPartStack.getChildren().add(this.variableEditorPart);
        String responsePartId = this.getResponsePartId(requestObject);
        this.responsePart = (MPart)modelService.createModelElement(MPart.class);
        this.responsePart.setElementId(responsePartId);
        this.responsePart.setContributionURI(CHILD_PART_OBJECT_URI);
        this.responsePart.setContainerData("3500");
        mainPartSashContainer.getChildren().add(this.responsePart);
        partService.activate((MPart)this.compositePart);
        partService.activate(this.apiControlsPart);
        partService.activate(this.responsePart);
        partService.activate(this.authorizationPart);
        partService.activate(this.headersPart);
        partService.activate(this.bodyPart);
        partService.activate(this.scriptEditorPart);
        partService.activate(this.snippetPart);
        partService.activate(this.variablePart);
        partService.activate(this.variableEditorPart);
        this.tabFolder = (CTabFolder)this.bottomLeftPartStack.getWidget();
        this.calculateWeightsForVerificationChildParts();
        this.initComponents();
    }

    public static String getShortenLabel(WebServiceRequestEntity requestObject) {
        String label = ((DraftWebServiceRequestEntity)requestObject).getNameAsUrl();
        label = label.length() <= 40 ? label : String.valueOf(label.substring(0, 40)) + "...";
        return label;
    }

    private IFile createTempScriptFile(WebServiceRequestEntity requestObject) throws IOException, CoreException {
        String wsTempFolderPath = ProjectController.getInstance().getWebServiceTempDir();
        File wsTempFolder = new File(wsTempFolderPath);
        if (!wsTempFolder.exists()) {
            wsTempFolder.mkdirs();
        }
        File tempFile = File.createTempFile("kat-", ".groovy", wsTempFolder);
        ProjectEntity projectEntity = requestObject.getProject();
        Path location = new Path(tempFile.getAbsolutePath());
        IFile tempIFile = GroovyUtil.getGroovyProject((ProjectEntity)projectEntity).getFile(location.lastSegment());
        tempIFile.createLink((IPath)location, 0, null);
        String script = requestObject.getVerificationScript();
        if (!StringUtils.isBlank((CharSequence)script)) {
            tempIFile.setContents((InputStream)new ByteArrayInputStream(script.getBytes()), true, false, null);
        }
        return tempIFile;
    }

    private void initComponents() {
        final WebServicePart webServicePart = (WebServicePart)this.compositePart.getObject();
        webServicePart.setOriginalWsObject(this.requestObject);
        webServicePart.initComponents(this);
        this.calculateLeftPartsWeight();
        webServicePart.getComposite().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Composite wsComposite = webServicePart.getComposite();
                if (wsComposite == null || wsComposite.isDisposed()) {
                    return;
                }
                WSRequestPartUI.this.calculateLeftPartsWeight();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        Composite verificationPartComposite = this.getVerificationPartComposite();
        verificationPartComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                WSRequestPartUI.this.calculateWeightsForVerificationChildParts();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void calculateLeftPartsWeight() {
        WSRequestChildPart apiControlsPartObject = (WSRequestChildPart)this.apiControlsPart.getObject();
        if (apiControlsPartObject == null) {
            return;
        }
        Point apiControlsCompositeSize = apiControlsPartObject.getComposite().getChildren()[0].computeSize(-1, -1);
        int totalHeight = ((WebServicePart)this.compositePart.getObject()).getComposite().getSize().y;
        long apiControlsPartWeight = Math.round((double)apiControlsCompositeSize.y / (double)totalHeight * 1000.0);
        this.apiControlsPart.setContainerData(String.valueOf(apiControlsPartWeight));
        this.bottomLeftPartStack.setContainerData(String.valueOf(1000L - apiControlsPartWeight));
    }

    private void calculateWeightsForVerificationChildParts() {
        Composite verificationPartComposite = this.getVerificationPartComposite();
        int verificationPartWidth = verificationPartComposite.getSize().x;
        long snippetPartWeight = Math.round(250.0 / (double)verificationPartWidth * 1000.0);
        long editorPartWeight = 1000L - snippetPartWeight;
        this.snippetPart.setContainerData(String.valueOf(snippetPartWeight));
        this.scriptEditorPart.setContainerData(String.valueOf(editorPartWeight));
    }

    public static WSRequestPartUI create(WebServiceRequestEntity requestObject, MPartStack stack) throws IOException, CoreException {
        return new WSRequestPartUI(stack, requestObject);
    }

    private String getCompositePartId(WebServiceRequestEntity requestObject) {
        if (requestObject instanceof DraftWebServiceRequestEntity) {
            return EntityPartUtil.getDraftRequestPartId((String)((DraftWebServiceRequestEntity)requestObject).getDraftUid());
        }
        return EntityPartUtil.getTestObjectPartId((String)requestObject.getId());
    }

    private String getMainPartSashContainerId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getCompositePartId(requestObject)) + ".partsash";
    }

    private String getLeftPartSashContainerId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getMainPartSashContainerId(requestObject)) + ".left";
    }

    private String getApiControlsPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getLeftPartSashContainerId(requestObject)) + ".top";
    }

    private String getBottomLeftPartStackId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getLeftPartSashContainerId(requestObject)) + ".bottom";
    }

    private String getAuthorizationPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".authorization";
    }

    private String getHeadersPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".headers";
    }

    private String getBodyPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".body";
    }

    private String getVariablePartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".variable";
    }

    private String getVariableEditorPartID(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".variableEditor";
    }

    private String getVerificationPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getBottomLeftPartStackId(requestObject)) + ".verification";
    }

    private String getVerificationPartSashContainerId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getVerificationPartId(requestObject)) + ".partsash";
    }

    private String getScriptEditorPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getVerificationPartSashContainerId(requestObject)) + ".editor";
    }

    private String getSnippetPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getVerificationPartSashContainerId(requestObject)) + ".snippet";
    }

    private String getVerificationToolbarPartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getVerificationPartSashContainerId(requestObject)) + ".toolbar";
    }

    private String getResponsePartId(WebServiceRequestEntity requestObject) {
        return String.valueOf(this.getMainPartSashContainerId(requestObject)) + ".response";
    }

    public MCompositePart getCompositePart() {
        return this.compositePart;
    }

    public MPart getApiControlsPart() {
        return this.apiControlsPart;
    }

    public MPart getAuthorizationPart() {
        return this.authorizationPart;
    }

    public MPart getHeadersPart() {
        return this.headersPart;
    }

    public MPart getBodyPart() {
        return this.bodyPart;
    }

    public MPart getVariablePart() {
        return this.variablePart;
    }

    public MPart getVariableEditorPart() {
        return this.variableEditorPart;
    }

    public MCompositePart getVerificationPart() {
        return this.verificationPart;
    }

    public MPart getScriptEditorPart() {
        return this.scriptEditorPart;
    }

    public MPart getSnippetPart() {
        return this.snippetPart;
    }

    public MPart getResponsePart() {
        return this.responsePart;
    }

    public Composite getApiControlsPartComposite() {
        return this.getPartComposite(this.apiControlsPart);
    }

    public Composite getAuthorizationPartComposite() {
        return this.getPartComposite(this.authorizationPart);
    }

    public Composite getHeadersPartComposite() {
        return this.getPartComposite(this.headersPart);
    }

    public Composite getBodyPartComposite() {
        return this.getPartComposite(this.bodyPart);
    }

    public Composite getVariablePartComposite() {
        return this.getPartComposite(this.variablePart);
    }

    public Composite getVariableEditorPartComposite() {
        return this.getPartComposite(this.variableEditorPart);
    }

    public Composite getVerificationPartComposite() {
        return this.getPartComposite((MPart)this.verificationPart);
    }

    public Composite getSnippetPartComposite() {
        return this.getPartComposite(this.snippetPart);
    }

    public Composite getVerificationToolbarPartComposite() {
        return this.getPartComposite(this.verificationToolbarPart);
    }

    public Composite getResponsePartComposite() {
        return this.getPartComposite(this.responsePart);
    }

    private Composite getPartComposite(MPart part) {
        Object partElement = part.getObject();
        if (partElement instanceof WSRequestChildPart) {
            return ((WSRequestChildPart)partElement).getComposite();
        }
        return null;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public CTabItem getAuthorizationTab() {
        return this.tabFolder.getItem(0);
    }

    public CTabItem getHeadersTab() {
        return this.tabFolder.getItem(1);
    }

    public CTabItem getBodyTab() {
        return this.tabFolder.getItem(2);
    }

    public CTabItem getVerificationTab() {
        return this.tabFolder.getItem(3);
    }

    public CTabItem getVariableTab() {
        return this.tabFolder.getItem(4);
    }

    public CTabItem getVariableEditorTab() {
        return this.tabFolder.getItem(5);
    }

    public void setSelectedTab(CTabItem tabItem) {
        this.tabFolder.setSelection(tabItem);
    }
}

