/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewHistoryRequestDialog
extends CustomTitleAreaDialog {
    private static final int MAX_LINE_NUMBER = 4;
    private Label txtParentFolder;
    private Label txtRequestType;
    private Label txtRequestMethod;
    private Label txtUrl;
    private Text txtName;
    private Text txtDescription;
    private Button btnBrowseFolder;
    private FolderEntity parentFolder;
    private Composite container;
    private NewHistoryRequestResult result;
    private WebServiceRequestEntity draftRequest;
    private List<FileEntity> sibblingEntities;

    public NewHistoryRequestDialog(Shell parentShell, WebServiceRequestEntity draftRequest) {
        super(parentShell);
        this.draftRequest = draftRequest;
    }

    protected void registerControlModifyListeners() {
        this.btnBrowseFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHistoryRequestDialog.this.selectObjectRepositoryFolder();
            }
        });
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewHistoryRequestDialog.this.checkNewName(NewHistoryRequestDialog.this.txtName.getText());
            }
        });
    }

    private void selectObjectRepositoryFolder() {
        try {
            EntityProvider entityProvider = new EntityProvider();
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(this.getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)entityProvider, (AbstractEntityViewerFilter)new ObjectRepositoryFolderViewerFilter(entityProvider));
            dialog.setAllowMultiple(false);
            dialog.setTitle("Select a folder");
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            FolderEntity rootFolder = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
            FolderTreeEntity rootFolderTreeEntity = new FolderTreeEntity(rootFolder, null);
            FolderTreeEntity parentTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)this.parentFolder, (FolderEntity)rootFolder);
            dialog.setInitialSelection((Object)parentTreeEntity);
            dialog.setInput(Arrays.asList(rootFolderTreeEntity));
            if (dialog.open() == 0) {
                FolderTreeEntity folderTree = (FolderTreeEntity)dialog.getFirstResult();
                this.parentFolder = folderTree.getObject();
                this.sibblingEntities = FolderController.getInstance().getChildren(this.parentFolder);
                this.txtParentFolder.setText(this.parentFolder.getIdForDisplay());
                this.checkNewName(this.txtName.getText());
                this.container.layout(true);
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    protected void setInput() {
        try {
            this.setMessage("Enter a Web Service Request name", 1);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            this.parentFolder = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
            this.sibblingEntities = FolderController.getInstance().getChildren(this.parentFolder);
            this.txtName.setText(this.getSuggestion("New Request"));
            this.txtParentFolder.setText(this.parentFolder.getIdForDisplay());
            WebServiceRequestEntity request = this.draftRequest;
            String serviceType = request.getServiceType();
            this.txtRequestType.setText("RESTful".equals(serviceType) ? "REST" : serviceType);
            this.txtRequestMethod.setText("RESTful".equals(serviceType) ? request.getRestRequestMethod() : request.getSoapRequestMethod());
            String url = "RESTful".equals(serviceType) ? request.getRestUrl() : request.getWsdlAddress();
            this.txtUrl.setText(url.replace("&", "&&"));
            this.container.layout(true);
            this.getShell().setSize(this.getInitialSize());
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    protected Composite createContentArea(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 15;
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        Label lblName = new Label(this.container, 0);
        lblName.setText("Name");
        this.txtName = new Text(this.container, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblParentFolder = new Label(this.container, 0);
        lblParentFolder.setText("Folder");
        Composite parentFolderComposite = new Composite(this.container, 0);
        parentFolderComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout glParentFolder = new GridLayout(2, false);
        glParentFolder.marginWidth = 0;
        glParentFolder.marginHeight = 0;
        parentFolderComposite.setLayout((Layout)glParentFolder);
        this.txtParentFolder = new Label(parentFolderComposite, 64);
        this.txtParentFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnBrowseFolder = new Button(parentFolderComposite, 0x800000);
        this.btnBrowseFolder.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnBrowseFolder.setText("Browse...");
        Label lblRequestType = new Label(this.container, 0);
        lblRequestType.setText("Request Type");
        this.txtRequestType = new Label(this.container, 0);
        this.txtRequestType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblRequestMethod = new Label(this.container, 0);
        lblRequestMethod.setText("Request Method");
        this.txtRequestMethod = new Label(this.container, 0);
        this.txtRequestMethod.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblUrl = new Label(this.container, 0);
        lblUrl.setLayoutData((Object)new GridData(4, 128, true, false));
        lblUrl.setText("URL");
        this.txtUrl = new Label(this.container, 64);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setText("Description");
        lblDescription.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtDescription = new Text(this.container, 2562);
        GridData gridData = new GridData(4, 128, true, false);
        GC graphicContext = new GC((Drawable)this.txtDescription);
        FontMetrics fm = graphicContext.getFontMetrics();
        gridData.heightHint = 4 * fm.getHeight();
        gridData.widthHint = 300;
        this.txtDescription.setLayoutData((Object)gridData);
        graphicContext.dispose();
        return this.container;
    }

    private boolean isNameDupplicated(String newName) {
        return this.sibblingEntities.parallelStream().filter(l -> l.getName().equals(newName)).findAny().isPresent();
    }

    private String getSuggestion(String suggestion) {
        String newName = suggestion;
        int index = 0;
        while (this.isNameDupplicated(newName)) {
            newName = String.format("%s %d", suggestion, ++index);
        }
        return newName;
    }

    private void checkNewName(String newName) {
        if (this.isNameDupplicated(newName)) {
            this.setMessage(GlobalMessageConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            EntityNameController.getInstance().validateName(newName);
            this.setMessage("Enter a Web Serivce Request name", 1);
            this.getButton(0).setEnabled(true);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        this.result = new NewHistoryRequestResult();
        this.result.name = this.txtName.getText();
        this.result.description = this.txtDescription.getText();
        this.result.parentFolder = this.parentFolder;
        super.okPressed();
    }

    public NewHistoryRequestResult getResult() {
        return this.result;
    }

    public String getDialogTitle() {
        return "Save to Object Repository";
    }

    protected Point getInitialSize() {
        Point preferredSize = super.getInitialSize();
        return new Point(Math.min(500, preferredSize.x), preferredSize.y);
    }

    public static class NewHistoryRequestResult {
        private String name;
        private String description;
        private FolderEntity parentFolder;

        public String getName() {
            return this.name;
        }

        public FolderEntity getParentFolder() {
            return this.parentFolder;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ObjectRepositoryFolderViewerFilter
    extends EntityViewerFilter {
        public ObjectRepositoryFolderViewerFilter(EntityProvider entityProvider) {
            super(entityProvider);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return super.select(viewer, parentElement, element) && element instanceof FolderTreeEntity;
        }
    }
}

