/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parser.WSDLParserUtil;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.wsdl.WSDLException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportWebServiceObjectsFromWSDLDialog
extends CustomTitleAreaDialog {
    private List<WebServiceRequestEntity> soapWebServiceRequestEntities;
    private List<WebServiceRequestEntity> soap12WebServiceRequestEntities;
    private String directory = "";

    public ImportWebServiceObjectsFromWSDLDialog(Shell parentShell) {
        super(parentShell);
        Trackings.trackOpenImportingWsdl();
    }

    private void createSoapWebServiceRequestEntities() throws InvocationTargetException, InterruptedException, WSDLException {
        this.soapWebServiceRequestEntities = WSDLParserUtil.newWSTestObjectsFromWSDL("SOAP", this.directory);
    }

    private void createSoap12WebServiceRequestEntities() throws InvocationTargetException, InterruptedException, WSDLException {
        this.soap12WebServiceRequestEntities = WSDLParserUtil.newWSTestObjectsFromWSDL("SOAP12", this.directory);
    }

    private void createWebServiceRequestEntities() throws InvocationTargetException, InterruptedException, WSDLException {
        this.createSoapWebServiceRequestEntities();
        this.createSoap12WebServiceRequestEntities();
    }

    public List<WebServiceRequestEntity> getWebServiceRequestEntities(String requestMethod) {
        switch (requestMethod) {
            case "SOAP": {
                return this.soapWebServiceRequestEntities;
            }
            case "SOAP12": {
                return this.soap12WebServiceRequestEntities;
            }
        }
        return null;
    }

    protected void okPressed() {
        Button ok = this.getButton(0);
        boolean closeTheDialog = true;
        try {
            try {
                this.createWebServiceRequestEntities();
            }
            catch (Exception ex) {
                closeTheDialog = false;
                this.setMessage(StringConstants.EXC_INVALID_WSDL_FILE, 3);
                if (ex instanceof WSDLException) {
                    LoggerSingleton.getInstance();
                    LoggerSingleton.logError((String)("Method getOperationNamesByRequestMethod has thrown WSDLException: " + ex.getCause()));
                }
                if (ex instanceof InterruptedException) {
                    LoggerSingleton.getInstance();
                    LoggerSingleton.logError((String)("Method generateInputSOAPMessageText in runnable thread was interrupted:" + ex.getCause()));
                }
                if (ex instanceof InvocationTargetException) {
                    Throwable cause = ex.getCause();
                    if (cause == null) {
                        throw new IllegalStateException("Got InvocationTargetException, but the cause is null.", ex);
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Exception) {
                        LoggerSingleton.getInstance();
                        LoggerSingleton.logError((String)("Invocation failed with cause: " + cause));
                    } else {
                        LoggerSingleton.getInstance();
                        LoggerSingleton.logError((String)("Invocation failed with error: " + cause));
                    }
                }
                ok.setEnabled(false);
                if (closeTheDialog) {
                    super.okPressed();
                }
            }
        }
        finally {
            if (closeTheDialog) {
                super.okPressed();
            }
        }
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_WSDL);
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_WSDL);
        this.setMessage(StringConstants.DIA_MSG_IMPORT_WEBSERVICE_REQ_WSDL, 1);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("URL : ");
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        Composite methodComposite = new Composite(composite, 0);
        GridLayout glMethodComposite = new GridLayout();
        methodComposite.setLayout((Layout)glMethodComposite);
        Button button = new Button(methodComposite, 8);
        button.setText(StringConstants.BROWSE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog directoryDialog = new FileDialog(ImportWebServiceObjectsFromWSDLDialog.this.getParentShell());
                String filePath = directoryDialog.open();
                text.setText(filePath);
                ImportWebServiceObjectsFromWSDLDialog.this.directory = filePath;
            }
        });
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button ok = ImportWebServiceObjectsFromWSDLDialog.this.getButton(0);
                if (!ok.isEnabled()) {
                    ok.setEnabled(true);
                }
                ImportWebServiceObjectsFromWSDLDialog.this.directory = ((Text)e.widget).getText();
            }
        };
        text.addModifyListener(listener);
        this.messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://www.w3.org/TR/wsdl/");
            }
        });
        return composite;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(75);
        return size;
    }

    public String getWSDLSpecLocation() {
        return this.directory;
    }
}

