/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.view.ImportWebServiceObjectsFromSwaggerDialog;
import com.kms.katalon.composer.webservice.view.ImportWebServiceObjectsFromWSDLDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ApiQuickStartDialog
extends Dialog {
    private static final Color RIGHT_PART_BACKGROUND_COLOR = ColorUtil.getColor((String)"#F7F7F7");
    private static final Point LEFT_PART_SIZE = new Point(1000, 2150);
    private static final Point QUICKSTART_ITEM_SIZE = new Point(200, 47);
    private ITreeEntity parentTreeEntity;
    private ProjectType projectType;

    public ApiQuickStartDialog(ITreeEntity parentTreeEntity, Shell parentShell, ProjectType projectType) {
        super(parentShell);
        this.parentTreeEntity = parentTreeEntity;
        this.projectType = projectType;
    }

    private Point getLeftPartSize() {
        switch (this.projectType) {
            case MOBILE: {
                return new Point(1000, 2150);
            }
            case WEBSERVICE: {
                return new Point(1000, 1850);
            }
        }
        return new Point(1000, 1700);
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData gdBody = new GridData(4, 4, true, true);
        body.setLayoutData((Object)gdBody);
        GridLayout glBody = new GridLayout(2, false);
        glBody.marginWidth = 0;
        glBody.marginHeight = 0;
        glBody.horizontalSpacing = 0;
        glBody.verticalSpacing = 0;
        body.setLayout((Layout)glBody);
        switch (this.projectType) {
            case WEBSERVICE: {
                this.createLeftPart(body);
                this.createRightPart(body);
                break;
            }
            case WEBUI: 
            case GENERIC: {
                this.createLeftPart(body);
                break;
            }
            case MOBILE: {
                this.createLeftPart(body);
                break;
            }
        }
        return super.createDialogArea(parent);
    }

    public void createLeftPart(Composite parent) {
        ScrolledComposite c1 = new ScrolledComposite(parent, 0x1000B00);
        c1.setExpandHorizontal(true);
        c1.setExpandVertical(true);
        c1.setMinSize(this.getLeftPartSize());
        Composite leftComposite = new Composite((Composite)c1, 0);
        c1.setContent((Control)leftComposite);
        GridLayout glLeft = new GridLayout(1, false);
        glLeft.marginWidth = 0;
        glLeft.marginHeight = 0;
        glLeft.marginLeft = 0;
        glLeft.horizontalSpacing = 0;
        glLeft.verticalSpacing = 0;
        leftComposite.setLayout((Layout)glLeft);
        GridData gdLeft = new GridData(4, 4, true, true);
        c1.setLayoutData((Object)gdLeft);
        c1.setVisible(true);
        switch (this.projectType) {
            case WEBSERVICE: {
                Image backgroundImg = ImageConstants.API_QUICKSTART_BACKGROUND_LEFT;
                leftComposite.setBackgroundImage(backgroundImg);
                break;
            }
            case WEBUI: 
            case GENERIC: {
                Image backgroundWImg = ImageConstants.API_QUICKSTART_BACKGROUND_WEB_LEFT;
                leftComposite.setBackgroundImage(backgroundWImg);
                break;
            }
            case MOBILE: {
                Image backgroundMImg = ImageConstants.API_QUICKSTART_BACKGROUND_MOBILE_LEFT;
                leftComposite.setBackgroundImage(backgroundMImg);
                break;
            }
        }
    }

    public void createRightPart(Composite parent) {
        Composite rightComposite = new Composite(parent, 0);
        GridLayout glRight = new GridLayout(1, false);
        glRight.marginWidth = 0;
        glRight.marginHeight = 0;
        glRight.marginLeft = 0;
        glRight.marginTop = 200;
        rightComposite.setLayout((Layout)glRight);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        rightComposite.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        Composite quickStartItemComposite = new Composite(rightComposite, 0);
        GridLayout glQuickStartItemComposite = new GridLayout(1, false);
        glQuickStartItemComposite.marginWidth = 0;
        glQuickStartItemComposite.marginHeight = 0;
        glQuickStartItemComposite.horizontalSpacing = 0;
        glQuickStartItemComposite.verticalSpacing = 20;
        quickStartItemComposite.setLayout((Layout)glQuickStartItemComposite);
        quickStartItemComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        quickStartItemComposite.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        this.createNewRestRequestItem(quickStartItemComposite);
        this.createNewSoapRequestItem(quickStartItemComposite);
        this.createImportRestRequestItem(quickStartItemComposite);
        this.createImportSoapRequestItem(quickStartItemComposite);
    }

    private Composite createQuickStartItem(Composite parent, Image image, String toolTip, Listener selectionListener) {
        CLabel lblItem = new CLabel(parent, 0);
        GridData gdItem = new GridData(0x1000000, 4, true, false);
        gdItem.widthHint = ApiQuickStartDialog.QUICKSTART_ITEM_SIZE.x;
        gdItem.heightHint = ApiQuickStartDialog.QUICKSTART_ITEM_SIZE.y;
        lblItem.setLayoutData((Object)gdItem);
        lblItem.setToolTipText(toolTip);
        lblItem.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        lblItem.setBackground(image);
        lblItem.setCursor(Display.getCurrent().getSystemCursor(21));
        lblItem.addListener(3, selectionListener);
        return lblItem;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.TITLE_QUICKSTART);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    private Composite createNewRestRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.NEW_DRAFT_REST_REQUEST, StringConstants.QUICKSTART_NEW_DRAFT_REST_REQUEST, e -> this.createNewRestRequest());
        return item;
    }

    private Composite createNewSoapRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.NEW_DRAFT_SOAP_REQUEST, StringConstants.QUICKSTART_NEW_DRAFT_SOAP_REQUEST, e -> this.createNewSoapRequest());
        return item;
    }

    private Composite createImportRestRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.IMPORT_SWAGGER, StringConstants.QUICKSTART_IMPORT_SWAGGER_FROM_FILE_OR_URL, e -> this.importSwaggerFromFileOrUrl());
        return item;
    }

    private Composite createImportSoapRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.IMPORT_WSDL, StringConstants.QUICKSTART_IMPORT_WSDL_FROM_FILE_OR_URL, e -> this.importWsdlFromUrl());
        return item;
    }

    private void createNewRestRequest() {
        DraftWebServiceRequestEntity entity = ObjectRepositoryController.getInstance().newDraftWebServiceEntity(ProjectController.getInstance().getCurrentProject());
        entity.setServiceType("RESTful");
        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/OPEN_DRAFT_WEBSERVICE", (Object)entity);
        Trackings.trackOpenDraftRequest((String)entity.getServiceType(), (String)"apiQuickStart");
        this.close();
    }

    private void createNewSoapRequest() {
        DraftWebServiceRequestEntity entity = ObjectRepositoryController.getInstance().newDraftWebServiceEntity(ProjectController.getInstance().getCurrentProject());
        entity.setServiceType("SOAP");
        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/OPEN_DRAFT_WEBSERVICE", (Object)entity);
        Trackings.trackOpenDraftRequest((String)entity.getServiceType(), (String)"apiQuickStart");
        this.close();
    }

    private void importSwaggerFromFileOrUrl() {
        try {
            FolderEntity parentFolderEntity = (FolderEntity)this.parentTreeEntity.getObject();
            ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
            ImportWebServiceObjectsFromSwaggerDialog dialog = new ImportWebServiceObjectsFromSwaggerDialog(Display.getCurrent().getActiveShell(), parentFolderEntity);
            if (dialog.open() == 0) {
                List<WebServiceRequestEntity> requestEntities = dialog.getWebServiceRequestEntities();
                for (WebServiceRequestEntity entity : requestEntities) {
                    toController.saveNewTestObject((WebElementEntity)entity);
                }
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.parentTreeEntity);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)this.parentTreeEntity);
                this.close();
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void importWsdlFromUrl() {
        try {
            FolderEntity parentFolderEntity = (FolderEntity)this.parentTreeEntity.getObject();
            ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
            ImportWebServiceObjectsFromWSDLDialog dialog = new ImportWebServiceObjectsFromWSDLDialog(Display.getCurrent().getActiveShell());
            String[] requestMethods = new String[]{"SOAP", "SOAP12"};
            if (dialog.open() == 0) {
                int i = 0;
                while (i < requestMethods.length) {
                    String requestMethod = requestMethods[i];
                    List<WebServiceRequestEntity> soapRequestEntities = dialog.getWebServiceRequestEntities(requestMethod);
                    if (soapRequestEntities != null && soapRequestEntities.size() > 0) {
                        FolderEntity folder = FolderController.getInstance().addNewFolder(parentFolderEntity, requestMethod);
                        new FolderTreeEntity(folder, this.parentTreeEntity);
                        for (WebServiceRequestEntity entity : soapRequestEntities) {
                            entity.setElementGuidId(Util.generateGuid());
                            entity.setParentFolder(folder);
                            entity.setProject(folder.getProject());
                            toController.saveNewTestObject((WebElementEntity)entity);
                        }
                    }
                    ++i;
                }
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.parentTreeEntity);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)this.parentTreeEntity);
                this.close();
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Point getInitialSize() {
        int dialogSize = this.projectType == ProjectType.WEBSERVICE ? 1300 : 1000;
        return this.getShell().computeSize(dialogSize, 650, true);
    }
}

