/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.PartImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.http.HTTPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12AddressImpl;
import com.kms.katalon.composer.webservice.util.CustomWSDLReader;
import com.kms.katalon.composer.webservice.util.SafeUtils;
import com.kms.katalon.composer.webservice.util.XmlUtils;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.lang3.StringUtils;
import org.javalite.http.Get;
import org.javalite.http.Http;
import org.javalite.http.Post;
import org.javalite.http.Request;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSDLHelper {
    private static final String THIS_NAMESPACE = "tns";
    private static final String SOAP_HEADER_CONTENT_TYPE_VALUE = "text/xml; charset=utf-8";
    private static final String SOAP12_HEADER_CONTENT_TYPE_VALUE = "application/soap+xml; charset=utf-8";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String SOAP_HEADER_ACTION = "SOAPAction";
    private static final String SOAP = "SOAP";
    private static final String SOAP12 = "SOAP12";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private String url;
    private String authorizationValue;
    private Definition definition;
    private Map<String, PortImpl> portMap;

    private WSDLHelper(String url, String authorizationValue) {
        this.url = url;
        this.authorizationValue = authorizationValue;
    }

    public static WSDLHelper newInstance(String url) {
        return new WSDLHelper(url, null);
    }

    public static WSDLHelper newInstance(String url, String authorizationValue) {
        return new WSDLHelper(url, authorizationValue);
    }

    public Definition getDefinition() throws WSDLException {
        if (this.definition == null) {
            CustomWSDLReader reader = new CustomWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            if (this.authorizationValue == null) {
                this.definition = reader.readWSDL(this.url);
            } else {
                reader.setAuthorizationValue(this.authorizationValue);
                InputStream inputStream = ((Get)Http.get((String)this.url).header("Authorization", this.authorizationValue)).getInputStream();
                this.definition = reader.readWSDL(this.url, new InputSource(inputStream));
            }
        }
        return this.definition;
    }

    public List<QName> getServiceNames() throws WSDLException {
        return new ArrayList<QName>(this.getDefinition().getServices().keySet());
    }

    public ServiceImpl getService() throws WSDLException {
        Collection services = this.getDefinition().getAllServices().values();
        if (services.isEmpty()) {
            return null;
        }
        return (ServiceImpl)new ArrayList(services).get(0);
    }

    public List<PortImpl> getPorts() throws WSDLException {
        ServiceImpl service = this.getService();
        if (service == null) {
            return Collections.emptyList();
        }
        Collection ports = service.getPorts().values();
        if (ports.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<PortImpl>(ports);
    }

    public PortImpl getPortByRequestMethod(String requestMethod) throws WSDLException {
        return this.getPortMap().get(requestMethod);
    }

    public List<BindingImpl> getBindings() throws WSDLException {
        return new ArrayList<BindingImpl>(this.getDefinition().getAllBindings().values());
    }

    public List<QName> getBindingNames() throws WSDLException {
        return new ArrayList<QName>(this.getDefinition().getAllBindings().keySet());
    }

    public Binding getBindingByName(QName bindingName) throws WSDLException {
        return this.getDefinition().getBinding(bindingName);
    }

    public BindingImpl getBindingByRequestMethod(String requestMethod) throws WSDLException {
        PortImpl port = this.getPortByRequestMethod(requestMethod);
        return (BindingImpl)port.getBinding();
    }

    public List<String> getOperationNamesByRequestMethod(String requestMethod) throws WSDLException {
        ArrayList<String> operationNames = new ArrayList<String>();
        this.getOperationsByRequestMethod(requestMethod).forEach(o -> {
            boolean bl = operationNames.add(o.getName());
        });
        return operationNames;
    }

    public List<Operation> getOperationsByRequestMethod(String requestMethod) throws WSDLException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.getBindingOperationsByRequestMethod(requestMethod).forEach(o -> {
            boolean bl = operations.add(o.getOperation());
        });
        return operations;
    }

    public List<BindingOperationImpl> getBindingOperationsByRequestMethod(String requestMethod) throws WSDLException {
        PortImpl port = this.getPortMap().get(requestMethod);
        if (port == null) {
            return Collections.emptyList();
        }
        ArrayList<BindingOperationImpl> bindingOperations = new ArrayList<BindingOperationImpl>();
        bindingOperations.addAll(port.getBinding().getBindingOperations());
        return bindingOperations;
    }

    public Operation getOperationByRequestMethodNName(String requestMethod, String operationName) throws WSDLException {
        return this.getOperationsByRequestMethod(requestMethod).stream().filter(o -> o.getName().equals(operationName)).findFirst().get();
    }

    public String getOperationURI(BindingOperationImpl bindingOperation, String requestMethod) {
        Object action = bindingOperation.getExtensibilityElements().get(0);
        switch (requestMethod.toUpperCase()) {
            case "SOAP": {
                return ((SOAPOperation)action).getSoapActionURI();
            }
            case "SOAP12": {
                return ((SOAP12Operation)action).getSoapActionURI();
            }
            case "GET": 
            case "POST": {
                return ((HTTPOperation)action).getLocationURI();
            }
        }
        return null;
    }

    public String getPortAddressLocation(String requestMethod) throws WSDLException {
        Object address = this.getPortByRequestMethod(requestMethod).getExtensibilityElements().get(0);
        switch (requestMethod.toUpperCase()) {
            case "SOAP": {
                return ((SOAPAddressImpl)address).getLocationURI();
            }
            case "SOAP12": {
                return ((SOAP12AddressImpl)address).getLocationURI();
            }
            case "GET": 
            case "POST": {
                return ((HTTPAddressImpl)address).getLocationURI();
            }
        }
        return null;
    }

    public Map<String, PortImpl> getPortMap() throws WSDLException {
        if (this.portMap == null) {
            this.portMap = new HashMap<String, PortImpl>();
            for (PortImpl p : this.getPorts()) {
                Object portAddress = p.getExtensibilityElements().get(0);
                if (portAddress instanceof SOAPAddressImpl) {
                    this.portMap.put(SOAP, p);
                    continue;
                }
                if (portAddress instanceof SOAP12AddressImpl) {
                    this.portMap.put(SOAP12, p);
                    continue;
                }
                if (!(portAddress instanceof HTTPAddressImpl)) continue;
                HTTPBindingImpl httpBindingImpl = (HTTPBindingImpl)p.getBinding().getExtensibilityElements().get(0);
                this.portMap.put(httpBindingImpl.getVerb().toUpperCase(), p);
            }
        }
        return this.portMap;
    }

    public SOAPMessage generateInputSOAPMessage(String requestMethod, String namespaceURI, String actionUri, String operationName, Map<String, List<String>> paramMap) throws SOAPException, WSDLException {
        SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration(THIS_NAMESPACE, namespaceURI);
        SOAPElement soapBodyElemment = envelope.getBody().addChildElement(operationName, THIS_NAMESPACE);
        if (paramMap.get(operationName) != null) {
            List<String> params = paramMap.get(operationName);
            for (String param : params) {
                soapBodyElemment.addChildElement(param, THIS_NAMESPACE).addTextNode("?");
            }
        } else {
            Input input = this.getOperationByRequestMethodNName(requestMethod, operationName).getInput();
            Collection parts = input.getMessage().getParts().values();
            for (PartImpl part : parts) {
                soapBodyElemment.addChildElement(part.getName(), THIS_NAMESPACE).addTextNode("?");
            }
        }
        MimeHeaders headers = soapMessage.getMimeHeaders();
        headers.addHeader(SOAP_HEADER_ACTION, actionUri);
        soapMessage.saveChanges();
        return soapMessage;
    }

    public Map<String, List<String>> getParamMap() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        try {
            List<String> operationNames = this.getOperationNamesByRequestMethod(SOAP);
            Types types = this.getDefinition().getTypes();
            for (Object obj : SafeUtils.safeList(types.getExtensibilityElements())) {
                Schema schema;
                NodeList nodeList;
                if (obj == null || !(obj instanceof Schema) || (nodeList = (schema = (Schema)obj).getElement().getChildNodes()) == null) continue;
                for (String name : operationNames) {
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    List params = XmlUtils.wrapNodeList(nodeList).stream().filter(a -> a.getNodeType() == 1).filter(a -> {
                        Node node = a.getAttributes().getNamedItem("name");
                        return node != null && node.getNodeValue().equals(name);
                    }).flatMap(WSDLHelper::flatten).filter(a -> a.getNodeType() == 1).filter(a -> a.getAttributes().getNamedItem("name") != null).filter(a -> !a.getAttributes().getNamedItem("name").getNodeValue().equals(name)).map(a -> a.getAttributes().getNamedItem("name").getNodeValue()).filter(a -> a != null).collect(Collectors.toList());
                    paramMap.put(name, params);
                }
            }
            return paramMap;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    public static Stream<Node> flatten(Node node) {
        return Stream.concat(Stream.of(node), XmlUtils.wrapNodeList(node.getChildNodes()).stream().flatMap(WSDLHelper::flatten));
    }

    public static String generateInputSOAPMessageText(String url, String authorizationValue, String requestMethod, String operationName, Map<String, List<String>> paramMap) throws WSDLException, SOAPException, IOException {
        WSDLHelper helper = WSDLHelper.newInstance(url, authorizationValue);
        BindingOperationImpl bindingOperation = helper.getBindingOperationsByRequestMethod(requestMethod).stream().filter(bo -> bo.getName().equals(operationName)).findFirst().get();
        String operationURI = helper.getOperationURI(bindingOperation, requestMethod);
        String namespaceURI = helper.getService().getQName().getNamespaceURI();
        SOAPMessage soapMessage = helper.generateInputSOAPMessage(requestMethod, namespaceURI, operationURI, operationName, paramMap);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)out);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String generateInputSOAPMessageText(WSDLHelper helper, String requestMethod, String operationName, Map<String, List<String>> paramMap) throws WSDLException, SOAPException, IOException {
        BindingOperationImpl bindingOperation = helper.getBindingOperationsByRequestMethod(requestMethod).stream().filter(bo -> bo.getName().equals(operationName)).findFirst().get();
        String operationURI = helper.getOperationURI(bindingOperation, requestMethod);
        String namespaceURI = helper.getService().getQName().getNamespaceURI();
        SOAPMessage soapMessage = helper.generateInputSOAPMessage(requestMethod, namespaceURI, operationURI, operationName, paramMap);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)out);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public Request<?> sendSOAPRequest(String requestMethod, String operationName, List<WebElementPropertyEntity> httpHeaders, String soapMessage) throws WSDLException {
        Optional<BindingOperationImpl> bindingOperationOpt = this.getBindingOperationsByRequestMethod(requestMethod).stream().filter(bo -> bo.getName().equals(operationName)).findFirst();
        if (!bindingOperationOpt.isPresent()) {
            return null;
        }
        BindingOperationImpl bindingOperation = bindingOperationOpt.get();
        String soapAction = this.getOperationURI(bindingOperation, requestMethod);
        String endPoint = this.getPortAddressLocation(requestMethod);
        Post post = Http.post((String)endPoint, (byte[])soapMessage.getBytes(), (int)10000, (int)10000);
        httpHeaders.forEach(header -> {
            Request request = post.header(header.getName(), header.getValue());
        });
        switch (requestMethod) {
            case "SOAP": {
                post.header(HTTP_HEADER_CONTENT_TYPE, SOAP_HEADER_CONTENT_TYPE_VALUE);
                post.header(SOAP_HEADER_ACTION, soapAction);
                break;
            }
            case "SOAP12": {
                post.header(HTTP_HEADER_CONTENT_TYPE, SOAP12_HEADER_CONTENT_TYPE_VALUE);
                post.header(SOAP_HEADER_ACTION, soapAction);
                break;
            }
            default: {
                post.header(HTTP_HEADER_CONTENT_TYPE, SOAP_HEADER_CONTENT_TYPE_VALUE);
            }
        }
        return post;
    }
}

