/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMHelper {
    public static NodeList getChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        if (node.hasChildNodes()) {
            return node.getChildNodes();
        }
        return null;
    }

    public static List<Node> getNodeList(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList childNodes = DOMHelper.getChildNodes(node);
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item.getNodeType() == 1) {
                    nodes.add(childNodes.item(i));
                }
                ++i;
            }
        }
        return nodes;
    }

    public static Map<String, String> getAttributes(Node node) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (node == null || !node.hasAttributes()) {
            return attributes;
        }
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            List<Node> attrNodes = DOMHelper.getNodeList(attrs.item(i));
            for (Node attr : attrNodes) {
                attributes.put(attr.getNodeName(), attr.getNodeValue());
            }
            ++i;
        }
        return attributes;
    }
}

