/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javalite.http.Get;
import org.javalite.http.Http;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CustomWSDLReader
extends WSDLReaderImpl {
    private String authorizationValue;

    protected Import parseImport(Element importEl, Definition def, Map importedDefs) throws WSDLException {
        Import importDef;
        block25: {
            importDef = def.createImport();
            try {
                String namespaceURI = DOMUtils.getAttribute((Element)importEl, (String)"namespace");
                String locationURI = DOMUtils.getAttribute((Element)importEl, (String)"location");
                String contextURI = null;
                if (namespaceURI != null) {
                    importDef.setNamespaceURI(namespaceURI);
                }
                if (locationURI == null) break block25;
                importDef.setLocationURI(locationURI);
                if (!this.importDocuments) break block25;
                try {
                    contextURI = def.getDocumentBaseURI();
                    Definition importedDef = null;
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    URL url = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource(contextURI, locationURI);
                        String liu = this.loc.getLatestImportURI();
                        importedDef = (Definition)importedDefs.get(liu);
                        inputSource.setSystemId(liu);
                    } else {
                        URL contextURL = contextURI != null ? StringUtils.getURL(null, (String)contextURI) : null;
                        url = StringUtils.getURL((URL)contextURL, (String)locationURI);
                        importedDef = (Definition)importedDefs.get(url.toString());
                        if (importedDef == null && (inputStream = this.authorizationValue != null ? ((Get)Http.get((String)url.toString()).header("Authorization", this.authorizationValue)).getInputStream() : StringUtils.getContentAsInputStream((URL)url)) != null) {
                            inputSource = new InputSource(inputStream);
                            inputSource.setSystemId(url.toString());
                        }
                    }
                    if (importedDef == null) {
                        Element documentElement;
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + locationURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
                        }
                        Document doc = CustomWSDLReader.getDocument(inputSource, inputSource.getSystemId());
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)(documentElement = doc.getDocumentElement()))) {
                            if (this.verbose) {
                                System.out.println("Retrieving document at '" + locationURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
                            }
                            String urlString = this.loc != null ? this.loc.getLatestImportURI() : (url != null ? url.toString() : locationURI);
                            importedDef = this.readWSDL(urlString, documentElement, importedDefs);
                        } else {
                            QName docElementQName = QNameUtils.newQName((Node)documentElement);
                            if (SchemaConstants.XSD_QNAME_LIST.contains(docElementQName)) {
                                if (this.verbose) {
                                    System.out.println("Retrieving schema wsdl:imported from '" + locationURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
                                }
                                WSDLFactory factory = this.getWSDLFactory();
                                importedDef = factory.newDefinition();
                                if (this.extReg != null) {
                                    importedDef.setExtensionRegistry(this.extReg);
                                }
                                String urlString = this.loc != null ? this.loc.getLatestImportURI() : (url != null ? url.toString() : locationURI);
                                importedDef.setDocumentBaseURI(urlString);
                                Types types = importedDef.createTypes();
                                types.addExtensibilityElement(this.parseSchema(Types.class, documentElement, importedDef));
                                importedDef.setTypes(types);
                            }
                        }
                    }
                    if (importedDef != null) {
                        importDef.setDefinition(importedDef);
                    }
                }
                catch (WSDLException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + locationURI + (contextURI == null ? "'." : "', relative to '" + contextURI + "'"), (Throwable)e);
                }
            }
            catch (WSDLException e) {
                if (e.getLocation() == null) {
                    e.setLocation(XPathUtils.getXPathExprFromNode((Node)importEl));
                } else {
                    String loc = String.valueOf(XPathUtils.getXPathExprFromNode((Node)importEl)) + e.getLocation();
                    e.setLocation(loc);
                }
                throw e;
            }
        }
        NamedNodeMap attrs = importEl.getAttributes();
        CustomWSDLReader.registerNSDeclarations(attrs, def);
        Element tempEl = DOMUtils.getFirstChildElement((Element)importEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                importDef.setDocumentationElement(tempEl);
            } else {
                importDef.addExtensibilityElement(this.parseExtensibilityElement(Import.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.parseExtensibilityAttributes(importEl, Import.class, (AttributeExtensible)importDef, def);
        return importDef;
    }

    private static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return doc;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", (Throwable)e);
        }
    }

    private static void registerNSDeclarations(NamedNodeMap attrs, Definition def) {
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localPart = attr.getLocalName();
            String value = attr.getValue();
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                if (localPart != null && !localPart.equals("xmlns")) {
                    DOMUtils.registerUniquePrefix((String)localPart, (String)value, (Definition)def);
                } else {
                    DOMUtils.registerUniquePrefix(null, (String)value, (Definition)def);
                }
            }
            ++i;
        }
    }

    protected Types parseTypes(Element typesEl, Definition def) throws WSDLException {
        NamedNodeMap attrs = typesEl.getAttributes();
        CustomWSDLReader.registerNSDeclarations(attrs, def);
        Types types = def.createTypes();
        Element tempEl = DOMUtils.getFirstChildElement((Element)typesEl);
        while (tempEl != null) {
            QName tempElType = QNameUtils.newQName((Node)tempEl);
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                types.setDocumentationElement(tempEl);
            } else if (SchemaConstants.XSD_QNAME_LIST.contains(tempElType)) {
                types.addExtensibilityElement(this.parseSchema(Types.class, tempEl, def));
            } else {
                types.addExtensibilityElement(this.parseExtensibilityElement(Types.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.parseExtensibilityAttributes(typesEl, Types.class, (AttributeExtensible)types, def);
        return types;
    }

    protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def) throws WSDLException {
        Object elementType = null;
        ExtensionRegistry extReg = null;
        try {
            extReg = def.getExtensionRegistry();
            if (extReg == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + elementType + "' element in the " + "context of a '" + parentType.getName() + "'.");
            }
            return this.parseSchema(parentType, el, def, extReg);
        }
        catch (WSDLException e) {
            if (e.getLocation() == null) {
                e.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            }
            throw e;
        }
    }

    protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Schema schema = null;
        SchemaReference schemaRef = null;
        try {
            QName elementType = QNameUtils.newQName((Node)el);
            ExtensionDeserializer exDS = extReg.queryDeserializer(parentType, elementType);
            ExtensibilityElement ee = exDS.unmarshall(parentType, elementType, el, def, extReg);
            if (!(ee instanceof Schema)) {
                return ee;
            }
            schema = (Schema)ee;
            if (schema.getDocumentBaseURI() != null) {
                this.allSchemas.put(schema.getDocumentBaseURI(), schema);
            }
            ArrayList allSchemaRefs = new ArrayList();
            Collection ic = schema.getImports().values();
            Iterator importsIterator = ic.iterator();
            while (importsIterator.hasNext()) {
                allSchemaRefs.addAll((Collection)importsIterator.next());
            }
            allSchemaRefs.addAll(schema.getIncludes());
            allSchemaRefs.addAll(schema.getRedefines());
            ListIterator schemaRefIterator = allSchemaRefs.listIterator();
            while (schemaRefIterator.hasNext()) {
                try {
                    schemaRef = (SchemaReference)schemaRefIterator.next();
                    if (schemaRef.getSchemaLocationURI() == null) continue;
                    if (this.verbose) {
                        System.out.println("Retrieving schema at '" + schemaRef.getSchemaLocationURI() + (schema.getDocumentBaseURI() == null ? "'." : "', relative to '" + schema.getDocumentBaseURI() + "'."));
                    }
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    Schema referencedSchema = null;
                    String location = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource(schema.getDocumentBaseURI(), schemaRef.getSchemaLocationURI());
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate with a locator the schema referenced at '" + schemaRef.getSchemaLocationURI() + "' relative to document base '" + schema.getDocumentBaseURI() + "'");
                        }
                        location = this.loc.getLatestImportURI();
                        referencedSchema = (Schema)this.allSchemas.get(location);
                    } else {
                        String contextURI = schema.getDocumentBaseURI();
                        URL contextURL = contextURI != null ? StringUtils.getURL(null, (String)contextURI) : null;
                        URL url = StringUtils.getURL((URL)contextURL, (String)schemaRef.getSchemaLocationURI());
                        location = url.toExternalForm();
                        referencedSchema = (Schema)this.allSchemas.get(location);
                        if (referencedSchema == null) {
                            inputStream = this.authorizationValue != null ? ((Get)Http.get((String)url.toString()).header("Authorization", this.authorizationValue)).getInputStream() : StringUtils.getContentAsInputStream((URL)url);
                            if (inputStream != null) {
                                inputSource = new InputSource(inputStream);
                            }
                            if (inputSource == null) {
                                throw new WSDLException("OTHER_ERROR", "Unable to locate with a url the document referenced at '" + schemaRef.getSchemaLocationURI() + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
                            }
                        }
                    }
                    if (referencedSchema == null) {
                        Element documentElement;
                        QName docElementQName;
                        inputSource.setSystemId(location);
                        Document doc = CustomWSDLReader.getDocument(inputSource, location);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (SchemaConstants.XSD_QNAME_LIST.contains(docElementQName = QNameUtils.newQName((Node)(documentElement = doc.getDocumentElement())))) {
                            WSDLFactory factory = this.getWSDLFactory();
                            Definition dummyDef = factory.newDefinition();
                            dummyDef.setDocumentBaseURI(location);
                            referencedSchema = (Schema)this.parseSchema(parentType, documentElement, dummyDef, extReg);
                        }
                    }
                    schemaRef.setReferencedSchema(referencedSchema);
                }
                catch (WSDLException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WSDLException("OTHER_ERROR", "An error occurred trying to resolve schema referenced at '" + schemaRef.getSchemaLocationURI() + "'" + (schema.getDocumentBaseURI() == null ? "." : ", relative to '" + schema.getDocumentBaseURI() + "'."), (Throwable)e);
                }
            }
            return schema;
        }
        catch (WSDLException e) {
            if (e.getLocation() == null) {
                e.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            } else {
                String loc = String.valueOf(XPathUtils.getXPathExprFromNode((Node)el)) + e.getLocation();
                e.setLocation(loc);
            }
            throw e;
        }
    }

    public void setAuthorizationValue(String authorizationValue) {
        this.authorizationValue = authorizationValue;
    }
}

