/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.settings;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WebServicePreferenceStore {
    private static ScopedPreferenceStore getStore() {
        return PreferenceStoreManager.getPreferenceStore(WebServicePreferenceStore.class);
    }

    public List<RequestHistoryEntity> getHistoryRequestEntities(ProjectEntity project) {
        Map<String, List<RequestHistoryEntity>> requestHistoriesPerProject = this.getRequestHistoriesIndice();
        if (requestHistoriesPerProject.containsKey(project.getUUID())) {
            return requestHistoriesPerProject.get(project.getUUID());
        }
        return Collections.emptyList();
    }

    private Map<String, List<RequestHistoryEntity>> getRequestHistoriesIndice() {
        String requestHistoryMap = WebServicePreferenceStore.getStore().getString("requestHistories");
        if (StringUtils.isEmpty((CharSequence)requestHistoryMap)) {
            return Collections.emptyMap();
        }
        Type mapType = new TypeToken<Map<String, List<RequestHistoryEntity>>>(){}.getType();
        Map requestHistoriesPerProject = (Map)JsonUtil.fromJson((String)requestHistoryMap, (Type)mapType);
        return requestHistoriesPerProject;
    }

    public void addRequestHistory(RequestHistoryEntity requestHistory, ProjectEntity project) throws IOException {
        ArrayList<RequestHistoryEntity> currentRequestHistories = new ArrayList<RequestHistoryEntity>(this.getHistoryRequestEntities(project));
        HashMap<String, List<RequestHistoryEntity>> requestHistoriesPerProject = new HashMap<String, List<RequestHistoryEntity>>(this.getRequestHistoriesIndice());
        currentRequestHistories.add(requestHistory);
        requestHistoriesPerProject.put(project.getUUID(), currentRequestHistories);
        WebServicePreferenceStore.getStore().setValue("requestHistories", JsonUtil.toJson(requestHistoriesPerProject));
        WebServicePreferenceStore.getStore().save();
    }

    public void removeRequestHistory(RequestHistoryEntity requestHistory, ProjectEntity project) throws IOException {
        ArrayList<RequestHistoryEntity> currentRequestHistories = new ArrayList<RequestHistoryEntity>(this.getHistoryRequestEntities(project));
        HashMap<String, List<RequestHistoryEntity>> requestHistoriesPerProject = new HashMap<String, List<RequestHistoryEntity>>(this.getRequestHistoriesIndice());
        currentRequestHistories.remove(requestHistory);
        requestHistoriesPerProject.put(project.getUUID(), currentRequestHistories);
        WebServicePreferenceStore.getStore().setValue("requestHistories", JsonUtil.toJson(requestHistoriesPerProject));
        WebServicePreferenceStore.getStore().save();
    }

    public void setRequestHistoryEntities(List<RequestHistoryEntity> requestHistoryEntities, ProjectEntity project) throws IOException {
        HashMap<String, List<RequestHistoryEntity>> requestHistoriesPerProject = new HashMap<String, List<RequestHistoryEntity>>(this.getRequestHistoriesIndice());
        requestHistoriesPerProject.put(project.getUUID(), requestHistoryEntities);
        WebServicePreferenceStore.getStore().setValue("requestHistories", JsonUtil.toJson(requestHistoriesPerProject));
        WebServicePreferenceStore.getStore().save();
    }

    public void saveDraftRequest(DraftWebServiceRequestEntity requestHistory, ProjectEntity project) throws IOException {
        ArrayList<DraftWebServiceRequestEntity> currentRequestHistories = new ArrayList<DraftWebServiceRequestEntity>(this.getDraftRequests(project));
        HashMap<String, List<DraftWebServiceRequestEntity>> requestHistoriesPerProject = new HashMap<String, List<DraftWebServiceRequestEntity>>(this.getDraftRequestIndice());
        currentRequestHistories.add(requestHistory);
        requestHistoriesPerProject.put(project.getUUID(), currentRequestHistories);
        WebServicePreferenceStore.getStore().setValue("draftRequests", JsonUtil.toJson(requestHistoriesPerProject));
        WebServicePreferenceStore.getStore().save();
    }

    public void removeDraftRequest(DraftWebServiceRequestEntity requestHistory, ProjectEntity project) throws IOException {
        ArrayList<DraftWebServiceRequestEntity> currentDraftRequests = new ArrayList<DraftWebServiceRequestEntity>(this.getDraftRequests(project));
        HashMap<String, List<DraftWebServiceRequestEntity>> draftRequestPerProjects = new HashMap<String, List<DraftWebServiceRequestEntity>>(this.getDraftRequestIndice());
        currentDraftRequests.remove(requestHistory);
        draftRequestPerProjects.put(project.getUUID(), currentDraftRequests);
        WebServicePreferenceStore.getStore().setValue("draftRequests", JsonUtil.toJson(draftRequestPerProjects));
        WebServicePreferenceStore.getStore().save();
    }

    public List<DraftWebServiceRequestEntity> getDraftRequests(ProjectEntity project) {
        Map<String, List<DraftWebServiceRequestEntity>> draftRequestsPerProject = this.getDraftRequestIndice();
        if (draftRequestsPerProject.containsKey(project.getUUID())) {
            return draftRequestsPerProject.get(project.getUUID());
        }
        return Collections.emptyList();
    }

    private Map<String, List<DraftWebServiceRequestEntity>> getDraftRequestIndice() {
        String draftRequestsMap = WebServicePreferenceStore.getStore().getString("draftRequests");
        if (StringUtils.isEmpty((CharSequence)draftRequestsMap)) {
            return Collections.emptyMap();
        }
        Type mapType = new TypeToken<Map<String, List<DraftWebServiceRequestEntity>>>(){}.getType();
        Map requestHistoriesPerProject = (Map)JsonUtil.fromJson((String)draftRequestsMap, (Type)mapType);
        return requestHistoriesPerProject;
    }
}

