/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.dialogs.AddOrEditWebServiceMethodDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WebServiceMethodSettingPage
extends PreferencePageWithHelp {
    private ToolItem tiAddMethod;
    private ToolItem tiRemoveMethod;
    private ToolItem tiEditMethod;
    private TableViewer methodTable;
    private List<WebServiceMethod> methods;
    private WebServiceSettingStore store;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();

    public WebServiceMethodSettingPage() {
        this.store = this.getStore();
        this.loadMethods();
        this.noDefaultButton();
    }

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadMethods();
        this.createToolBar(body);
        this.createMethodsTable(body);
        return body;
    }

    private void createToolBar(Composite parent) {
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        this.tiAddMethod = new ToolItem(toolBar, 0);
        this.tiAddMethod.setText(StringConstants.ADD);
        this.tiAddMethod.setImage(ImageConstants.IMG_16_ADD);
        this.tiAddMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceMethodSettingPage.this.addMethod();
            }
        });
        this.tiRemoveMethod = new ToolItem(toolBar, 0);
        this.tiRemoveMethod.setText(StringConstants.REMOVE);
        this.tiRemoveMethod.setImage(ImageConstants.IMG_16_REMOVE);
        this.tiRemoveMethod.setEnabled(false);
        this.tiRemoveMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceMethodSettingPage.this.removeSelectedMethod();
            }
        });
        this.tiRemoveMethod.setEnabled(false);
        this.tiEditMethod = new ToolItem(toolBar, 0);
        this.tiEditMethod.setText(StringConstants.EDIT);
        this.tiEditMethod.setImage(ImageConstants.IMG_16_EDIT);
        this.tiEditMethod.setEnabled(false);
        this.tiEditMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceMethodSettingPage.this.editSelectedMethod();
            }
        });
        this.tiEditMethod.setEnabled(false);
    }

    private void createMethodsTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableComposite.setLayout((Layout)new FillLayout());
        this.methodTable = new TableViewer(tableComposite, 68352);
        Table table = this.methodTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tvcMethod = new TableViewerColumn(this.methodTable, 0);
        TableColumn tcMethod = tvcMethod.getColumn();
        tcMethod.setWidth(200);
        tcMethod.setText(StringConstants.METHOD_TABLE_COL_METHOD);
        tvcMethod.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WebServiceMethod method = (WebServiceMethod)element;
                return method.getName();
            }
        });
        TableViewerColumn tvcType = new TableViewerColumn(this.methodTable, 0);
        TableColumn tcType = tvcType.getColumn();
        tcType.setWidth(100);
        tcType.setText(StringConstants.METHOD_TABLE_COL_TYPE);
        tvcType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WebServiceMethod method = (WebServiceMethod)element;
                return method.getType();
            }
        });
        TableViewerColumn tvcDescription = new TableViewerColumn(this.methodTable, 0);
        TableColumn tcDescription = tvcDescription.getColumn();
        tcDescription.setWidth(300);
        tcDescription.setText(StringConstants.METHOD_TABLE_COL_DESCRIPTION);
        tvcDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WebServiceMethod method = (WebServiceMethod)element;
                return method.getDescription();
            }
        });
        this.methodTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WebServiceMethod selectedMethod = WebServiceMethodSettingPage.this.getSelectedMethod();
                boolean allowEditOrRemove = selectedMethod != null && "Custom".equals(selectedMethod.getType());
                WebServiceMethodSettingPage.this.tiEditMethod.setEnabled(allowEditOrRemove);
                WebServiceMethodSettingPage.this.tiRemoveMethod.setEnabled(allowEditOrRemove);
            }
        });
        this.methodTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.methodTable.setInput(this.methods);
        this.methodTable.refresh();
    }

    private void loadMethods() {
        try {
            this.methods = this.store.getWebServiceMethods();
        }
        catch (IOException iOException) {
            this.methods = new ArrayList<WebServiceMethod>();
        }
    }

    private void addMethod() {
        AddOrEditWebServiceMethodDialog dialog = new AddOrEditWebServiceMethodDialog(Display.getCurrent().getActiveShell(), null, this.methods, false);
        if (dialog.open() == 0) {
            WebServiceMethod newMethod = dialog.getMethod();
            this.methods.add(newMethod);
            this.methodTable.refresh();
        }
    }

    private void editSelectedMethod() {
        WebServiceMethod selectedMethod = this.getSelectedMethod();
        if (selectedMethod != null) {
            int index = this.findMethodIndex(selectedMethod);
            AddOrEditWebServiceMethodDialog dialog = new AddOrEditWebServiceMethodDialog(Display.getCurrent().getActiveShell(), selectedMethod, this.methods, true);
            if (dialog.open() == 0) {
                WebServiceMethod editedMethod = dialog.getMethod();
                this.methods.set(index, editedMethod);
                this.methodTable.refresh();
            }
        }
    }

    private void removeSelectedMethod() {
        WebServiceMethod selectedMethod = this.getSelectedMethod();
        if (selectedMethod != null) {
            int index = this.findMethodIndex(selectedMethod);
            this.methods.remove(index);
            this.methodTable.refresh();
        }
    }

    private WebServiceMethod getSelectedMethod() {
        StructuredSelection selection = (StructuredSelection)this.methodTable.getSelection();
        if (selection != null && selection.getFirstElement() != null) {
            return (WebServiceMethod)selection.getFirstElement();
        }
        return null;
    }

    private int findMethodIndex(WebServiceMethod method) {
        int i = 0;
        while (i < this.methods.size()) {
            if (this.methods.get(i).getName().equals(method.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private WebServiceSettingStore getStore() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return WebServiceSettingStore.create((String)project.getFolderLocation());
    }

    protected void performApply() {
        try {
            this.store.saveWebServiceMethods(this.methods);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean performOk() {
        if (super.performOk() && this.isValid()) {
            this.performApply();
            this.eventBroker.post("WEBSERVICE/UPDATE_METHODS", null);
        }
        return true;
    }
}

