/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NetworkSettingPage
extends PreferencePageWithHelp {
    private WebServiceSettingStore settingStore = WebServiceSettingStore.create((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private Map<SSLCertificateOption, Button> sslCertButtons = new HashMap<SSLCertificateOption, Button>();
    private Composite container;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Group grpSSLCertOptions = new Group(this.container, 0);
        grpSSLCertOptions.setText(ComposerWebserviceMessageConstants.DIA_GRP_LBL_CERTITICATES);
        grpSSLCertOptions.setLayout((Layout)new GridLayout(1, false));
        grpSSLCertOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button rbtnNoneCertificateOpt = new Button((Composite)grpSSLCertOptions, 16);
        rbtnNoneCertificateOpt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        rbtnNoneCertificateOpt.setText(ComposerWebserviceMessageConstants.DIA_LBL_SSL_CERT_NONE_OPT);
        this.sslCertButtons.put(SSLCertificateOption.NONE, rbtnNoneCertificateOpt);
        Button rbtnBypassCertificateOpt = new Button((Composite)grpSSLCertOptions, 16);
        rbtnBypassCertificateOpt.setText(ComposerWebserviceMessageConstants.DIA_LBL_SSL_CERT_BYPASS_OPT);
        this.sslCertButtons.put(SSLCertificateOption.BYPASS, rbtnBypassCertificateOpt);
        this.initializeInput();
        return this.container;
    }

    private void initializeInput() {
        try {
            SSLCertificateOption option = this.settingStore.getSSLCertificateOption();
            this.sslCertButtons.entrySet().stream().forEach(entry -> ((Button)entry.getValue()).setSelection(entry.getKey() == option));
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerWebserviceMessageConstants.DIA_MSG_UNABLE_TO_LOAD_NETWORK_PAGE, (String)StringConstants.ERROR_TITLE);
        }
    }

    private boolean isInitialized() {
        return this.container != null;
    }

    public boolean performOk() {
        if (!this.isInitialized()) {
            return true;
        }
        SSLCertificateOption selectedSSLOption = (SSLCertificateOption)this.sslCertButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).getSelection()).findFirst().get().getKey();
        try {
            this.settingStore.saveSSLCertificateOption(selectedSSLOption);
            return true;
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerWebserviceMessageConstants.DIA_MSG_UNABLE_TO_UPDATE_NETWORK_PAGE, (String)StringConstants.ERROR_TITLE);
            return false;
        }
    }

    protected void performDefaults() {
        this.initializeInput();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTING_NETWORK;
    }
}

