/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.body;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parts.VerificationScriptEventHandler;
import com.kms.katalon.composer.webservice.response.body.PrettyEditor;
import com.kms.katalon.composer.webservice.response.body.PreviewEditor;
import com.kms.katalon.composer.webservice.response.body.RawEditor;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.core.testobject.ResponseObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class ResponseBodyEditorsComposite
extends Composite {
    protected final String WS_BUNDLE_NAME = FrameworkUtil.getBundle(ResponseBodyEditorsComposite.class).getSymbolicName();
    private Map<EditorMode, ResponseBodyEditor> bodyEditors = new HashMap<EditorMode, ResponseBodyEditor>();
    private Map<EditorMode, Button> bodySelectionButtons = new HashMap<EditorMode, Button>();
    private Button prettyRadio;
    private Button rawRadio;
    private Button previewRadio;
    private StackLayout slBodyContent;
    private ResponseObject responseObject;
    private EditorMode selectedEditorMode;
    private final String PRETTY_MODE_DEFAULT_CONTENT_TYPE = TextContentType.HTML.getContentType().toString();
    private final String PRETTY_MODE_DEFAULT_INITAL_MESSAGE = "";

    public ResponseBodyEditorsComposite(Composite parent, int style, VerificationScriptEventHandler editorEventHandler) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Composite bodyTypeComposite = new Composite((Composite)this, 0);
        bodyTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glBodyType = new GridLayout(2, false);
        glBodyType.marginHeight = 0;
        glBodyType.marginWidth = 0;
        bodyTypeComposite.setLayout((Layout)glBodyType);
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.slBodyContent = new StackLayout();
        bodyContentComposite.setLayout((Layout)this.slBodyContent);
        Composite tbBodyType = new Composite(bodyTypeComposite, 0);
        tbBodyType.setLayout((Layout)new GridLayout(3, false));
        this.prettyRadio = new Button(tbBodyType, 16);
        this.prettyRadio.setText(EditorMode.PRETTY.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.PRETTY, this.prettyRadio);
        PrettyEditor prettyEditor = new PrettyEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.PRETTY, prettyEditor);
        prettyEditor.addHandler(editorEventHandler);
        this.rawRadio = new Button(tbBodyType, 16);
        this.rawRadio.setText(EditorMode.RAW.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.RAW, this.rawRadio);
        RawEditor rawEditor = new RawEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.RAW, rawEditor);
        this.previewRadio = new Button(tbBodyType, 16);
        this.previewRadio.setText(EditorMode.PREVIEW.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.PREVIEW, this.previewRadio);
        PreviewEditor previewEditor = new PreviewEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.PREVIEW, previewEditor);
        this.handleControlModifyListeners();
        ResponseObject defaultResponseOb = new ResponseObject();
        defaultResponseOb.setContentType(this.PRETTY_MODE_DEFAULT_CONTENT_TYPE);
        defaultResponseOb.setResponseText("");
        this.setInput(defaultResponseOb);
    }

    public void setInput(ResponseObject responseOb) {
        try {
            this.responseObject = new ResponseObject();
            this.responseObject.setResponseText(responseOb.getResponseText());
            this.responseObject.setContentType(StringUtils.substringBefore((String)responseOb.getContentType(), (String)";"));
            this.selectedEditorMode = this.detectEditorMode(this.responseObject.getContentType());
            this.bodySelectionButtons.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(false));
            Button selectedButton = this.bodySelectionButtons.get((Object)this.selectedEditorMode);
            selectedButton.setSelection(true);
            for (ResponseBodyEditor childEditor : this.bodyEditors.values()) {
                childEditor.setContentBody(this.responseObject);
            }
            Composite selectedEditor = (Composite)this.bodyEditors.get((Object)this.selectedEditorMode);
            this.slBodyContent.topControl = selectedEditor;
            selectedEditor.getParent().layout();
        }
        catch (Exception e2) {
            LoggerSingleton.logError((Throwable)e2);
            ErrorDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, this.WS_BUNDLE_NAME, e2.getMessage(), (Throwable)e2));
        }
    }

    private EditorMode detectEditorMode(String contentType) {
        if (StringUtils.isNotEmpty((String)contentType) && (contentType.startsWith(TextContentType.XML.getContentType()) || contentType.startsWith(TextContentType.JAVASCRIPT.getContentType()) || contentType.startsWith(TextContentType.JSON.getContentType()) || contentType.startsWith(TextContentType.HTML.getContentType()))) {
            return EditorMode.PRETTY;
        }
        return EditorMode.PREVIEW;
    }

    private void handleControlModifyListeners() {
        SelectionAdapter bodyTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    try {
                        ResponseBodyEditorsComposite.this.selectedEditorMode = EditorMode.valueOf(source.getText().toUpperCase());
                        ResponseBodyEditor editorComposite = (ResponseBodyEditor)ResponseBodyEditorsComposite.this.bodyEditors.get((Object)ResponseBodyEditorsComposite.this.selectedEditorMode);
                        editorComposite.switchModeContentBody(ResponseBodyEditorsComposite.this.responseObject);
                        ((ResponseBodyEditorsComposite)ResponseBodyEditorsComposite.this).slBodyContent.topControl = (Composite)editorComposite;
                        ((Composite)editorComposite).getParent().layout();
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        ErrorDialog.openError((Shell)ResponseBodyEditorsComposite.this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, ResponseBodyEditorsComposite.this.WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
                    }
                }
            }
        };
        this.bodySelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)bodyTypeSelectedListener));
        this.bodyEditors.values().forEach(editor2 -> ((Composite)editor2).addListener(24, event -> this.responseObject.setContentType(editor2.getContentType())));
    }

    private static enum EditorMode {
        PRETTY,
        RAW,
        PREVIEW;

    }
}

