/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts.tree;

import com.kms.katalon.composer.webservice.parts.tree.IRequestHistoryItem;
import com.kms.katalon.composer.webservice.parts.tree.RequestDateTreeItem;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class RequestHistoryTreeItem
implements IRequestHistoryItem {
    private RequestHistoryEntity requestHistoryEntity;
    private RequestDateTreeItem parent;

    public RequestHistoryTreeItem(RequestHistoryEntity requestHistoryEntity, RequestDateTreeItem parent) {
        this.requestHistoryEntity = requestHistoryEntity;
        this.parent = parent;
    }

    public RequestHistoryEntity getRequestHistoryEntity() {
        return this.requestHistoryEntity;
    }

    @Override
    public String getName() {
        WebServiceRequestEntity request = this.requestHistoryEntity.getRequest();
        String type = request.getServiceType();
        return "RESTful".equals(type) ? request.getRestUrl() : request.getWsdlAddress();
    }

    @Override
    public Image getImage() {
        WebServiceRequestEntity request = this.requestHistoryEntity.getRequest();
        String serviceType = request.getServiceType();
        if ("RESTful".equals(serviceType)) {
            return WebServiceUtil.getRequestMethodImage(serviceType, request.getRestRequestMethod());
        }
        return WebServiceUtil.getRequestMethodImage(serviceType, request.getSoapRequestMethod());
    }

    @Override
    public List<IRequestHistoryItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.requestHistoryEntity == null ? 0 : this.requestHistoryEntity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHistoryTreeItem other = (RequestHistoryTreeItem)obj;
        return !(this.requestHistoryEntity == null ? other.requestHistoryEntity != null : !this.requestHistoryEntity.equals((Object)other.requestHistoryEntity));
    }

    @Override
    public IRequestHistoryItem getParent() {
        return this.parent;
    }
}

