/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.SoapRequestMessageEditor;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.soap.response.body.SoapResponseBodyEditorsComposite;
import com.kms.katalon.composer.webservice.util.WSDLHelper;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.composer.webservice.view.xml.ColorManager;
import com.kms.katalon.composer.webservice.view.xml.XMLConfiguration;
import com.kms.katalon.composer.webservice.view.xml.XMLPartitionScanner;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WebServiceController;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.WSDLException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SoapServicePart
extends WebServicePart {
    private static final String[] FILTER_EXTS = new String[]{"*.xml; *.wsdl; *.txt"};
    private static final String[] FILTER_NAMES = new String[]{"XML content files (*.xml, *.wsdl, *.txt)"};
    protected SoapResponseBodyEditorsComposite soapResponseBodyEditor;
    private ProgressMonitorDialogWithThread progress;
    private CCombo ccbOperation;
    protected SoapRequestMessageEditor requestBodyEditor;

    @Override
    protected void createAPIControls(Composite parent) {
        super.createAPIControls(parent);
        this.wsApiControl.addRequestMethodSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.ccbOperation.removeAll();
            }
        });
        Composite operationComposite = new Composite(parent, 0);
        GridLayout glOperation = new GridLayout(3, false);
        glOperation.marginWidth = 0;
        glOperation.marginHeight = 0;
        operationComposite.setLayout((Layout)glOperation);
        operationComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblOperation = new Label(operationComposite, 0);
        lblOperation.setText(StringConstants.PA_LBL_SERVICE_FUNCTION);
        GridData gdLblOperation = new GridData(16384, 0x1000000, false, false);
        lblOperation.setLayoutData((Object)gdLblOperation);
        this.ccbOperation = new CCombo(operationComposite, 0x800808);
        this.ccbOperation.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.ccbOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.setDirty(true);
            }
        });
        Button btnLoadFromWSDL = new Button(operationComposite, 0x800000);
        btnLoadFromWSDL.setText(StringConstants.LBL_LOAD_FROM_WSDL);
        GridData gdBtnLoadFromWSDL = new GridData(16384, 4, false, false);
        btnLoadFromWSDL.setLayoutData((Object)gdBtnLoadFromWSDL);
        btnLoadFromWSDL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String requestURL = SoapServicePart.this.wsApiControl.getRequestURL().trim();
                final String method = SoapServicePart.this.wsApiControl.getRequestMethod();
                try {
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    new ProgressMonitorDialogWithThread(activeShell).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(StringConstants.MSG_FETCHING_FROM_WSDL, -1);
                            try {
                                try {
                                    List<String> servFuncs = WSDLHelper.newInstance(requestURL, SoapServicePart.this.getAuthorizationHeaderValue()).getOperationNamesByRequestMethod(method);
                                    UISynchronizeService.asyncExec(() -> {
                                        SoapServicePart.this.ccbOperation.setItems(servFuncs.toArray(new String[0]));
                                        if (servFuncs.size() > 0) {
                                            SoapServicePart.this.ccbOperation.select(0);
                                        }
                                        SoapServicePart.this.setDirty(true);
                                    });
                                }
                                catch (WSDLException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MultiStatusErrorDialog.showErrorDialog((String)("Unable to load service function from url: " + requestURL), (String)ex.getTargetException().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)ex.getTargetException()));
                }
                catch (InterruptedException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    @Override
    protected void sendRequest(final boolean runVerificationScript) {
        if (this.dirtyable.isDirty()) {
            boolean isOK = MessageDialog.openConfirm(null, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES);
            if (!isOK) {
                return;
            }
            this.save();
        }
        this.clearPreviousResponse();
        this.wsApiControl.getRequestURL().trim();
        if (this.ccbOperation.getText().isEmpty()) {
            LoggerSingleton.logError((String)"Service Function is empty");
            MessageDialog.openError(null, (String)StringConstants.ERROR, (String)"Service Function is empty");
            return;
        }
        if (this.wsApiControl.getSendingState()) {
            this.progress.getProgressMonitor().setCanceled(true);
            this.wsApiControl.setSendButtonState(false);
            return;
        }
        try {
            Trackings.trackTestWebServiceObject((boolean)runVerificationScript, (boolean)(this.getOriginalWsObject() instanceof DraftWebServiceRequestEntity));
            this.wsApiControl.setSendButtonState(true);
            this.progress = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
            this.progress.setOpenOnRun(false);
            this.displayResponseContentBasedOnSendingState(true);
            this.progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ResponseObject responseObject;
                    block6: {
                        monitor.beginTask(ComposerWebserviceMessageConstants.PART_MSG_SENDING_TEST_REQUEST, -1);
                        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                        WebServiceRequestEntity requestEntity = SoapServicePart.this.getWSRequestObject();
                        Map<String, String> evaluatedVariables = SoapServicePart.this.evaluateRequestVariables();
                        responseObject = WebServiceController.getInstance().sendRequest(requestEntity, projectDir, ProxyPreferences.getProxyInformation(), Collections.unmodifiableMap(evaluatedVariables), false);
                        if (!monitor.isCanceled()) break block6;
                        UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            String bodyContent = responseObject.getResponseText();
                            Display.getDefault().asyncExec(() -> {
                                SoapServicePart.this.setResponseStatus(responseObject);
                                SoapServicePart.this.mirrorEditor.setText(SoapServicePart.this.getPrettyHeaders(responseObject));
                                if (bodyContent == null) {
                                    return;
                                }
                                SoapServicePart.this.soapResponseBodyEditor.setInput(responseObject);
                            });
                            if (runVerificationScript) {
                                SoapServicePart.this.executeVerificationScript(responseObject);
                            }
                            RequestHistoryEntity requestHistoryEntity = new RequestHistoryEntity(new Date(), (WebServiceRequestEntity)SoapServicePart.this.getWSRequestObject().clone());
                            SoapServicePart.this.eventBroker.post("WS_VERIFICATION/FINISHED", (Object)new Object[]{requestHistoryEntity});
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target == null) {
                return;
            }
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_SEND_THE_TEST_REQUEST, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
        this.displayResponseContentBasedOnSendingState(false);
    }

    @Override
    protected void createParamsComposite(Composite parent) {
    }

    @Override
    protected void addTabBody(CTabFolder parent) {
        super.addTabBody(parent);
        this.tabBody.setText(StringConstants.PA_LBL_XML_REQ_MSG);
        Composite tabComposite = (Composite)this.tabBody.getControl();
        this.requestBodyEditor = new SoapRequestMessageEditor(tabComposite, 0, this);
        this.requestBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void createResponseComposite(Composite parent) {
        super.createResponseComposite(parent);
        this.soapResponseBodyEditor = new SoapResponseBodyEditorsComposite(this.responseBodyComposite, 0, this);
        this.soapResponseBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void preSaving() {
        this.originalWsObject.setWsdlAddress(this.wsApiControl.getRequestURL());
        this.originalWsObject.setSoapRequestMethod(this.wsApiControl.getRequestMethod());
        this.originalWsObject.setSoapServiceFunction(this.ccbOperation.getText());
        this.tblHeaders.removeEmptyProperty();
        this.originalWsObject.setHttpHeaderProperties(this.httpHeaders);
        this.originalWsObject.setSoapBody(this.requestBodyEditor.getHttpBodyContent());
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getSoapRequestMethod()));
    }

    @Override
    protected void populateDataToUI() {
        this.wsApiControl.getRequestURLControl().setText(this.originalWsObject.getWsdlAddress());
        String soapRequestMethod = this.originalWsObject.getSoapRequestMethod();
        int index = Arrays.asList(WebServiceRequestEntity.SOAP_REQUEST_METHODS).indexOf(soapRequestMethod);
        this.wsApiControl.getRequestMethodControl().select(index < 0 ? 0 : index);
        this.ccbOperation.setText(this.originalWsObject.getSoapServiceFunction());
        this.tempPropList = new ArrayList(this.originalWsObject.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
        this.populateBasicAuthFromHeader();
        this.populateOAuth1FromHeader();
        this.renderAuthenticationUI(this.ccbAuthType.getText());
        this.requestBodyEditor.setInput((WebServiceRequestEntity)this.originalWsObject.clone());
        this.dirtyable.setDirty(false);
    }

    private SourceViewer createXMLSourceViewer(Composite parent) {
        SourceViewer sv = this.createSourceViewer(parent, new GridData(4, 4, true, true));
        sv.configure((SourceViewerConfiguration)new XMLConfiguration(new ColorManager()));
        return sv;
    }

    private IDocument createXMLDocument(String documentContent) {
        org.eclipse.jface.text.Document document = new org.eclipse.jface.text.Document(documentContent);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SoapServicePart.this.setDirty(true);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        return document;
    }

    private void formatRequestBody() {
        try {
            StyledText requestBodyWidget = this.requestBody.getTextWidget();
            String sw = this.formatXMLContent(requestBodyWidget.getText());
            requestBodyWidget.setText(sw);
            this.setDirty(true);
        }
        catch (Exception ex) {
            ErrorDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_FORMAT_THE_XML_CONTENT, (IStatus)new Status(4, WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
        }
    }

    private String formatXMLContent(String content) throws DocumentException, IOException {
        Document doc = DocumentHelper.parseText((String)content);
        StringWriter sw = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndent("    ");
        format.setNewLineAfterDeclaration(false);
        XMLWriter xw = new XMLWriter((Writer)sw, format);
        xw.write(doc);
        return sw.toString();
    }

    private String getAuthorizationHeaderValue() {
        Optional<WebElementPropertyEntity> definedAuthorization = this.httpHeaders.stream().filter(header -> "Authorization".equals(header.getName())).findFirst();
        if (definedAuthorization.isPresent()) {
            return definedAuthorization.get().getValue();
        }
        Map<String, String> map = this.oauth1Headers.stream().collect(Collectors.toMap(WebElementPropertyEntity::getName, WebElementPropertyEntity::getValue));
        String authType = map.get("Authorization:type");
        if (StringUtils.isBlank((String)authType)) {
            return null;
        }
        if ("OAuth 1.0".equals(authType)) {
            try {
                String oauth1AuthorizationHeader = BasicRequestor.createOAuth1AuthorizationHeaderValue((String)this.wsApiControl.getRequestURL().trim(), map);
                return StringUtils.isBlank((String)oauth1AuthorizationHeader) ? null : oauth1AuthorizationHeader;
            }
            catch (GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected void updatePartImage() {
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getSoapRequestMethod()));
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }
}

