/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditorComposite;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditorsComposite;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.composer.webservice.view.ExpandableComposite;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WebServiceController;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webservice.helper.RestRequestMethodHelper;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class RestServicePart
extends WebServicePart {
    protected HttpBodyEditorComposite requestBodyEditor;
    private URLBuilder urlBuilder;
    protected ResponseBodyEditorsComposite responseBodyEditor;
    private ProgressMonitorDialogWithThread progress;
    private Label lblBodyNotSupported;
    private ModifyListener requestURLModifyListener;

    @Override
    protected void createAPIControls(Composite parent) {
        super.createAPIControls(parent);
        this.requestURLModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                RestServicePart.this.updateParamsTable(text.getText());
            }
        };
        this.wsApiControl.addRequestURLModifyListener(this.requestURLModifyListener);
        this.wsApiControl.addRequestMethodSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
            }
        });
        this.wsApiControl.addRequestMethodSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
            }
        });
        this.wsApiControl.addRequestMethodModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
            }
        });
        this.wsApiControl.addRequestMethodFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (StringUtils.isBlank((CharSequence)RestServicePart.this.wsApiControl.getRequestMethod())) {
                    RestServicePart.this.wsApiControl.setRequestMethodSelection(0);
                }
            }
        });
    }

    @Override
    protected void sendRequest(final boolean runVerificationScript) {
        if (this.dirtyable.isDirty()) {
            boolean isOK = MessageDialog.openConfirm(null, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES);
            if (!isOK) {
                return;
            }
            this.save();
        }
        this.clearPreviousResponse();
        this.wsApiControl.getRequestURL().trim();
        if (this.wsApiControl.getSendingState()) {
            this.progress.getProgressMonitor().setCanceled(true);
            this.wsApiControl.setSendButtonState(false);
            return;
        }
        try {
            Trackings.trackTestWebServiceObject((boolean)runVerificationScript, (boolean)(this.getOriginalWsObject() instanceof DraftWebServiceRequestEntity));
            this.wsApiControl.setSendButtonState(true);
            this.progress = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
            this.progress.setOpenOnRun(false);
            this.displayResponseContentBasedOnSendingState(true);
            this.progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ResponseObject responseObject;
                    block6: {
                        monitor.beginTask(ComposerWebserviceMessageConstants.PART_MSG_SENDING_TEST_REQUEST, -1);
                        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                        WebServiceRequestEntity requestEntity = RestServicePart.this.getWSRequestObject();
                        Map<String, String> evaluatedVariables = RestServicePart.this.evaluateRequestVariables();
                        responseObject = WebServiceController.getInstance().sendRequest(requestEntity, projectDir, ProxyPreferences.getProxyInformation(), Collections.unmodifiableMap(evaluatedVariables), false);
                        if (!monitor.isCanceled()) break block6;
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            String bodyContent = responseObject.getResponseText();
                            Display.getDefault().asyncExec(() -> {
                                RestServicePart.this.setResponseStatus(responseObject);
                                RestServicePart.this.mirrorEditor.setText(RestServicePart.this.getPrettyHeaders(responseObject));
                                if (bodyContent == null) {
                                    return;
                                }
                                RestServicePart.this.responseBodyEditor.setInput(responseObject);
                            });
                            if (runVerificationScript) {
                                RestServicePart.this.executeVerificationScript(responseObject);
                            }
                            RequestHistoryEntity requestHistoryEntity = new RequestHistoryEntity(new Date(), (WebServiceRequestEntity)RestServicePart.this.getWSRequestObject().clone());
                            RestServicePart.this.eventBroker.post("WS_VERIFICATION/FINISHED", (Object)new Object[]{requestHistoryEntity});
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target == null) {
                return;
            }
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_SEND_THE_TEST_REQUEST, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
        this.displayResponseContentBasedOnSendingState(false);
    }

    private void setTabBodyContentBasedOnRequestMethod() {
        GridData gdLblBodyNotSupported = (GridData)this.lblBodyNotSupported.getLayoutData();
        GridData gdRequestBodyEditor = (GridData)this.requestBodyEditor.getLayoutData();
        if (this.isBodySupported()) {
            gdLblBodyNotSupported.exclude = true;
            this.lblBodyNotSupported.setVisible(false);
            gdRequestBodyEditor.exclude = false;
            this.requestBodyEditor.setVisible(true);
        } else {
            gdLblBodyNotSupported.exclude = false;
            this.lblBodyNotSupported.setVisible(true);
            this.lblBodyNotSupported.setText(String.format(ComposerWebserviceMessageConstants.LBL_BODY_NOT_SUPPORTED, this.wsApiControl.getRequestMethod()));
            gdRequestBodyEditor.exclude = true;
            this.requestBodyEditor.setVisible(false);
        }
        this.lblBodyNotSupported.getParent().requestLayout();
    }

    private void updateParamsTable(String newUrl) {
        this.params = this.extractRestParameters(newUrl);
        this.tblParams.setInput(this.params);
        this.tblParams.refresh();
    }

    private List<WebElementPropertyEntity> extractRestParameters(String url) {
        ArrayList<WebElementPropertyEntity> paramEntities = new ArrayList();
        this.urlBuilder = new URLBuilder(url);
        List params = this.urlBuilder.getQueryParams();
        paramEntities = params.stream().map(param -> new WebElementPropertyEntity(param.getName(), param.getValue())).collect(Collectors.toList());
        return paramEntities;
    }

    @Override
    protected void createParamsComposite(Composite parent) {
        this.createCustomizeApiMethodsLink(parent);
        ExpandableComposite paramsExpandableComposite = new ExpandableComposite(parent, StringConstants.PA_LBL_PARAMS, 1, true);
        Composite paramsComposite = paramsExpandableComposite.createControl();
        GridLayout glParams = (GridLayout)paramsComposite.getLayout();
        glParams.marginLeft = 0;
        glParams.marginRight = 0;
        final ToolBar toolbar = this.createAddRemoveToolBar(paramsComposite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.tblParams.addRow();
            }
        }, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.deleteSelectedParams();
            }
        });
        this.tblParams = this.createKeyValueTable(paramsComposite, false);
        this.tblParams.setInput(this.params);
        this.tblParams.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                toolbar.getItem(1).setEnabled(RestServicePart.this.tblParams.getTable().getSelectionCount() > 0);
            }
        });
    }

    private void createCustomizeApiMethodsLink(Composite parent) {
        Link lnkCustomizeApiMethods = new Link(parent, 0);
        lnkCustomizeApiMethods.setLayoutData((Object)new GridData(16384, 4, false, false));
        lnkCustomizeApiMethods.setText(StringConstants.LINK_CUSTOMIZE_API_METHODS);
        lnkCustomizeApiMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.webui.setting.testdesign.webservicemethod");
            }
        });
    }

    @Override
    protected void deleteSelectedParams() {
        int[] selectionIndices = this.tblParams.getTable().getSelectionIndices();
        HashSet<Integer> selectionIndexSet = new HashSet<Integer>();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selectionIndexSet.add(index);
            ++n2;
        }
        Object paramProperties = this.tblParams.getInput();
        ArrayList<WebElementPropertyEntity> unselectedParamProperties = new ArrayList<WebElementPropertyEntity>();
        IntStream.range(0, paramProperties.size()).filter(i -> !selectionIndexSet.contains(i)).forEach(arg_0 -> RestServicePart.lambda$2(unselectedParamProperties, (List)paramProperties, arg_0));
        this.tblParams.setInput(unselectedParamProperties);
        this.tblParams.refresh();
        this.updateRequestUrlWithNewParams(unselectedParamProperties);
    }

    private void updateRequestUrlWithNewParams(List<WebElementPropertyEntity> paramProperties) {
        if (this.urlBuilder == null) {
            this.urlBuilder = new URLBuilder();
        }
        List<NameValuePair> params = this.toNameValuePair(paramProperties);
        this.urlBuilder.setParameters(params);
        String newUrl = this.urlBuilder.buildString();
        Text text = this.wsApiControl.getRequestURLControl();
        text.removeModifyListener(this.requestURLModifyListener);
        text.setText(newUrl);
        text.addModifyListener(this.requestURLModifyListener);
    }

    private List<NameValuePair> toNameValuePair(List<WebElementPropertyEntity> propertyEntities) {
        return propertyEntities.stream().map(pr -> new NameValuePair(pr.getName(), pr.getValue())).collect(Collectors.toList());
    }

    @Override
    protected void handleRequestParamNameChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setName((String)value);
            this.tblParams.refresh();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void handleRequestParamValueChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setValue((String)value);
            this.tblParams.refresh();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void addTabBody(CTabFolder parent) {
        super.addTabBody(parent);
        Composite tabComposite = (Composite)this.tabBody.getControl();
        Composite tabBodyComposite = new Composite(tabComposite, 0);
        tabBodyComposite.setLayout((Layout)new GridLayout());
        this.requestBodyEditor = new HttpBodyEditorComposite(tabBodyComposite, 0, this);
        this.requestBodyEditor.setLayoutData(new GridData(4, 4, true, true));
        this.lblBodyNotSupported = new Label(tabBodyComposite, 0);
        this.lblBodyNotSupported.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    @Override
    protected void createResponseComposite(Composite parent) {
        super.createResponseComposite(parent);
        this.responseBodyEditor = new ResponseBodyEditorsComposite(this.responseBodyComposite, 0, this);
        this.responseBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected SourceViewer createSourceViewer(Composite parent, GridData layoutData) {
        SourceViewer sv = super.createSourceViewer(parent, layoutData);
        sv.configure(new SourceViewerConfiguration());
        return sv;
    }

    @Override
    protected void preSaving() {
        this.tblParams.removeEmptyProperty();
        this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)this.tblParams.getInput());
        this.originalWsObject.setRestUrl(this.wsApiControl.getRequestURL());
        String requestMethod = this.wsApiControl.getRequestMethod();
        this.originalWsObject.setRestRequestMethod(requestMethod);
        this.tblHeaders.removeEmptyProperty();
        this.originalWsObject.setHttpHeaderProperties((List)this.tblHeaders.getInput());
        if (this.isBodySupported(requestMethod) && this.requestBodyEditor.getHttpBodyType() != null) {
            this.originalWsObject.setHttpBodyContent(this.requestBodyEditor.getHttpBodyContent());
            this.originalWsObject.setHttpBodyType(this.requestBodyEditor.getHttpBodyType());
        }
        this.updatePartImage();
    }

    private boolean isBodySupported(String requestMethod) {
        return RestRequestMethodHelper.isBodySupported((String)requestMethod);
    }

    @Override
    protected void populateDataToUI() {
        WebServiceRequestEntity clone = (WebServiceRequestEntity)this.originalWsObject.clone();
        String restUrl = clone.getRestUrl();
        this.wsApiControl.getRequestURLControl().setText(restUrl);
        this.updateParamsTable(restUrl);
        String restRequestMethod = clone.getRestRequestMethod();
        Arrays.asList(WebServiceRequestEntity.REST_REQUEST_METHODS).indexOf(restRequestMethod);
        this.wsApiControl.getRequestMethodControl();
        this.tempPropList = new ArrayList(clone.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
        this.populateBasicAuthFromHeader();
        this.populateOAuth1FromHeader();
        this.renderAuthenticationUI(this.ccbAuthType.getText());
        this.updateHeaders(clone);
        this.requestBodyEditor.setInput(clone);
        this.setTabBodyContentBasedOnRequestMethod();
        this.dirtyable.setDirty(false);
    }

    public void updateHeaders(WebServiceRequestEntity cloneWS) {
        this.tempPropList = new ArrayList(cloneWS.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
    }

    @PreDestroy
    public void preClose() {
        if (this.progress != null) {
            this.progress.getProgressMonitor().setCanceled(true);
        }
    }

    @Override
    protected void updatePartImage() {
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getRestRequestMethod()));
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }

    private static /* synthetic */ void lambda$2(List list, List list2, int i) {
        boolean bl = list.add((WebElementPropertyEntity)list2.get(i));
    }
}

