/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.handlers.ImportWebServiceRequestObjectsFromSwaggerHandler;
import com.kms.katalon.composer.webservice.handlers.ImportWebServiceRequestObjectsFromWSDLHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.osgi.framework.FrameworkUtil;

public class ImportWebServicesPopupMenuContribution {
    private static final String CONTRIBUTOR_URI = FrameworkUtil.getBundle(ImportWebServicesPopupMenuContribution.class).getSymbolicName();
    public static final String CM_IMPORT_COMPOSER_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.webservice/";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null) {
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null || selectedObjects.length != 1) {
                return;
            }
            Object selectedObject = selectedObjects[0];
            if (selectedObject instanceof FolderTreeEntity && ((FolderTreeEntity)selectedObject).getObject() instanceof FolderEntity && FolderEntity.FolderType.WEBELEMENT.equals((Object)((FolderTreeEntity)selectedObject).getObject().getFolderType())) {
                MMenu importMenu = this.getImportMenu();
                MDirectMenuItem swaggerMenuItem = this.getSwaggerMenu();
                swaggerMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportWebServiceRequestObjectsFromSwaggerHandler.class.getName());
                importMenu.getChildren().add(swaggerMenuItem);
                MDirectMenuItem wsdlMenuItem = this.getWSDLMenu();
                wsdlMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportWebServiceRequestObjectsFromWSDLHandler.class.getName());
                importMenu.getChildren().add(wsdlMenuItem);
                if (importMenu.getChildren().size() > 0) {
                    menuItems.add(0, (MMenuElement)importMenu);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MMenu getImportMenu() {
        MMenu dynamicItem = (MMenu)this.modelService.createModelElement(MMenu.class);
        dynamicItem.setLabel(StringConstants.MSG_IMPORT);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getSwaggerMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_SWAGGER);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getWSDLMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_WSDL);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }
}

