/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.settings.WebServicePreferenceStore;
import com.kms.katalon.composer.webservice.view.WSRequestPartUI;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenWebServiceRequestObjectHandler {
    @Inject
    MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    IEclipseContext context;
    @Inject
    EPartService partService;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && WebServiceRequestEntity.class.isInstance(object)) {
                    OpenWebServiceRequestObjectHandler.this.openRequestObject((WebServiceRequestEntity)object);
                }
            }
        });
        eventBroker.subscribe("WORKSPACE/DRAFT_PART_CLOSED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                java.util.Optional optional = OpenWebServiceRequestObjectHandler.this.getDraftWebService(event);
                if (!optional.isPresent()) {
                    return;
                }
                WebServicePreferenceStore store = new WebServicePreferenceStore();
                try {
                    store.removeDraftRequest((DraftWebServiceRequestEntity)optional.get(), ProjectController.getInstance().getCurrentProject());
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        eventBroker.subscribe("EXPLORER/OPEN_ITEM_BY_PART_ID", new EventHandler(){

            public void handleEvent(Event event) {
                java.util.Optional optional = OpenWebServiceRequestObjectHandler.this.getDraftWebService(event);
                if (optional.isPresent()) {
                    try {
                        OpenWebServiceRequestObjectHandler.this.openDraftRequest((DraftWebServiceRequestEntity)optional.get());
                    }
                    catch (IOException | CoreException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
        eventBroker.subscribe("EXPLORER/OPEN_DRAFT_WEBSERVICE", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (object instanceof DraftWebServiceRequestEntity) {
                    try {
                        OpenWebServiceRequestObjectHandler.this.openDraftRequest((DraftWebServiceRequestEntity)object);
                    }
                    catch (IOException | CoreException e) {
                        MultiStatusErrorDialog.showErrorDialog((String)"Unalbe to open request", (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                    }
                }
            }
        });
    }

    private java.util.Optional<DraftWebServiceRequestEntity> getDraftWebService(Event event) {
        Object object = event.getProperty("org.eclipse.e4.data");
        if (!(object instanceof String)) {
            return java.util.Optional.empty();
        }
        String partId = (String)object;
        if (!partId.startsWith("com.kms.katalon.composer.content.draftRequest")) {
            return java.util.Optional.empty();
        }
        String draftRequestUid = EntityPartUtil.getEntityIdFromPartId((String)partId, (String)"com.kms.katalon.composer.content.draftRequest");
        WebServicePreferenceStore store = new WebServicePreferenceStore();
        java.util.Optional<DraftWebServiceRequestEntity> optional = store.getDraftRequests(ProjectController.getInstance().getCurrentProject()).stream().filter(request -> request.getDraftUid().equals(draftRequestUid)).findFirst();
        return optional;
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="WSOBJECT/OPEN") WebServiceRequestEntity entity) {
        this.openRequestObject(entity);
    }

    public void openRequestObject(WebServiceRequestEntity requestObject) {
        try {
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            String partId = EntityPartUtil.getTestObjectPartId((String)requestObject.getId());
            MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            if (stack != null) {
                if (mPart == null) {
                    WSRequestPartUI.create(requestObject, stack);
                    Trackings.trackOpenObject((String)"webServiceRequest");
                } else {
                    stack.setSelectedElement((MUIElement)mPart);
                }
            }
        }
        catch (IOException | CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.MSG_CANNOT_OPEN_REQUEST);
        }
    }

    public void openRequestHistoryObject(RequestHistoryEntity historyRequest) {
        DraftWebServiceRequestEntity draftWebServiceEntity = (DraftWebServiceRequestEntity)JsonUtil.fromJson((String)JsonUtil.toJson((Object)historyRequest.getRequest()), DraftWebServiceRequestEntity.class);
        draftWebServiceEntity.setDraftUid(historyRequest.getUid());
        try {
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            String partId = EntityPartUtil.getDraftRequestPartId((String)draftWebServiceEntity.getDraftUid());
            if (stack != null) {
                MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
                if (mPart == null) {
                    WSRequestPartUI.create((WebServiceRequestEntity)draftWebServiceEntity, stack);
                    Trackings.trackOpenDraftRequest((String)draftWebServiceEntity.getServiceType(), (String)"history");
                } else {
                    stack.setSelectedElement((MUIElement)mPart);
                }
            }
            WebServicePreferenceStore store = new WebServicePreferenceStore();
            store.saveDraftRequest(draftWebServiceEntity, ProjectController.getInstance().getCurrentProject());
        }
        catch (IOException | CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((String)"Unable to open request", (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public void openDraftRequest(DraftWebServiceRequestEntity draftRequest) throws IOException, CoreException {
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        String partId = EntityPartUtil.getDraftRequestPartId((String)draftRequest.getDraftUid());
        if (stack != null) {
            MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            if (mPart == null) {
                WSRequestPartUI.create((WebServiceRequestEntity)draftRequest, stack);
            } else {
                stack.setSelectedElement((MUIElement)mPart);
            }
            this.setSelectedExplorerPart();
        }
    }

    private void setSelectedExplorerPart() {
        MPart requestHistoryPart;
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.partstack.explorer", (MUIElement)this.application);
        if (stack != null && (requestHistoryPart = this.partService.findPart("com.kms.katalon.composer.webservice.part.requestHistory")) != null && !((MStackElement)stack.getSelectedElement()).getElementId().equals(requestHistoryPart.getElementId())) {
            stack.setSelectedElement((MUIElement)requestHistoryPart);
        }
    }
}

