/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.view.ApiQuickStartDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenApiQuickStartHandler {
    @Inject
    private IEventBroker eventBroker;
    private FolderTreeEntity objectRepositoryTreeRoot;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("API/OPEN_QUICK_START_DIALOG", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                ProjectType projectType = (ProjectType)event.getProperty("org.eclipse.e4.data");
                OpenApiQuickStartHandler.this.execute(null, projectType);
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional Object[] selectedObjects) {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        this.execute(selectedObjects, currentProject.getType());
    }

    public void execute(Object[] selectedObjects, ProjectType projectType) {
        try {
            ITreeEntity parentTreeEntity = OpenApiQuickStartHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.objectRepositoryTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.objectRepositoryTreeRoot;
            }
            ApiQuickStartDialog quickStartDialog = new ApiQuickStartDialog(parentTreeEntity, Display.getCurrent().getActiveShell(), projectType);
            quickStartDialog.open();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Inject
    @Optional
    private void catchTestDataFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

