/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.webservice.handlers.OpenWebServiceRequestObjectHandler;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class NewSoapRequestHandler {
    @Inject
    IEclipseContext context;

    @CanExecute
    public boolean canExecute() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        return currentProject != null && ProjectType.WEBSERVICE == currentProject.getType();
    }

    @Execute
    public void execute() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        DraftWebServiceRequestEntity draftWebService = ObjectRepositoryController.getInstance().newDraftWebServiceEntity(currentProject);
        draftWebService.setServiceType("SOAP");
        try {
            OpenWebServiceRequestObjectHandler handler = (OpenWebServiceRequestObjectHandler)this.context.get(OpenWebServiceRequestObjectHandler.class);
            handler.openDraftRequest(draftWebService);
            Trackings.trackOpenDraftRequest((String)draftWebService.getServiceType(), (String)"button");
        }
        catch (IOException | CoreException e) {
            MultiStatusErrorDialog.showErrorDialog((String)"Unable to open request", (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }
}

