/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.view.ImportWebServiceObjectsFromWSDLDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.tracking.service.Trackings;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ImportWebServiceRequestObjectsFromWSDLHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    IEclipseContext context;
    private FolderTreeEntity objectRepositoryTreeRoot;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("WSOBJECT/WSDL", new EventHandler(){

            public void handleEvent(Event event) {
                if (!ImportWebServiceRequestObjectsFromWSDLHandler.this.canExecute()) {
                    return;
                }
                ImportWebServiceRequestObjectsFromWSDLHandler.this.execute(null, Display.getCurrent().getActiveShell());
            }
        });
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional Object[] selectedObjects, @Named(value="activeShell") Shell parentShell) {
        try {
            ITreeEntity parentTreeEntity = ImportWebServiceRequestObjectsFromWSDLHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.objectRepositoryTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.objectRepositoryTreeRoot;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
            ImportWebServiceObjectsFromWSDLDialog dialog = new ImportWebServiceObjectsFromWSDLDialog(parentShell);
            String[] requestMethods = new String[]{"SOAP", "SOAP12"};
            if (dialog.open() == 0) {
                int i = 0;
                while (i < requestMethods.length) {
                    String requestMethod = requestMethods[i];
                    List<WebServiceRequestEntity> soapRequestEntities = dialog.getWebServiceRequestEntities(requestMethod);
                    if (soapRequestEntities != null && soapRequestEntities.size() > 0) {
                        FolderEntity folder = FolderController.getInstance().addNewFolder(parentFolderEntity, requestMethod);
                        new FolderTreeEntity(folder, parentTreeEntity);
                        for (WebServiceRequestEntity entity : soapRequestEntities) {
                            entity.setElementGuidId(Util.generateGuid());
                            entity.setParentFolder(folder);
                            entity.setProject(folder.getProject());
                            toController.saveNewTestObject((WebElementEntity)entity);
                        }
                    }
                    ++i;
                }
                this.trackImportWSDL(dialog.getWSDLSpecLocation());
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)parentTreeEntity);
            }
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void trackImportWSDL(String wsdlSpecLocation) {
        try {
            Paths.get(wsdlSpecLocation, new String[0]);
            Trackings.trackImportWSDL((String)"file");
        }
        catch (Throwable throwable) {
            Trackings.trackImportWSDL((String)"url");
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Inject
    @Optional
    private void catchTestDataFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

