/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.parts.SoapServicePart;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SoapRequestMessageEditor
extends Composite {
    private SoapServicePart servicePart;
    private MirrorEditor mirrorEditor;
    private Button chckWrapLine;
    private WebServiceRequestEntity requestEntity;

    public SoapRequestMessageEditor(Composite parent, int style, SoapServicePart servicePart) {
        super(parent, style);
        this.servicePart = servicePart;
        this.setLayout((Layout)new GridLayout());
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.mirrorEditor = new MirrorEditor(bodyContentComposite, 0);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                SoapRequestMessageEditor.this.mirrorEditor.changeMode(TextContentType.XML.getText());
                SoapRequestMessageEditor.this.handleControlModifyListeners();
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        bodyContentComposite.setLayout((Layout)gridLayout);
        this.chckWrapLine = new Button(bodyContentComposite, 32);
        this.chckWrapLine.setText(ComposerWebserviceMessageConstants.PA_LBL_WRAP_LINE);
        this.chckWrapLine.setSelection(true);
    }

    public void setInput(WebServiceRequestEntity requestEntity) {
        this.requestEntity = requestEntity;
        if (requestEntity != null) {
            this.mirrorEditor.setText(requestEntity.getSoapBody());
        }
    }

    private void handleControlModifyListeners() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapRequestMessageEditor.this.mirrorEditor.wrapLine(SoapRequestMessageEditor.this.chckWrapLine.getSelection());
            }
        });
        this.mirrorEditor.addListener(24, event -> this.servicePart.setDirty(true));
    }

    public String getHttpBodyContent() {
        return this.mirrorEditor.getText();
    }
}

