/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.webservice.editor.FileBodyEditor;
import com.kms.katalon.composer.webservice.editor.FormDataBodyEditor;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.composer.webservice.editor.TextBodyEditor;
import com.kms.katalon.composer.webservice.editor.UrlEncodedBodyEditor;
import com.kms.katalon.composer.webservice.parts.RestServicePart;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.TextBodyContent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class HttpBodyEditorComposite
extends Composite {
    private Map<String, HttpBodyEditor> bodyEditors = new HashMap<String, HttpBodyEditor>();
    private Map<String, Button> bodySelectionButtons = new HashMap<String, Button>();
    private Button tltmText;
    private Button tltmUrlEncoded;
    private Button tltmFormData;
    private Button tltmBinary;
    private StackLayout slBodyContent;
    private WebServiceRequestEntity webServiceEntity;
    private RestServicePart servicePart;
    private String selectedBodyType;
    private boolean isInputReady;

    public HttpBodyEditorComposite(Composite parent, int style, RestServicePart servicePart) {
        super(parent, style);
        this.servicePart = servicePart;
        this.setLayout((Layout)new GridLayout());
        Composite bodyTypeComposite = new Composite((Composite)this, 0);
        bodyTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glBodyType = new GridLayout(2, false);
        glBodyType.marginHeight = 0;
        glBodyType.marginWidth = 0;
        bodyTypeComposite.setLayout((Layout)glBodyType);
        Composite tbBodyType = new Composite(bodyTypeComposite, 0);
        tbBodyType.setLayout((Layout)new GridLayout(4, false));
        this.tltmText = new Button(tbBodyType, 16);
        this.tltmText.setText("text");
        this.bodySelectionButtons.put("text", this.tltmText);
        this.tltmUrlEncoded = new Button(tbBodyType, 16);
        this.tltmUrlEncoded.setText("x-www-form-urlencoded");
        this.bodySelectionButtons.put("x-www-form-urlencoded", this.tltmUrlEncoded);
        this.tltmFormData = new Button(tbBodyType, 16);
        this.tltmFormData.setText("form-data");
        this.bodySelectionButtons.put("form-data", this.tltmFormData);
        this.tltmBinary = new Button(tbBodyType, 16);
        this.tltmBinary.setText("file");
        this.bodySelectionButtons.put("file", this.tltmBinary);
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.slBodyContent = new StackLayout();
        bodyContentComposite.setLayout((Layout)this.slBodyContent);
        TextBodyEditor textBodyEditor = new TextBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("text", textBodyEditor);
        UrlEncodedBodyEditor urlEncodedEditor = new UrlEncodedBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("x-www-form-urlencoded", urlEncodedEditor);
        FormDataBodyEditor formDataEditor = new FormDataBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("form-data", formDataEditor);
        FileBodyEditor fileBodyEditor = new FileBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("file", fileBodyEditor);
        this.handleControlModifyListeners();
    }

    private void migrateFromOldVersion(WebServiceRequestEntity requestEntity) {
        if (StringUtils.isEmpty((CharSequence)requestEntity.getHttpBodyContent()) && StringUtils.isNotEmpty((CharSequence)requestEntity.getHttpBody())) {
            this.selectedBodyType = "text";
            TextBodyContent textBodyContent = new TextBodyContent();
            textBodyContent.setText(requestEntity.getHttpBody());
            WebElementPropertyEntity contentTypeProperty = this.findContentTypeProperty();
            if (contentTypeProperty != null) {
                textBodyContent.setContentType(contentTypeProperty.getValue());
            }
        }
    }

    public void setInput(WebServiceRequestEntity requestEntity) {
        this.isInputReady = false;
        this.webServiceEntity = requestEntity;
        this.migrateFromOldVersion(this.webServiceEntity);
        this.selectedBodyType = (String)StringUtils.defaultIfEmpty((CharSequence)this.webServiceEntity.getHttpBodyType(), (CharSequence)"text");
        Button selectedButton = this.bodySelectionButtons.get(this.selectedBodyType);
        this.bodyEditors.get(this.selectedBodyType).setInput(this.webServiceEntity.getHttpBodyContent());
        selectedButton.setSelection(true);
        selectedButton.notifyListeners(13, new Event());
        this.isInputReady = true;
    }

    private void handleControlModifyListeners() {
        SelectionAdapter bodyTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                HttpBodyEditorComposite.this.selectedBodyType = source.getText();
                HttpBodyEditor httpBodyEditor = (HttpBodyEditor)((Object)HttpBodyEditorComposite.this.bodyEditors.get(HttpBodyEditorComposite.this.selectedBodyType));
                httpBodyEditor.onBodyTypeChanged();
                ((HttpBodyEditorComposite)HttpBodyEditorComposite.this).slBodyContent.topControl = httpBodyEditor;
                httpBodyEditor.getParent().layout();
                if (!HttpBodyEditorComposite.this.isInputReady) {
                    return;
                }
                HttpBodyEditorComposite.this.servicePart.setDirty(true);
                HttpBodyEditorComposite.this.updateContentTypeByEditor(httpBodyEditor);
            }
        };
        this.bodySelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)bodyTypeSelectedListener));
        this.bodyEditors.values().forEach(editor2 -> editor2.addListener(24, event -> {
            if (this.isInputReady) {
                this.servicePart.setDirty(true);
                this.updateContentTypeByEditor((HttpBodyEditor)((Object)editor2));
            }
        }));
    }

    private void updateContentTypeByEditor(HttpBodyEditor editor2) {
        if (editor2.isContentTypeUpdated()) {
            WebElementPropertyEntity propertyEntity = this.findContentTypeProperty();
            String newContentType = editor2.getContentType();
            if (propertyEntity != null) {
                propertyEntity.setValue(newContentType);
            } else {
                propertyEntity = new WebElementPropertyEntity("Content-Type", newContentType);
                this.webServiceEntity.getHttpHeaderProperties().add(0, propertyEntity);
            }
            this.servicePart.updateHeaders(this.webServiceEntity);
            editor2.setContentTypeUpdated(false);
        }
    }

    private WebElementPropertyEntity findContentTypeProperty() {
        WebElementPropertyEntity propertyEntity = this.webServiceEntity.getHttpHeaderProperties().stream().filter(h -> "Content-Type".equals(h.getName())).findFirst().orElse(null);
        return propertyEntity;
    }

    public String getHttpBodyType() {
        return this.selectedBodyType;
    }

    public String getHttpBodyContent() {
        return this.bodyEditors.get(this.selectedBodyType).getContentData();
    }
}

