/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.dialogs;

import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddOrEditWebServiceMethodDialog
extends Dialog {
    private WebServiceMethod method;
    private Text txtMethod;
    private String methodName;
    private Label lblError;
    private Text txtDescription;
    private String description;
    private List<WebServiceMethod> existingMethods;
    private boolean editMode = false;

    public AddOrEditWebServiceMethodDialog(Shell parentShell, WebServiceMethod method, List<WebServiceMethod> existingMethods, boolean editMode) {
        super(parentShell);
        this.method = method != null ? method : new WebServiceMethod();
        this.methodName = this.method.getName();
        this.description = this.method.getDescription();
        this.existingMethods = existingMethods;
        this.editMode = editMode;
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        GridData gdBody = new GridData(4, 4, true, true);
        gdBody.widthHint = 400;
        body.setLayoutData((Object)gdBody);
        Label lblMethod = new Label(body, 0);
        lblMethod.setText(StringConstants.DiaEditWSMethod_LBL_METHOD);
        this.txtMethod = new Text(body, 2048);
        this.txtMethod.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtMethod.setText(this.method.getName());
        Label lblDescription = new Label(body, 0);
        lblDescription.setText(StringConstants.DiaEditWSMethod_LBL_DESCRIPTION);
        this.txtDescription = new Text(body, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtDescription.setText(this.method.getDescription());
        Label lblEmpty = new Label(body, 0);
        lblEmpty.setText("");
        this.lblError = new Label(body, 0);
        this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
        this.lblError.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setLblErrorVisible(false);
        this.registerControlListeners();
        return super.createDialogArea(parent);
    }

    private void registerControlListeners() {
        this.txtMethod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddOrEditWebServiceMethodDialog.this.methodName = AddOrEditWebServiceMethodDialog.this.txtMethod.getText();
            }
        });
        this.txtMethod.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddOrEditWebServiceMethodDialog.this.description = AddOrEditWebServiceMethodDialog.this.txtDescription.getText();
            }
        });
    }

    protected boolean validateMethodName(String methodName) {
        this.setLblErrorVisible(false);
        boolean hasError = false;
        String errorMessage = null;
        if (StringUtils.isBlank((CharSequence)methodName)) {
            hasError = true;
            errorMessage = StringConstants.DiaEditWSMethod_MSG_EMPTY_METHOD_NAME;
        } else if (this.methodExists(methodName)) {
            hasError = !this.editMode ? true : !methodName.equalsIgnoreCase(this.method.getName());
            if (hasError) {
                errorMessage = StringConstants.DiaEditWSMethod_MSG_DUPLICATED_METHOD_NAME;
            }
        } else {
            hasError = false;
        }
        if (hasError) {
            this.displayErrorMessage(errorMessage);
        }
        return hasError;
    }

    private String trimMethodName(String methodName) {
        return methodName.trim().replaceAll("\\s+", " ");
    }

    private boolean methodExists(String methodName) {
        return this.existingMethods.stream().anyMatch(method -> method.getName().equalsIgnoreCase(methodName));
    }

    private void displayErrorMessage(String message) {
        this.setLblErrorVisible(true);
        this.lblError.setText(message);
    }

    private void setLblErrorVisible(boolean visible) {
        ((GridData)this.lblError.getLayoutData()).exclude = !visible;
        this.lblError.setVisible(visible);
        this.lblError.getParent().layout(true, true);
    }

    public WebServiceMethod getMethod() {
        this.method.setName(this.methodName);
        this.method.setType("Custom");
        this.method.setDescription(this.description);
        return this.method;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.editMode) {
            shell.setText(StringConstants.DiaEditWSMethod_TITLE_EDIT);
        } else {
            shell.setText(StringConstants.DiaEditWSMethod_TITLE_ADD_NEW);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.methodName = this.trimMethodName(this.methodName);
        boolean hasError = this.validateMethodName(this.methodName);
        if (!hasError) {
            super.okPressed();
        }
    }
}

