/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.jasper.pdf;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.util.internal.JarUtil;
import com.kms.katalon.internal.jasper.classpath.JasperClasspathManager;
import com.kms.katalon.jasper.pdf.exception.JasperReportException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public abstract class AbstractPdfReportGenerator {
    private static final String TPL_DIR = "resources/template/pdf/";
    protected static final String TEST_SUITE_TPL = "resources/template/pdf/test_suite_tpl.jrxml";
    protected static final String TEST_CASE_TPL = "resources/template/pdf/test_case_tpl.jrxml";
    protected static final String TEST_CASE_SUMMARY_TPL = "resources/template/pdf/test_case_summary.jrxml";

    protected abstract ILogRecord[] getLogRecords();

    protected abstract String getPrimaryTemplateLocation();

    protected abstract Map<String, Object> getAdditionalParams();

    private Map<String, Object> getReportParams() {
        HashMap<String, Object> jasperParams = new HashMap<String, Object>();
        jasperParams.put("TEST_CASE_TPL", TEST_CASE_TPL);
        jasperParams.put("TEST_CASE_SUMMARY_TPL", TEST_CASE_SUMMARY_TPL);
        jasperParams.putAll(this.getAdditionalParams());
        return jasperParams;
    }

    public File exportToPDF(String fileLocation) throws JasperReportException, IOException {
        File pdfFile = new File(fileLocation);
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            JasperClasspathManager.getInstance().modifySystemProperties();
            JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)JarUtil.getResourceAsInputStream(this.getClass(), (String)this.getPrimaryTemplateLocation()));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.getReportParams(), (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(this.getLogRecords())));
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)pdfFile.getAbsolutePath());
            File file = pdfFile;
            return file;
        }
        catch (JRException e) {
            throw new JasperReportException(e.getMessage());
        }
        finally {
            thread.setContextClassLoader(loader);
            JasperClasspathManager.getInstance().restoreSystemProperties();
        }
    }
}

