/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.internal.jasper.classpath;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JarUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class JasperClasspathManager {
    private static JasperClasspathManager _instance;
    public static final String CLASSPATH_PROPERTY = "java.class.path";
    public static final String REPORT_TEMP_DIR_PROPERTY = "user.dir";
    private Map<String, String> jasperCompilerProperties = new HashMap<String, String>();
    private boolean resolveClasspath = false;

    private JasperClasspathManager() {
    }

    public static JasperClasspathManager getInstance() {
        if (_instance == null) {
            _instance = new JasperClasspathManager();
        }
        return _instance;
    }

    public synchronized void restoreSystemProperties() {
        for (Map.Entry<String, String> compilerProperty : this.jasperCompilerProperties.entrySet()) {
            System.setProperty(compilerProperty.getKey(), compilerProperty.getValue());
        }
    }

    public synchronized void modifySystemProperties() {
        if (!this.resolveClasspath) {
            this.modifyClasspathProperty();
            this.modifyTempDirProperty();
        }
        this.resolveClasspath = true;
    }

    private void modifyTempDirProperty() {
        this.jasperCompilerProperties.put(REPORT_TEMP_DIR_PROPERTY, System.getProperty(REPORT_TEMP_DIR_PROPERTY));
        String tempFolderLoc = ProjectController.getInstance().getTempDir();
        System.setProperty(REPORT_TEMP_DIR_PROPERTY, String.valueOf(tempFolderLoc) + "/generated/pdf");
    }

    private File getTempClasspathDir() {
        String nonRemovableSystemDir = ProjectController.getInstance().getNonremovableTempDir();
        return new File(nonRemovableSystemDir, "com.kms.katalon.jasper");
    }

    private void modifyClasspathProperty() {
        this.jasperCompilerProperties.put(CLASSPATH_PROPERTY, System.getProperty(CLASSPATH_PROPERTY));
        try {
            StringBuilder classPathBuilder = new StringBuilder();
            File tempClasspathDir = this.getTempClasspathDir();
            if (tempClasspathDir.exists()) {
                FileUtils.cleanDirectory((File)tempClasspathDir);
            }
            tempClasspathDir.mkdirs();
            File[] fileArray = JarUtil.getFiles(this.getClass(), (String)"resources/lib", (File)tempClasspathDir);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File libFile = fileArray[n2];
                classPathBuilder.append(libFile.getAbsolutePath()).append(";");
                ++n2;
            }
            System.setProperty(CLASSPATH_PROPERTY, classPathBuilder.toString());
        }
        catch (IOException | URISyntaxException exception) {
            this.restoreSystemProperties();
        }
    }
}

