/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.reader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import v2.io.swagger.io.Authentication;
import v2.io.swagger.io.HttpClient;
import v2.io.swagger.reader.SwaggerReader;
import v2.io.swagger.report.Message;
import v2.io.swagger.report.MessageBuilder;
import v2.io.swagger.report.Severity;

final class SimpleSwaggerReader
implements SwaggerReader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    SimpleSwaggerReader() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public JsonNode read(String url, Authentication authentication, MessageBuilder messageBuilder) {
        HttpClient httpClient = new HttpClient(url);
        JsonNode jsonNode = null;
        authentication.apply(httpClient);
        try {
            InputStream swaggerJson = httpClient.execute();
            jsonNode = this.objectMapper.readTree(swaggerJson);
        }
        catch (IOException | URISyntaxException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        httpClient.close();
        return jsonNode;
    }
}

