/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.parser.processors;

import java.util.Map;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.properties.ArrayProperty;
import v2.io.swagger.models.properties.MapProperty;
import v2.io.swagger.models.properties.ObjectProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.RefProperty;
import v2.io.swagger.parser.ResolverCache;
import v2.io.swagger.parser.processors.ExternalRefProcessor;
import v2.io.swagger.parser.util.RefUtils;

public class PropertyProcessor {
    private final ExternalRefProcessor externalRefProcessor;

    public PropertyProcessor(ResolverCache cache, Swagger swagger) {
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processProperty(Property property) {
        if (property instanceof RefProperty) {
            this.processRefProperty((RefProperty)property);
        } else if (property instanceof ArrayProperty) {
            this.processArrayProperty((ArrayProperty)property);
        } else if (property instanceof MapProperty) {
            this.processMapProperty((MapProperty)property);
        } else if (property instanceof ObjectProperty) {
            this.processObjectProperty((ObjectProperty)property);
        }
    }

    private void processRefProperty(RefProperty refProperty) {
        String newRef;
        if (RefUtils.isAnExternalRefFormat(refProperty.getRefFormat()) && (newRef = this.externalRefProcessor.processRefToExternalDefinition(refProperty.get$ref(), refProperty.getRefFormat())) != null) {
            refProperty.set$ref(newRef);
        }
    }

    private void processMapProperty(MapProperty property) {
        Property additionalProperties = property.getAdditionalProperties();
        if (additionalProperties != null) {
            this.processProperty(additionalProperties);
        }
    }

    private void processArrayProperty(ArrayProperty property) {
        Property items = property.getItems();
        if (items != null) {
            this.processProperty(items);
        }
    }

    private void processObjectProperty(ObjectProperty property) {
        Map<String, Property> properties = property.getProperties();
        if (properties != null) {
            for (Property p : properties.values()) {
                this.processProperty(p);
            }
        }
    }
}

