/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import v2.io.swagger.annotations.ApiModel;
import v2.io.swagger.annotations.ApiModelProperty;
import v2.io.swagger.jackson.PackageVersion;

public class SwaggerAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        ApiModelProperty ann = (ApiModelProperty)m.getAnnotation(ApiModelProperty.class);
        return ann != null && ann.hidden();
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        ApiModelProperty ann = (ApiModelProperty)m.getAnnotation(ApiModelProperty.class);
        if (ann != null) {
            return ann.required();
        }
        XmlElement elem = (XmlElement)m.getAnnotation(XmlElement.class);
        if (elem != null && elem.required()) {
            return true;
        }
        return null;
    }

    public String findPropertyDescription(Annotated a) {
        ApiModel model = (ApiModel)a.getAnnotation(ApiModel.class);
        if (model != null && !"".equals(model.description())) {
            return model.description();
        }
        ApiModelProperty prop = (ApiModelProperty)a.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            return prop.value();
        }
        return null;
    }

    public Integer findPropertyIndex(Annotated a) {
        ApiModelProperty prop = (ApiModelProperty)a.getAnnotation(ApiModelProperty.class);
        if (prop != null && prop.position() != 0) {
            return prop.position();
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        ApiModel api = (ApiModel)a.getAnnotation(ApiModel.class);
        if (api != null) {
            Class<?>[] classes = api.subTypes();
            ArrayList<NamedType> names = new ArrayList<NamedType>(classes.length);
            for (Class<?> subType : classes) {
                names.add(new NamedType(subType));
            }
            if (!names.isEmpty()) {
                return names;
            }
        }
        return Collections.emptyList();
    }

    public String findTypeName(AnnotatedClass ac) {
        return null;
    }
}

