/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.cucumber.keyword;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.formatter.Formatter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;

public class CucumberReporter
implements Formatter {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    public void setEventPublisher(EventPublisher eventPublisher) {
        eventPublisher.registerHandlerFor(TestCaseStarted.class, (EventHandler)new EventHandler<TestCaseStarted>(){

            public void receive(TestCaseStarted event) {
                TestCase testCase = event.testCase;
                String name = CucumberReporter.this.getTestCaseName(testCase);
                CucumberReporter.this.logger.startTest(name, new HashMap(), new Stack());
            }
        });
        eventPublisher.registerHandlerFor(TestCaseFinished.class, (EventHandler)new EventHandler<TestCaseFinished>(){

            public void receive(TestCaseFinished event) {
                TestCase testCase = event.testCase;
                String name = CucumberReporter.this.getTestCaseName(testCase);
                Result result = event.result;
                CucumberReporter.this.logResult(name, result);
                CucumberReporter.this.logger.endTest(name, new HashMap());
            }
        });
        eventPublisher.registerHandlerFor(TestRunStarted.class, (EventHandler)new EventHandler<TestRunStarted>(){

            public void receive(TestRunStarted event) {
            }
        });
        eventPublisher.registerHandlerFor(TestRunFinished.class, (EventHandler)new EventHandler<TestRunFinished>(){

            public void receive(TestRunFinished event) {
            }
        });
        eventPublisher.registerHandlerFor(TestStepStarted.class, (EventHandler)new EventHandler<TestStepStarted>(){

            public void receive(TestStepStarted event) {
                if (event.testStep instanceof PickleStepTestStep) {
                    CucumberReporter.this.logger.startKeyword(CucumberReporter.this.getStepText(event), new HashMap(), new Stack());
                }
            }
        });
        eventPublisher.registerHandlerFor(TestStepFinished.class, (EventHandler)new EventHandler<TestStepFinished>(){

            public void receive(TestStepFinished event) {
                if (event.testStep instanceof PickleStepTestStep) {
                    String name = CucumberReporter.this.getStepText(event);
                    Result result = event.result;
                    CucumberReporter.this.logResult(name, result);
                    CucumberReporter.this.logger.endKeyword(name, new HashMap(), new Stack());
                }
            }
        });
    }

    private void logResult(String name, Result result) {
        Result.Type status = result.getStatus();
        if (Result.Type.PASSED.equals((Object)status)) {
            this.logger.logPassed(name);
        } else {
            Throwable t = result.getError();
            if (t == null) {
                LogLevel level = Result.Type.FAILED.equals((Object)status) ? LogLevel.FAILED : LogLevel.NOT_RUN;
                this.logger.logMessage(level, name);
            } else {
                String stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable((Throwable)t);
                String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, name, stackTraceForThrowable);
                this.logError(t, message);
            }
        }
    }

    private String getStepText(TestStepStarted event) {
        String text = event.testStep instanceof PickleStepTestStep ? ((PickleStepTestStep)event.testStep).getStepText() : "";
        return text;
    }

    private String getStepText(TestStepFinished event) {
        String text = event.testStep instanceof PickleStepTestStep ? ((PickleStepTestStep)event.testStep).getStepText() : "";
        return text;
    }

    private void logError(Throwable t, String message) {
        this.logger.logMessage(ErrorCollector.fromError((Throwable)t), message, t);
    }

    private String getTestCaseName(TestCase testCase) {
        String name = "SCENARIO " + testCase.getName();
        return name;
    }
}

