/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service.impl;

import com.kms.katalon.application.utils.FileUtil;
import com.kms.katalon.composer.integration.slack.util.SlackUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.integration.jira.setting.JiraIntegrationSettingStore;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.GitToolbarExecutableStatus;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.model.ProjectStatistics;
import com.kms.katalon.tracking.osgi.service.IProjectStatisticsCollector;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectStatisticsCollector
implements IProjectStatisticsCollector {
    private static final String TEST_CASE_SCRIPT_FOLDER = "Scripts";
    private static final String GROOVY_FILE_EXTENSION = "groovy";
    private static final String EXECUTION_PROPERTIES_FILE_EXTENSION = "properties";
    private ProjectEntity project;
    private FolderController folderController = FolderController.getInstance();
    private ProjectStatistics statistics;

    public ProjectStatistics collect(ProjectEntity project) throws Exception {
        this.project = project;
        this.statistics = new ProjectStatistics();
        this.statistics.setProjectId(project.getUUID());
        this.countTestCasesAndJiraIntegratedTestCases();
        this.countTestSteps();
        this.countTestObjects();
        this.countTestSuitesAndTestCasesInTestSuitesAndTestSuiteCollections();
        this.countTestData();
        this.countCheckpoints();
        this.countCustomKeywords();
        this.countTestListeners();
        this.countReportsAndTestExecutions();
        this.countProfiles();
        this.countFeatureFiles();
        this.countGroovyScriptFiles();
        this.statistics.setGitIntegrated(this.isGitIntegrated());
        this.statistics.setJiraIntegrated(this.isJiraIntegrated());
        this.statistics.setKobitonIntegrated(this.isKobitonIntegrated());
        this.statistics.setqTestIntegrated(this.isqTestIntegrated());
        this.statistics.setSlackIntegrated(this.isSlackIntegrated());
        this.statistics.setKatalonAnalyticsIntegrated(this.isKatalonAnalyticsIntegrated());
        this.statistics.setRemoteWebDriverConfigured(this.isRemoteWebDriverConfigured());
        this.statistics.setContinueOnFailure(this.isAutoApplyNeighborXpathsEnabled());
        this.statistics.setWebLocatorConfig(this.getWebLocatorConfig());
        return this.statistics;
    }

    private void countTestCasesAndJiraIntegratedTestCases() throws Exception {
        int testCaseCount = 0;
        int jiraIntegratedTestCaseCount = 0;
        FolderEntity testCaseFolder = this.folderController.getTestCaseRoot(this.project);
        List entities = this.folderController.getAllDescentdantEntities(testCaseFolder);
        for (Object entity : entities) {
            if (!(entity instanceof TestCaseEntity)) continue;
            ++testCaseCount;
            TestCaseEntity testCase = (TestCaseEntity)entity;
            if (testCase.getIntegratedEntity("JIRA") == null) continue;
            ++jiraIntegratedTestCaseCount;
        }
        this.statistics.setTestCaseCount(testCaseCount);
        this.statistics.setJiraIntegratedTestCaseCount(jiraIntegratedTestCaseCount);
    }

    private void countTestSteps() throws IOException {
        File[] scriptFiles;
        int callTestCaseTestStepCount = 0;
        int webTestStepCount = 0;
        int mobileTestStepCount = 0;
        int apiTestStepCount = 0;
        int customKeywordTestStepCount = 0;
        int totalTestStepCount = 0;
        String testCaseScriptFolderPath = String.valueOf(this.project.getFolderLocation()) + File.separator + TEST_CASE_SCRIPT_FOLDER;
        File testCaseScriptFolder = new File(testCaseScriptFolderPath);
        File[] fileArray = scriptFiles = this.listFiles(testCaseScriptFolder, GROOVY_FILE_EXTENSION);
        int n = scriptFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File scriptFile = fileArray[n2];
            String script = FileUtils.readFileToString((File)scriptFile);
            StringTokenizer st = new StringTokenizer(script, "\n=");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("WebUI.callTestCase") || token.startsWith("WebUiBuiltInKeywords.callTestCase")) {
                    ++callTestCaseTestStepCount;
                    ++totalTestStepCount;
                    continue;
                }
                if (token.startsWith("WebUI.") || token.startsWith("WebUiBuiltInKeywords.")) {
                    ++webTestStepCount;
                    ++totalTestStepCount;
                    continue;
                }
                if (token.startsWith("Mobile.") || token.startsWith("MobileBuiltInKeywords.")) {
                    ++mobileTestStepCount;
                    ++totalTestStepCount;
                    continue;
                }
                if (token.startsWith("WS.") || token.startsWith("WSBuiltInKeywords.")) {
                    ++apiTestStepCount;
                    ++totalTestStepCount;
                    continue;
                }
                if (token.startsWith("CustomKeywords.")) {
                    ++customKeywordTestStepCount;
                    ++totalTestStepCount;
                    continue;
                }
                if (token.startsWith("import ") || token.startsWith("class ") || token.startsWith("// ") || token.startsWith("/** ") || token.startsWith("**/ ") || token.startsWith("'") || token.startsWith("'''")) continue;
                ++totalTestStepCount;
            }
            ++n2;
        }
        this.statistics.setCallTestCaseTestStepCount(callTestCaseTestStepCount);
        this.statistics.setWebTestStepCount(webTestStepCount);
        this.statistics.setMobileTestStepCount(mobileTestStepCount);
        this.statistics.setApiTestStepCount(apiTestStepCount);
        this.statistics.setCustomKeywordTestStepCount(customKeywordTestStepCount);
        this.statistics.setTotalTestStepCount(totalTestStepCount);
    }

    private void countTestObjects() throws Exception {
        int apiTestObjectCount = 0;
        int webTestObjectCount = 0;
        FolderEntity testObjectFolder = this.folderController.getObjectRepositoryRoot(this.project);
        List entities = this.folderController.getAllDescentdantEntities(testObjectFolder);
        for (Object entity : entities) {
            if (entity instanceof WebServiceRequestEntity) {
                ++apiTestObjectCount;
                continue;
            }
            if (!(entity instanceof WebElementEntity)) continue;
            ++webTestObjectCount;
        }
        this.statistics.setApiTestObjectCount(apiTestObjectCount);
        this.statistics.setWebTestObjectCount(webTestObjectCount);
    }

    private void countTestSuitesAndTestCasesInTestSuitesAndTestSuiteCollections() throws Exception {
        int testSuiteCount = 0;
        int testCaseInTestSuiteCount = 0;
        int testSuiteCollectionCount = 0;
        FolderEntity testSuiteFolder = this.folderController.getTestSuiteRoot(this.project);
        List entities = this.folderController.getAllDescentdantEntities(testSuiteFolder);
        for (Object entity : entities) {
            if (entity instanceof TestSuiteEntity) {
                ++testSuiteCount;
                testCaseInTestSuiteCount += ((TestSuiteEntity)entity).getTestSuiteTestCaseLinks().size();
                continue;
            }
            if (!(entity instanceof TestSuiteCollectionEntity)) continue;
            ++testSuiteCollectionCount;
        }
        this.statistics.setTestSuiteCount(testSuiteCount);
        this.statistics.setTestCaseInTestSuiteCount(testCaseInTestSuiteCount);
        this.statistics.setTestSuiteCollectionCount(testSuiteCollectionCount);
    }

    private void countTestData() throws Exception {
        int csvDataFileCount = 0;
        int excelDataFileCount = 0;
        int databaseDataFileCount = 0;
        int internalDataFileCount = 0;
        FolderEntity testDataRootFolder = this.folderController.getTestDataRoot(this.project);
        List entities = this.folderController.getAllDescentdantEntities(testDataRootFolder);
        for (Object entity : entities) {
            if (!(entity instanceof DataFileEntity)) continue;
            DataFileEntity dataFileEntity = (DataFileEntity)entity;
            switch (dataFileEntity.getDriver()) {
                case CSV: {
                    ++csvDataFileCount;
                    break;
                }
                case ExcelFile: {
                    ++excelDataFileCount;
                    break;
                }
                case DBData: {
                    ++databaseDataFileCount;
                    break;
                }
                case InternalData: {
                    ++internalDataFileCount;
                    break;
                }
            }
        }
        this.statistics.setCsvDataFileCount(csvDataFileCount);
        this.statistics.setExcelDataFileCount(excelDataFileCount);
        this.statistics.setDatabaseDataFileCount(databaseDataFileCount);
        this.statistics.setInternalDataFileCount(internalDataFileCount);
    }

    private void countCheckpoints() throws Exception {
        String checkpointFolderPath = this.folderController.getCheckpointRoot(this.project).getLocation();
        File checkpointFolder = new File(checkpointFolderPath);
        File[] checkpointFiles = this.listFiles(checkpointFolder, CheckpointEntity.getCheckpointFileExtension());
        int checkpointCount = checkpointFiles.length;
        this.statistics.setCheckpointCount(checkpointCount);
    }

    private void countCustomKeywords() throws Exception {
        String keywordFolderPath = this.folderController.getKeywordRoot(this.project).getLocation();
        File keywordFolder = new File(keywordFolderPath);
        File[] keywordFiles = this.listFiles(keywordFolder, GROOVY_FILE_EXTENSION);
        int customKeywordCount = keywordFiles.length;
        this.statistics.setCustomKeywordCount(customKeywordCount);
    }

    private void countTestListeners() throws Exception {
        String testListenerFolderPath = this.folderController.getTestListenerRoot(this.project).getLocation();
        File testListenerFolder = new File(testListenerFolderPath);
        File[] testListenerFiles = this.listFiles(testListenerFolder, ".groovy");
        int testListenerCount = testListenerFiles.length;
        this.statistics.setTestListenerCount(testListenerCount);
    }

    private void countReportsAndTestExecutions() throws Exception {
        String reportFolderPath = this.folderController.getReportRoot(this.project).getLocation();
        File reportFolder = new File(reportFolderPath);
        File[] junitReportFiles = this.listFiles(reportFolder, "JUnit_Report.xml");
        this.statistics.setReportCount(junitReportFiles.length);
        int testExecutionCount = 0;
        File[] fileArray = junitReportFiles;
        int n = junitReportFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File reportFile = fileArray[n2];
            String reportContent = FileUtils.readFileToString((File)reportFile);
            testExecutionCount += StringUtils.countMatches((CharSequence)reportContent, (CharSequence)"<testcase");
            ++n2;
        }
        this.statistics.setExecutionCount(testExecutionCount);
    }

    private void countProfiles() throws DALException {
        String profileFolderPath = this.folderController.getProfileRoot(this.project).getLocation();
        File profileFolder = new File(profileFolderPath);
        File[] profileFiles = this.listFiles(profileFolder, ExecutionProfileEntity.getGlobalVariableFileExtension());
        int profileCount = profileFiles.length;
        this.statistics.setProfileCount(profileCount);
    }

    private void countFeatureFiles() throws DALException {
        String featureFolderPath = this.folderController.getIncludeRoot(this.project).getLocation();
        File featureFolder = new File(featureFolderPath);
        File[] featureFiles = this.listFiles(featureFolder, ".feature");
        int featureFileCount = featureFiles.length;
        this.statistics.setFeatureFileCount(featureFileCount);
    }

    private void countGroovyScriptFiles() throws DALException {
        String scriptFolderPath = String.valueOf(this.folderController.getIncludeRoot(this.project).getLocation()) + File.separator + "scripts";
        File scriptFolder = new File(scriptFolderPath);
        File[] scriptFiles = this.listFiles(scriptFolder, GROOVY_FILE_EXTENSION);
        int scriptFileCount = scriptFiles.length;
        this.statistics.setGroovyScriptFileCount(scriptFileCount);
    }

    private boolean isGitIntegrated() {
        return GitToolbarExecutableStatus.getValue();
    }

    private boolean isJiraIntegrated() throws IOException {
        JiraIntegrationSettingStore jiraIntegrationSettingStore = new JiraIntegrationSettingStore(this.project.getFolderLocation());
        return jiraIntegrationSettingStore.isIntegrationEnabled();
    }

    private boolean isKobitonIntegrated() {
        return KobitonPreferencesProvider.isKobitonIntegrationEnabled();
    }

    private boolean isqTestIntegrated() {
        try {
            return new BundleSettingStore(this.project.getFolderLocation(), "com.kms.katalon.integration.qtest", false).getBoolean("enableIntegration", false);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    private boolean isSlackIntegrated() {
        return SlackUtil.getInstance().isSlackEnabled();
    }

    private String getWebLocatorConfig() throws IOException {
        WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
        String ret = store.getCapturedTestObjectSelectorMethod().toString();
        return ret;
    }

    private boolean isKatalonAnalyticsIntegrated() throws IOException {
        AnalyticsSettingStore store = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        return store.isIntegrationEnabled();
    }

    private boolean isRemoteWebDriverConfigured() throws IOException {
        RemoteWebDriverConnector driverConnector = new RemoteWebDriverConnector(String.valueOf(this.project.getFolderLocation()) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
        Map driverProperties = driverConnector.getUserConfigProperties();
        return !StringUtils.isBlank((CharSequence)driverConnector.getRemoteServerUrl()) || driverProperties != null && !driverProperties.isEmpty();
    }

    private String getDefaultTestCaseView() {
        ScopedPreferenceStore testCasePrefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.testcase");
        return testCasePrefStore.getString("default.startView");
    }

    private File[] listFiles(File folder, String extension) {
        try {
            return FileUtil.getFiles((File)folder, (String)extension, null);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return new File[0];
        }
    }

    private boolean isAutoApplyNeighborXpathsEnabled() {
        ExecutionDefaultSettingStore store = ExecutionDefaultSettingStore.getStore();
        return store.getAutoApplyNeighborXpathsEnabled();
    }
}

