/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.proposal.completion;

import com.kms.katalon.composer.codeassist.proposal.completion.KatalonFailureHandlingCompletionProposal;
import com.kms.katalon.composer.codeassist.util.KatalonContextUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class KatalonMethodCompletionProposal
extends ParameterGuessingProposal {
    private MethodNode methodNode;
    private JavaContentAssistInvocationContext javaContext;
    private ContentAssistContext assistContext;
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;

    public ContentAssistContext getAssistContext() {
        return this.assistContext;
    }

    public void setAssistContext(ContentAssistContext assistContext) {
        this.assistContext = assistContext;
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public void setMethodNode(MethodNode methodNode) {
        this.methodNode = methodNode;
    }

    public JavaContentAssistInvocationContext getJavaContext() {
        return this.javaContext;
    }

    public void setJavaContext(JavaContentAssistInvocationContext javaContext) {
        this.javaContext = javaContext;
    }

    public KatalonMethodCompletionProposal(GroovyCompletionProposal proposal, JavaContentAssistInvocationContext context, ContentAssistContext assistContext, boolean fillBestGuess, MethodNode methodNode) {
        super((CompletionProposal)proposal, context, context.getCoreContext(), false);
        this.setMethodNode(methodNode);
        this.setJavaContext(context);
        this.setAssistContext(assistContext);
    }

    public static KatalonMethodCompletionProposal createProposal(GroovyCompletionProposal proposal, JavaContentAssistInvocationContext javaContext, ContentAssistContext assistContext, boolean fillBestGuess, MethodNode methodNode) {
        CompletionContext coreContext = javaContext.getCoreContext();
        if (coreContext != null && coreContext.isExtended()) {
            return new KatalonMethodCompletionProposal(proposal, javaContext, assistContext, fillBestGuess, methodNode);
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public void apply(final IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            if (ArrayUtils.isNotEmpty((Object[])this.fPositions) && this.getTextViewer() != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < this.fPositions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    Position fPosition = this.fPositions[i];
                    int positionOffset = fPosition.getOffset();
                    int positionLength = fPosition.getLength();
                    if (this.fChoices[i].length < 2) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), fPosition);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                final char exitChar = replacement.charAt(replacement.length() - 1);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(exitChar, document){

                    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model2, VerifyEvent event, int offset2, int length) {
                        if (event.character == ',') {
                            int i = 0;
                            while (i < KatalonMethodCompletionProposal.this.fPositions.length - 1) {
                                Position position = KatalonMethodCompletionProposal.this.fPositions[i];
                                if (position.offset <= offset2 && offset2 + length <= position.offset + position.length) {
                                    try {
                                        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)(offset2 + length), (boolean)false);
                                        if ("__dftl_partition_content_type".equals(partition.getType()) || offset2 + length == partition.getOffset() + partition.getLength()) {
                                            event.character = (char)9;
                                            event.keyCode = 9;
                                            return null;
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {}
                                }
                                ++i;
                            }
                        } else if (event.character == ')' && exitChar != ')') {
                            Position position = KatalonMethodCompletionProposal.this.fPositions[KatalonMethodCompletionProposal.this.fPositions.length - 1];
                            if (position.offset <= offset2 && offset2 + length <= position.offset + position.length) {
                                return new LinkedModeUI.ExitFlags(2, false);
                            }
                        }
                        return super.doExit(model2, event, offset2, length);
                    }
                });
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
            }
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    KatalonMethodCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    protected String computeReplacementString() {
        try {
            return this.computeGuessingCompletion();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
    }

    private String computeGuessingCompletion() throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        this.setCursorPosition(buffer.length());
        if (prefs.afterOpeningParen) {
            buffer.append(" ");
        }
        char[][] parameterNames = this.fProposal.findParameterNames(null);
        this.fChoices = this.guessParameters(parameterNames);
        int count = this.fChoices.length;
        int replacementOffset = this.getReplacementOffset();
        int i = 0;
        while (i < count) {
            if (i != 0) {
                if (prefs.beforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (prefs.afterComma) {
                    buffer.append(" ");
                }
            }
            ICompletionProposal proposal = null;
            proposal = FailureHandling.class.getName().equals(this.getParameterTypes()[i]) ? this.getDefaultFailureHandlingProposal(this.fChoices[i]) : this.fChoices[i][0];
            String argument = proposal.getDisplayString();
            Position position = this.fPositions[i];
            position.setOffset(replacementOffset + buffer.length());
            position.setLength(argument.length());
            if (proposal instanceof JavaCompletionProposal) {
                ((JavaCompletionProposal)proposal).setReplacementOffset(replacementOffset + buffer.length());
            }
            buffer.append(argument);
            ++i;
        }
        if (prefs.beforeClosingParen) {
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private ICompletionProposal[][] guessParameters(char[][] parameterNames) throws JavaModelException {
        int count = parameterNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        String[] parameterTypes = this.getParameterTypes();
        ParameterGuesser guesser = new ParameterGuesser(this.getJavaContext().getCoreContext().getEnclosingElement());
        IJavaElement[][] assignableElements = this.getAssignableElements();
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            Position position = new Position(0, 0);
            boolean isLastParameter = i == count - 1;
            ICompletionProposal[] argumentProposals = null;
            ICompletionProposal[] parentGuessingProposal = guesser.parameterProposals(parameterTypes[i], paramName, position, assignableElements[i], true, isLastParameter);
            if (FailureHandling.class.getName().equals(parameterTypes[i])) {
                argumentProposals = this.getFailureHandlingProposals(parentGuessingProposal, position);
            } else {
                argumentProposals = parentGuessingProposal;
                if (argumentProposals.length == 0) {
                    JavaCompletionProposal proposal = new JavaCompletionProposal(paramName, 0, paramName.length(), null, paramName, 0);
                    if (isLastParameter) {
                        proposal.setTriggerCharacters(new char[]{','});
                    }
                    argumentProposals = new ICompletionProposal[]{proposal};
                }
            }
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            --i;
        }
        return this.fChoices;
    }

    private ICompletionProposal[] getFailureHandlingProposals(ICompletionProposal[] parentGuessingProposal, Position position) {
        ArrayList<KatalonFailureHandlingCompletionProposal> argumentProposals = new ArrayList<KatalonFailureHandlingCompletionProposal>();
        ArrayList<String> stringContains = new ArrayList<String>();
        Object[] falureHandlingValues = FailureHandling.valueStrings();
        Arrays.sort(falureHandlingValues);
        int index = 0;
        while (index < parentGuessingProposal.length) {
            PositionBasedCompletionProposal guessingProposal = (PositionBasedCompletionProposal)parentGuessingProposal[index];
            String newReplecementString = "";
            newReplecementString = Arrays.binarySearch(falureHandlingValues, guessingProposal.getDisplayString()) > -1 ? String.valueOf(FailureHandling.class.getSimpleName()) + "." + guessingProposal.getDisplayString() : guessingProposal.getDisplayString();
            KatalonFailureHandlingCompletionProposal failureHandlingProposal = new KatalonFailureHandlingCompletionProposal(newReplecementString, position, newReplecementString.length(), guessingProposal.getImage(), newReplecementString, guessingProposal.getContextInformation(), guessingProposal.getAdditionalProposalInfo(), guessingProposal.getTriggerCharacters());
            if (!stringContains.contains(newReplecementString)) {
                stringContains.add(newReplecementString);
                argumentProposals.add(failureHandlingProposal);
            }
            ++index;
        }
        return argumentProposals.toArray(new ICompletionProposal[0]);
    }

    private ICompletionProposal getDefaultFailureHandlingProposal(ICompletionProposal[] guessingCompletionProposals) {
        FailureHandling defaultFailureHandling = new TestCaseSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation()).getDefaultFailureHandling();
        if (defaultFailureHandling == null) {
            return guessingCompletionProposals[0];
        }
        String defaultFailureHandlingName = String.valueOf(defaultFailureHandling.getDeclaringClass().getSimpleName()) + "." + defaultFailureHandling.name();
        ICompletionProposal[] iCompletionProposalArray = guessingCompletionProposals;
        int n = guessingCompletionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal suggesingProposal = iCompletionProposalArray[n2];
            if (defaultFailureHandlingName.equals(suggesingProposal.getDisplayString())) {
                return suggesingProposal;
            }
            ++n2;
        }
        return guessingCompletionProposals[0];
    }

    private String[] getParameterTypes() {
        char[] signature = SignatureUtil.fix83600((char[])this.fProposal.getSignature());
        char[][] types = Signature.getParameterTypes((char[])signature);
        String[] ret = new String[types.length];
        int i = 0;
        while (i < types.length) {
            ret[i] = new String(Signature.toCharArray((char[])types[i]));
            ++i;
        }
        return ret;
    }

    private IJavaElement[][] getAssignableElements() {
        char[] signature = SignatureUtil.fix83600((char[])this.getProposal().getSignature());
        char[][] types = Signature.getParameterTypes((char[])signature);
        IJavaElement[][] assignableElements = new IJavaElement[types.length][];
        int i = 0;
        while (i < types.length) {
            assignableElements[i] = this.getJavaContext().getCoreContext().getVisibleElements(new String(types[i]));
            ++i;
        }
        return assignableElements;
    }

    protected void appendMethodNameReplacement(StringBuffer buffer) {
        super.appendMethodNameReplacement(buffer);
        if (this.isCustomKeywordMethodNode()) {
            buffer.insert(0, "'");
            buffer.insert(buffer.toString().lastIndexOf("("), "'");
        }
    }

    private boolean isCustomKeywordMethodNode() {
        return "CustomKeywords".equals(this.methodNode.getDeclaringClass().getName());
    }

    protected StyledString computeDisplayString() {
        return super.computeDisplayString().append(this.getStyledGroovy());
    }

    private StyledString getStyledGroovy() {
        try {
            String className = this.methodNode.getDeclaringClass().getName();
            String methodName = this.methodNode.getName();
            if ("CustomKeywords".equals(className) || KeywordController.getInstance().getBuiltInKeywordByName(className, methodName) != null) {
                return KatalonContextUtil.getKatalonSignature();
            }
        }
        catch (Exception exception) {}
        return new StyledString("");
    }

    private String getCategory() {
        return "KatalonMethodCompletionProposal_" + this.toString();
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fUpdater);
        }
    }
}

