/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.proposal.completion;

import com.kms.katalon.composer.codeassist.constant.ImageConstants;
import com.kms.katalon.composer.codeassist.util.KatalonContextUtil;
import com.kms.katalon.custom.keyword.KeywordClass;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyJavaFieldCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class KatalonBuiltInKeywordCompletionProposal
extends GroovyCompletionProposal {
    private final KeywordClass keywordClass;
    private JavaContentAssistInvocationContext javaContext;

    public KatalonBuiltInKeywordCompletionProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, KeywordClass keywordClass) {
        super(9, context.completionLocation);
        this.keywordClass = keywordClass;
        this.javaContext = javaContext;
        this.setRelevance(Relevance.HIGH.getRelavance());
        String aliasName = keywordClass.getAliasName();
        if (context.location == ContentAssistLocation.IMPORT) {
            aliasName = String.valueOf(keywordClass.getName()) + " as " + keywordClass.getAliasName();
        }
        this.setName(aliasName.toCharArray());
        this.setCompletion(aliasName.toCharArray());
        int completionLength = context.completionExpression.length();
        this.setReplaceRange(context.completionLocation - completionLength, context.completionLocation + aliasName.length() - completionLength);
        ClassNode classNode = new ClassNode(keywordClass.getType());
        char[] classSignature = ProposalUtils.createTypeSignature((ClassNode)classNode);
        this.setTypeName(classSignature);
        this.setSignature(classSignature);
    }

    public KeywordClass getKeywordClass() {
        return this.keywordClass;
    }

    public IJavaCompletionProposal getCompletionProposal() {
        return new LocalKeywordCompletionProposal(this);
    }

    private class LocalKeywordCompletionProposal
    extends GroovyJavaFieldCompletionProposal {
        public LocalKeywordCompletionProposal(KatalonBuiltInKeywordCompletionProposal proposal) {
            super((CompletionProposal)proposal, ImageConstants.IMG_16_BRANDING, null);
        }

        protected ProposalInfo getProposalInfo() {
            return new TypeProposalInfo(KatalonBuiltInKeywordCompletionProposal.this.javaContext.getProject(), this.getProposal());
        }

        public StyledString getStyledDisplayString() {
            return new StyledString(KatalonBuiltInKeywordCompletionProposal.this.keywordClass.getAliasName()).append(KatalonContextUtil.getClassSignature(KatalonBuiltInKeywordCompletionProposal.this.keywordClass)).append(KatalonContextUtil.getKatalonSignature());
        }
    }
}

