/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.processor;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.util.ArrayList;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.quickfix.templates.GroovyContext;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class KatalonTemplateProcessor
extends TemplateCompletionProcessor {
    private ContributionTemplateStore templateStore;
    private JavaContentAssistInvocationContext javaContext;
    private ContributionContextTypeRegistry registry;
    private ContentAssistContext assistContext;

    public KatalonTemplateProcessor(JavaContentAssistInvocationContext javaContext, ContentAssistContext assistContext, ContributionTemplateStore templateStore, ContributionContextTypeRegistry registry) {
        this.assistContext = assistContext;
        this.javaContext = javaContext;
        this.templateStore = templateStore;
        this.registry = registry;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return this.templateStore.getTemplates(contextTypeId);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.registry.getContextType("groovy");
    }

    protected Image getImage(Template template) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (this.javaContext == null) {
                return new ICompletionProposal[0];
            }
            if (this.assistContext.location != ContentAssistLocation.SCRIPT && this.assistContext.location != ContentAssistLocation.STATEMENT) {
                return new ICompletionProposal[0];
            }
            Region region = new Region(this.javaContext.getInvocationOffset(), 0);
            IDocument document = this.javaContext.getDocument();
            GroovyContext templateContext = new GroovyContext(this.getContextType(viewer, (IRegion)region), document, this.javaContext.getInvocationOffset(), 0, this.javaContext.getCompilationUnit());
            String prefix = String.valueOf(this.javaContext.computeIdentifierPrefix());
            templateContext.setForceEvaluation(true);
            templateContext.setVariable("selection", document.get(region.getOffset(), region.getLength()));
            ArrayList<TemplateProposal> proposals = new ArrayList<TemplateProposal>();
            Template[] templateArray = this.getTemplates("groovy");
            int n = templateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Template template = templateArray[n2];
                Template newTemplate = this.clone(template);
                if (template.getName().startsWith(prefix)) {
                    TemplateProposal templateProposal = new TemplateProposal(newTemplate, (TemplateContext)templateContext, (IRegion)region, null);
                    templateProposal.setRelevance(Relevance.VERY_HIGH.getRelavance());
                    proposals.add(templateProposal);
                }
                ++n2;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        catch (BadLocationException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private Template clone(Template template) {
        Template newTemplate = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), template.getPattern(), true);
        return newTemplate;
    }
}

