/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.editor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryField;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryMethod;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryType;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceField;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceMethod;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceType;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectRequestor;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyProjectFacade;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.util.Util;

public class CustomCodeSelectRequestor
extends CodeSelectRequestor {
    private final ASTNode nodeToLookFor;
    private IJavaElement requestedElement;
    private ASTNode requestedNode;
    private final GroovyProjectFacade project;
    private final GroovyCompilationUnit unit;

    public CustomCodeSelectRequestor(ASTNode nodeToLookFor, GroovyCompilationUnit unit) {
        super(nodeToLookFor, unit);
        this.nodeToLookFor = nodeToLookFor;
        this.unit = unit;
        this.project = new GroovyProjectFacade((IJavaElement)unit);
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!this.interestingElement(enclosingElement)) {
            return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
        }
        if (node instanceof ImportNode && (node = ((ImportNode)node).getType()) == null) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (this.doTest(node)) {
            this.requestedNode = result.declaration;
            if (this.requestedNode instanceof ClassNode) {
                this.requestedNode = ((ClassNode)this.requestedNode).redirect();
            }
            if (this.requestedNode != null) {
                if (result.declaration instanceof VariableExpression) {
                    VariableExpression var = (VariableExpression)result.declaration;
                    this.requestedElement = this.createLocalVariable(result, enclosingElement, (Variable)var);
                } else if (result.declaration instanceof Parameter) {
                    Parameter var = (Parameter)result.declaration;
                    int position = var.getStart() - 1;
                    if (position < 0) {
                        position = this.nodeToLookFor.getStart() - 1;
                    }
                    try {
                        this.requestedElement = this.createLocalVariable(result, (IJavaElement)((JavaElement)this.unit.getElementAt(position)), (Variable)var);
                    }
                    catch (JavaModelException e) {
                        Util.log((Throwable)e, (String)("Problem getting element at " + position + " for file " + this.unit.getElementName()));
                    }
                } else {
                    ClassNode declaringType = this.findDeclaringType(result);
                    if (declaringType != null) {
                        IType type;
                        ClassNode effectiveDeclaringType = declaringType;
                        if (declaringType.getEnclosingMethod() != null) {
                            effectiveDeclaringType = declaringType.getEnclosingMethod().getDeclaringClass();
                        }
                        if ((type = this.project.groovyClassToJavaType(declaringType)) == null && !this.unit.isOnBuildPath() && !(type = this.unit.getType(effectiveDeclaringType.getNameWithoutPackage())).exists()) {
                            type = null;
                        }
                        if (type != null) {
                            try {
                                IJavaElement maybeRequested = this.findRequestedElement(result, type);
                                this.requestedElement = this.resolveRequestedElement(result, maybeRequested);
                            }
                            catch (JavaModelException e) {
                                GroovyCore.logException((String)("Problem with code selection for ASTNode: " + node), (Throwable)e);
                            }
                        }
                    }
                }
            }
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean interestingElement(IJavaElement enclosingElement) {
        if (enclosingElement.getElementName().equals("<clinit>")) {
            return true;
        }
        if (enclosingElement instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
                return range.getOffset() <= this.nodeToLookFor.getStart() && range.getOffset() + range.getLength() >= this.nodeToLookFor.getEnd();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return false;
    }

    private ClassNode findDeclaringType(TypeLookupResult result) {
        ClassNode declaringType = null;
        if (result.declaringType != null) {
            declaringType = this.removeArray(result.declaringType);
        } else if (result.declaration instanceof FieldNode) {
            declaringType = ((FieldNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof MethodNode) {
            declaringType = ((MethodNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof PropertyNode) {
            declaringType = ((PropertyNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof ClassNode) {
            declaringType = this.removeArray((ClassNode)result.declaration);
        }
        return declaringType;
    }

    private IJavaElement findRequestedElement(TypeLookupResult result, IType type) throws JavaModelException {
        IType maybeRequested = null;
        ASTNode declaration = result.declaration;
        if (declaration instanceof ClassNode) {
            maybeRequested = type;
        } else if (type.getTypeRoot() != null) {
            if (declaration.getEnd() > 0) {
                String name;
                IJavaElement[] children = type.getChildren();
                int start = declaration.getStart();
                int end = declaration.getEnd();
                if (declaration instanceof MethodNode) {
                    name = ((MethodNode)declaration).getName();
                    if (name.equals("<init>")) {
                        name = type.getElementName();
                    }
                } else {
                    name = declaration instanceof FieldNode ? ((FieldNode)declaration).getName() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getName() : declaration.getText());
                }
                IJavaElement[] iJavaElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    ISourceRange range = ((ISourceReference)child).getSourceRange();
                    if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && child.getElementName().equals(name)) {
                        maybeRequested = child;
                        break;
                    }
                    if (start + end < range.getOffset()) break;
                    ++n2;
                }
            }
            if (maybeRequested == null) {
                String name = null;
                Parameter[] parameters = null;
                if (declaration instanceof MethodNode) {
                    name = ((MethodNode)declaration).getName();
                    parameters = ((MethodNode)declaration).getParameters();
                } else if (declaration instanceof PropertyNode) {
                    name = ((PropertyNode)declaration).getName();
                } else if (declaration instanceof FieldNode) {
                    name = ((FieldNode)declaration).getName();
                }
                if (name != null) {
                    maybeRequested = this.findElement(type, name, parameters);
                }
                if (maybeRequested == null) {
                    maybeRequested = type;
                }
            }
        }
        return maybeRequested;
    }

    private IJavaElement resolveRequestedElement(TypeLookupResult result, IJavaElement maybeRequested) {
        IJavaElement candidate;
        AnnotatedNode declaration = (AnnotatedNode)result.declaration;
        if (declaration instanceof PropertyNode && maybeRequested instanceof IMethod) {
            String getterName = maybeRequested.getElementName();
            MethodNode maybeDeclaration = (MethodNode)declaration.getDeclaringClass().getMethods(getterName).get(0);
            Object object = declaration = maybeDeclaration == null ? declaration : maybeDeclaration;
        }
        if (declaration instanceof ConstructorNode && maybeRequested.getElementType() == 7) {
            declaration = declaration.getDeclaringClass();
        }
        String uniqueKey = this.createUniqueKey(declaration, result.type, result.declaringType, maybeRequested);
        switch (maybeRequested.getElementType()) {
            case 8: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryField((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, result.declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceField((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, result.declaration);
                break;
            }
            case 9: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryMethod((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), ((IMethod)maybeRequested).getParameterTypes(), uniqueKey, result.extraDoc, result.declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceMethod((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), ((IMethod)maybeRequested).getParameterTypes(), uniqueKey, result.extraDoc, result.declaration);
                break;
            }
            case 7: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryType((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, result.declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceType((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, result.declaration);
                break;
            }
            default: {
                candidate = maybeRequested;
            }
        }
        this.requestedElement = candidate;
        return this.requestedElement;
    }

    private LocalVariable createLocalVariable(TypeLookupResult result, IJavaElement enclosingElement, Variable var) {
        ASTNode node = (ASTNode)var;
        ClassNode type = result.type != null ? result.type : var.getType();
        int start = node instanceof Parameter ? ((Parameter)node).getNameStart() : node.getStart();
        return ReflectionUtils.createLocalVariable((IJavaElement)enclosingElement, (String)var.getName(), (int)start, (String)Signature.createTypeSignature((String)this.createGenericsAwareName(type, true), (boolean)false));
    }

    private String createGenericsAwareName(ClassNode node, boolean useSimple) {
        StringBuilder sbArr;
        StringBuilder sb = new StringBuilder();
        String name = node.getName();
        if (name.charAt(0) == '[') {
            sbArr = new StringBuilder();
            int arrayCount = 0;
            while (name.charAt(arrayCount) == '[') {
                sbArr.append("[]");
                node = node.getComponentType();
                ++arrayCount;
            }
        } else {
            sbArr = null;
        }
        if (useSimple) {
            sb.append(node.getNameWithoutPackage());
        } else {
            sb.append(node.getName());
        }
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (genericsTypes != null && genericsTypes.length > 0) {
            sb.append('<');
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                ClassNode genericsType = gt.getType();
                if (genericsType == null || !genericsType.getName().equals(gt.getName())) {
                    sb.append(useSimple ? genericsType.getNameWithoutPackage() : genericsType.getName());
                } else {
                    sb.append(this.createGenericsAwareName(genericsType, useSimple));
                }
                sb.append(',');
                ++n2;
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        if (sbArr != null) {
            sb.append((CharSequence)sbArr);
        }
        return sb.toString();
    }

    private String createUniqueKey(AnnotatedNode node, ClassNode resolvedType, ClassNode resolvedDeclaringType, IJavaElement maybeRequested) {
        if (resolvedDeclaringType == null && (resolvedDeclaringType = node.getDeclaringClass()) == null) {
            resolvedDeclaringType = VariableScope.OBJECT_CLASS_NODE;
        }
        StringBuilder sb = new StringBuilder();
        if (node instanceof PropertyNode) {
            node = ((PropertyNode)node).getField();
        }
        if (node instanceof FieldNode) {
            return this.createUniqueKeyForField((FieldNode)node, resolvedType, resolvedDeclaringType).toString();
        }
        if (node instanceof MethodNode) {
            if (maybeRequested.getElementType() == 8) {
                return this.createUniqueKeyForGeneratedAccessor((MethodNode)node, resolvedType, resolvedDeclaringType, (IField)maybeRequested).toString();
            }
            return this.createUniqueKeyForMethod((MethodNode)node, resolvedType, resolvedDeclaringType).toString();
        }
        if (node instanceof ClassNode) {
            return this.createUniqueKeyForClass(resolvedType, resolvedDeclaringType).toString();
        }
        return sb.toString();
    }

    private StringBuilder createUniqueKeyForMethod(MethodNode node, ClassNode resolvedType, ClassNode resolvedDeclaringType) {
        StringBuilder sb = new StringBuilder();
        ClassNode declaringClass = node.getDeclaringClass();
        sb.append((CharSequence)this.createUniqueKeyForClass(declaringClass, resolvedDeclaringType));
        String name = node.getName();
        sb.append('.').append(name.equals("<init>") ? declaringClass.getNameWithoutPackage() : name);
        sb.append('(');
        if (node.getParameters() != null) {
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                ClassNode paramType = param.getType() != null ? param.getType() : VariableScope.OBJECT_CLASS_NODE;
                sb.append((CharSequence)this.createUniqueKeyForClass(paramType, resolvedDeclaringType));
                ++n2;
            }
        }
        sb.append(')');
        sb.append((CharSequence)this.createUniqueKeyForResolvedClass(resolvedType));
        return sb;
    }

    private StringBuilder createUniqueKeyForField(FieldNode node, ClassNode resolvedType, ClassNode resolvedDeclaringType) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createUniqueKeyForClass(node.getDeclaringClass(), resolvedDeclaringType));
        sb.append('.').append(node.getName()).append(')');
        sb.append((CharSequence)this.createUniqueKeyForResolvedClass(resolvedType));
        return sb;
    }

    private StringBuilder createUniqueKeyForGeneratedAccessor(MethodNode node, ClassNode resolvedType, ClassNode resolvedDeclaringType, IField actualField) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createUniqueKeyForClass(node.getDeclaringClass(), resolvedDeclaringType));
        sb.append('.').append(actualField.getElementName()).append(')');
        ClassNode typeOfField = node.getName().startsWith("set") && node.getParameters() != null && node.getParameters().length > 0 ? node.getParameters()[0].getType() : resolvedType;
        sb.append((CharSequence)this.createUniqueKeyForResolvedClass(typeOfField));
        return sb;
    }

    private StringBuilder createUniqueKeyForResolvedClass(ClassNode resolvedType) {
        if (resolvedType.getName().equals("java.lang.Void")) {
            resolvedType = VariableScope.VOID_CLASS_NODE;
        }
        return new StringBuilder(Signature.createTypeSignature((String)this.createGenericsAwareName(resolvedType, false), (boolean)true).replace('.', '/'));
    }

    private StringBuilder createUniqueKeyForClass(ClassNode unresolvedType, ClassNode resolvedDeclaringType) {
        GenericsMapper mapper = GenericsMapper.gatherGenerics((ClassNode)resolvedDeclaringType, (ClassNode)resolvedDeclaringType.redirect());
        ClassNode resolvedType = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (ClassNode)VariableScope.clone((ClassNode)unresolvedType));
        return this.createUniqueKeyForResolvedClass(resolvedType);
    }

    private boolean doTest(ASTNode node) {
        return node.getClass() == this.nodeToLookFor.getClass() && this.nodeToLookFor.getStart() == node.getStart() && this.nodeToLookFor.getEnd() == node.getEnd();
    }

    private ClassNode removeArray(ClassNode declaration) {
        return declaration.getComponentType() != null ? this.removeArray(declaration.getComponentType()) : declaration;
    }

    private IJavaElement findElement(IType type, String text, Parameter[] parameters) throws JavaModelException {
        String prefix;
        if (text.equals(type.getElementName())) {
            return type;
        }
        if (text.equals("<init>")) {
            text = type.getElementName();
        }
        String setMethod = AccessorSupport.SETTER.createAccessorName(text);
        String getMethod = AccessorSupport.GETTER.createAccessorName(text);
        String isMethod = AccessorSupport.ISSER.createAccessorName(text);
        IMethod closestMatch = null;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(text)) {
                closestMatch = method;
                String[] maybeMethodParameters = method.getParameterTypes();
                if (maybeMethodParameters.length == parameters.length && this.isCorrectMethod(type.isBinary(), parameters, maybeMethodParameters)) {
                    return method;
                }
            }
            ++n2;
        }
        if (closestMatch != null) {
            return closestMatch;
        }
        IField field = type.getField(text);
        if (!field.exists() && (prefix = this.extractPrefix(text)) != null) {
            String newName = String.valueOf(Character.toLowerCase(text.charAt(prefix.length()))) + text.substring(prefix.length() + 1);
            field = type.getField(newName);
        }
        if (field.exists()) {
            return field;
        }
        IMethod[] iMethodArray2 = type.getMethods();
        int n3 = iMethodArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IMethod method = iMethodArray2[n4];
            if (method.getElementName().equals(setMethod) || method.getElementName().equals(getMethod) || method.getElementName().equals(isMethod)) {
                return method;
            }
            ++n4;
        }
        return null;
    }

    private boolean isCorrectMethod(boolean isBinaryType, Parameter[] parameters, String[] maybeMethodParameters) {
        int i = 0;
        while (i < maybeMethodParameters.length) {
            String originalMethodFullSignature;
            String maybeMethodParameterSignature = this.removeGenerics(maybeMethodParameters[i]);
            ClassNode parameterType = parameters[i].getType();
            String nameWithoutPackage = parameterType.getNameWithoutPackage();
            String originalMethodSignature = parameterType.isArray() ? nameWithoutPackage : Signature.createTypeSignature((String)nameWithoutPackage, (boolean)isBinaryType);
            String name = parameterType.getName();
            String string = originalMethodFullSignature = parameterType.isArray() ? name : Signature.createTypeSignature((String)name, (boolean)isBinaryType);
            if (!originalMethodSignature.equals(maybeMethodParameterSignature) && !originalMethodFullSignature.equals(maybeMethodParameterSignature)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String removeGenerics(String maybeMethodParameterName) {
        int genericStart = maybeMethodParameterName.indexOf("<");
        if (genericStart > 0) {
            maybeMethodParameterName = String.valueOf(maybeMethodParameterName.substring(0, genericStart)) + maybeMethodParameterName.substring(maybeMethodParameterName.indexOf(">") + 1, maybeMethodParameterName.length());
        }
        return maybeMethodParameterName;
    }

    private String extractPrefix(String text) {
        if (text.startsWith("is")) {
            if (text.length() > 2) {
                return "is";
            }
        } else if (text.startsWith("get")) {
            if (text.length() > 3) {
                return "get";
            }
        } else if (text.startsWith("set") && text.length() > 3) {
            return "set";
        }
        return null;
    }

    public ASTNode getRequestedNode() {
        return this.requestedNode;
    }

    public IJavaElement getRequestedElement() {
        return this.requestedElement;
    }
}

