/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.ITestObjectFactory;
import org.testng.TestNG;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlMethodSelectors;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;

public class XmlSuite
implements Serializable,
Cloneable {
    private String m_test;
    private static final String DEFAULT_SUITE_NAME = "Default Suite";
    private String m_name = "Default Suite";
    public static final Integer DEFAULT_VERBOSE = 1;
    private Integer m_verbose = null;
    public static final ParallelMode DEFAULT_PARALLEL = ParallelMode.NONE;
    private ParallelMode m_parallel = DEFAULT_PARALLEL;
    private String m_parentModule = "";
    private String m_guiceStage = "";
    public static final FailurePolicy DEFAULT_CONFIG_FAILURE_POLICY = FailurePolicy.SKIP;
    private FailurePolicy m_configFailurePolicy = DEFAULT_CONFIG_FAILURE_POLICY;
    public static final Boolean DEFAULT_JUNIT = Boolean.FALSE;
    private Boolean m_isJUnit = DEFAULT_JUNIT;
    public static final Boolean DEFAULT_MIXED = Boolean.FALSE;
    private Boolean m_isMixed = DEFAULT_MIXED;
    public static final Boolean DEFAULT_SKIP_FAILED_INVOCATION_COUNTS = Boolean.FALSE;
    private Boolean m_skipFailedInvocationCounts = DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    public static final Integer DEFAULT_THREAD_COUNT = 5;
    private int m_threadCount = DEFAULT_THREAD_COUNT;
    public static final Integer DEFAULT_DATA_PROVIDER_THREAD_COUNT = 10;
    private int m_dataProviderThreadCount = DEFAULT_DATA_PROVIDER_THREAD_COUNT;
    public static final Boolean DEFAULT_GROUP_BY_INSTANCES = false;
    private Boolean m_groupByInstances = DEFAULT_GROUP_BY_INSTANCES;
    public static final Boolean DEFAULT_ALLOW_RETURN_VALUES = Boolean.FALSE;
    private Boolean m_allowReturnValues = DEFAULT_ALLOW_RETURN_VALUES;
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_expression = null;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlTest> m_tests = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_fileName;
    private String m_timeOut;
    private List<XmlSuite> m_childSuites = Lists.newArrayList();
    private XmlSuite m_parentSuite;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private ITestObjectFactory m_objectFactory;
    private List<String> m_listeners = Lists.newArrayList();
    private static final long serialVersionUID = 4999962288272750226L;
    public static final Boolean DEFAULT_PRESERVE_ORDER = Boolean.TRUE;
    private Boolean m_preserveOrder = DEFAULT_PRESERVE_ORDER;
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();
    private XmlMethodSelectors m_xmlMethodSelectors;
    private XmlGroups m_xmlGroups;

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
    }

    public ParallelMode getParallel() {
        return this.m_parallel;
    }

    public String getParentModule() {
        return this.m_parentModule;
    }

    public String getGuiceStage() {
        return this.m_guiceStage;
    }

    public ITestObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    public void setObjectFactory(ITestObjectFactory iTestObjectFactory) {
        this.m_objectFactory = iTestObjectFactory;
    }

    @Deprecated
    public void setParallel(String string) {
        if (string == null) {
            this.setParallel((ParallelMode)null);
        } else {
            this.setParallel(ParallelMode.getValidParallel(string));
        }
    }

    public void setParallel(ParallelMode parallelMode) {
        this.m_parallel = parallelMode == null ? DEFAULT_PARALLEL : ParallelMode.skipDeprecatedValues(parallelMode);
    }

    public void setParentModule(String string) {
        this.m_parentModule = string;
    }

    public void setGuiceStage(String string) {
        this.m_guiceStage = string;
    }

    public void setConfigFailurePolicy(FailurePolicy failurePolicy) {
        this.m_configFailurePolicy = failurePolicy;
    }

    public FailurePolicy getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    public Integer getVerbose() {
        return this.m_verbose != null ? this.m_verbose : TestNG.DEFAULT_VERBOSE;
    }

    public void setVerbose(Integer n) {
        this.m_verbose = n;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public void setTests(List<XmlTest> list) {
        this.m_tests = list;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        if (this.m_xmlMethodSelectors != null) {
            return this.m_xmlMethodSelectors.getMethodSelectors();
        }
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> list) {
        this.m_methodSelectors = Lists.newArrayList(list);
    }

    private void updateParameters() {
        if (this.m_parentSuite != null) {
            Set<String> set = this.m_parentSuite.getParameters().keySet();
            for (String string : set) {
                if (this.m_parameters.containsKey(string)) continue;
                this.m_parameters.put(string, this.m_parentSuite.getParameter(string));
            }
        }
    }

    public void setParameters(Map<String, String> map) {
        this.m_parameters = map;
        this.updateParameters();
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> map = Maps.newHashMap();
        for (Map.Entry<String, String> object : this.m_parameters.entrySet()) {
            map.put(object.getKey(), object.getValue());
        }
        for (XmlTest xmlTest : this.getTests()) {
            Map<String, String> map2 = xmlTest.getLocalParameters();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public String getParameter(String string) {
        return this.m_parameters.get(string);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int n) {
        this.m_threadCount = n;
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean bl) {
        this.m_isJUnit = bl;
    }

    public void setJunit(Boolean bl) {
        this.setJUnit(bl);
    }

    public Boolean skipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean bl) {
        this.m_skipFailedInvocationCounts = bl;
    }

    public void setXmlPackages(List<XmlPackage> list) {
        this.m_xmlPackages = Lists.newArrayList(list);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    @Tag(name="method-selectors")
    public void setMethodSelectors(XmlMethodSelectors xmlMethodSelectors) {
        this.m_xmlMethodSelectors = xmlMethodSelectors;
    }

    public void setPackages(List<XmlPackage> list) {
        this.setXmlPackages(list);
    }

    public String toXml() {
        Iterator<XmlTest> iterator;
        Object object;
        ParallelMode parallelMode;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        xMLStringBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties properties = new Properties();
        properties.setProperty("name", this.getName());
        if (this.getVerbose() != null) {
            XmlUtils.setProperty(properties, "verbose", this.getVerbose().toString(), DEFAULT_VERBOSE.toString());
        }
        if ((parallelMode = this.getParallel()) != null && !DEFAULT_PARALLEL.equals((Object)parallelMode)) {
            properties.setProperty("parallel", parallelMode.toString());
        }
        XmlUtils.setProperty(properties, "group-by-instances", String.valueOf(this.getGroupByInstances()), DEFAULT_GROUP_BY_INSTANCES.toString());
        XmlUtils.setProperty(properties, "configfailurepolicy", this.getConfigFailurePolicy().toString(), DEFAULT_CONFIG_FAILURE_POLICY.toString());
        XmlUtils.setProperty(properties, "thread-count", String.valueOf(this.getThreadCount()), DEFAULT_THREAD_COUNT.toString());
        XmlUtils.setProperty(properties, "data-provider-thread-count", String.valueOf(this.getDataProviderThreadCount()), DEFAULT_DATA_PROVIDER_THREAD_COUNT.toString());
        if (!DEFAULT_JUNIT.equals(this.m_isJUnit)) {
            properties.setProperty("junit", this.m_isJUnit != null ? this.m_isJUnit.toString() : "false");
        }
        XmlUtils.setProperty(properties, "skipfailedinvocationcounts", this.m_skipFailedInvocationCounts.toString(), DEFAULT_SKIP_FAILED_INVOCATION_COUNTS.toString());
        if (null != this.m_objectFactory) {
            properties.setProperty("object-factory", this.m_objectFactory.getClass().getName());
        }
        if (Utils.isStringNotEmpty(this.m_parentModule)) {
            properties.setProperty("parent-module", this.getParentModule());
        }
        if (Utils.isStringNotEmpty(this.m_guiceStage)) {
            properties.setProperty("guice-stage", this.getGuiceStage());
        }
        XmlUtils.setProperty(properties, "allow-return-values", String.valueOf(this.getAllowReturnValues()), DEFAULT_ALLOW_RETURN_VALUES.toString());
        xMLStringBuffer.push("suite", properties);
        XmlUtils.dumpParameters(xMLStringBuffer, this.m_parameters);
        if (CollectionUtils.hasElements(this.m_listeners)) {
            xMLStringBuffer.push("listeners");
            for (String object22 : this.m_listeners) {
                object = new Properties();
                ((Properties)object).setProperty("class-name", object22);
                xMLStringBuffer.addEmptyElement("listener", (Properties)object);
            }
            xMLStringBuffer.pop("listeners");
        }
        if (CollectionUtils.hasElements(this.getXmlPackages())) {
            xMLStringBuffer.push("packages");
            for (XmlPackage xmlPackage : this.getXmlPackages()) {
                xMLStringBuffer.getStringBuffer().append(xmlPackage.toXml("    "));
            }
            xMLStringBuffer.pop("packages");
        }
        if (this.getXmlMethodSelectors() != null) {
            xMLStringBuffer.getStringBuffer().append(this.getXmlMethodSelectors().toXml("  "));
        } else if (CollectionUtils.hasElements(this.getMethodSelectors())) {
            xMLStringBuffer.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : this.getMethodSelectors()) {
                xMLStringBuffer.getStringBuffer().append(xmlMethodSelector.toXml("  "));
            }
            xMLStringBuffer.pop("method-selectors");
        }
        Iterator<XmlMethodSelector> iterator2 = this.getSuiteFiles();
        if (iterator2.size() > 0) {
            xMLStringBuffer.push("suite-files");
            Iterator iterator3 = iterator2.iterator();
            while (iterator3.hasNext()) {
                object = (String)iterator3.next();
                iterator = new Properties();
                ((Properties)((Object)iterator)).setProperty("path", (String)object);
                xMLStringBuffer.addEmptyElement("suite-file", (Properties)((Object)iterator));
            }
            xMLStringBuffer.pop("suite-files");
        }
        List<String> list = this.getIncludedGroups();
        object = this.getExcludedGroups();
        if (CollectionUtils.hasElements(list) || CollectionUtils.hasElements(object)) {
            xMLStringBuffer.push("groups");
            xMLStringBuffer.push("run");
            for (String string : list) {
                xMLStringBuffer.addEmptyElement("include", "name", string);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)((Object)iterator.next());
                xMLStringBuffer.addEmptyElement("exclude", "name", string);
            }
            xMLStringBuffer.pop("run");
            xMLStringBuffer.pop("groups");
        }
        if (this.m_xmlGroups != null) {
            xMLStringBuffer.getStringBuffer().append(this.m_xmlGroups.toXml("  "));
        }
        for (XmlTest xmlTest : this.getTests()) {
            xMLStringBuffer.getStringBuffer().append(xmlTest.toXml("  "));
        }
        xMLStringBuffer.pop("suite");
        return xMLStringBuffer.toXML();
    }

    @Tag(name="method-selectors")
    public void setXmlMethodSelectors(XmlMethodSelectors xmlMethodSelectors) {
        this.m_xmlMethodSelectors = xmlMethodSelectors;
    }

    private XmlMethodSelectors getXmlMethodSelectors() {
        return this.m_xmlMethodSelectors;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Suite: \"").append(this.m_name).append("\" ");
        for (XmlTest object : this.m_tests) {
            stringBuffer.append("  ").append(object.toString()).append(' ');
        }
        for (XmlMethodSelector xmlMethodSelector : this.m_methodSelectors) {
            stringBuffer.append(" methodSelector:" + xmlMethodSelector);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static void ppp(String string) {
        System.out.println("[XmlSuite] " + string);
    }

    public Object clone() {
        XmlSuite xmlSuite = this.shallowCopy();
        xmlSuite.setExcludedGroups(this.getExcludedGroups());
        xmlSuite.setIncludedGroups(this.getIncludedGroups());
        xmlSuite.setGroupByInstances(this.getGroupByInstances());
        xmlSuite.setGroups(this.getGroups());
        xmlSuite.setMethodSelectors(this.getXmlMethodSelectors());
        xmlSuite.setPackages(this.getPackages());
        xmlSuite.setParentSuite(this.getParentSuite());
        xmlSuite.setPreserveOrder(this.getPreserveOrder());
        xmlSuite.setSuiteFiles(this.getSuiteFiles());
        xmlSuite.setTests(this.getTests());
        xmlSuite.setXmlMethodSelectors(this.getXmlMethodSelectors());
        return xmlSuite;
    }

    public XmlSuite shallowCopy() {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setName(this.getName());
        xmlSuite.setFileName(this.getFileName());
        xmlSuite.setListeners(this.getListeners());
        xmlSuite.setParallel(this.getParallel());
        xmlSuite.setParentModule(this.getParentModule());
        xmlSuite.setGuiceStage(this.getGuiceStage());
        xmlSuite.setConfigFailurePolicy(this.getConfigFailurePolicy());
        xmlSuite.setThreadCount(this.getThreadCount());
        xmlSuite.setDataProviderThreadCount(this.getDataProviderThreadCount());
        xmlSuite.setParameters(this.getParameters());
        xmlSuite.setVerbose(this.getVerbose());
        xmlSuite.setXmlPackages(this.getXmlPackages());
        xmlSuite.setMethodSelectors(this.getMethodSelectors());
        xmlSuite.setJUnit(this.isJUnit());
        xmlSuite.setSkipFailedInvocationCounts(this.skipFailedInvocationCounts());
        xmlSuite.setObjectFactory(this.getObjectFactory());
        xmlSuite.setAllowReturnValues(this.getAllowReturnValues());
        xmlSuite.setTimeOut(this.getTimeOut());
        return xmlSuite;
    }

    public void setTimeOut(String string) {
        this.m_timeOut = string;
    }

    public String getTimeOut() {
        return this.m_timeOut;
    }

    public long getTimeOut(long l) {
        long l2 = l;
        if (this.m_timeOut != null) {
            l2 = Long.parseLong(this.m_timeOut);
        }
        return l2;
    }

    public void setSuiteFiles(List<String> list) {
        this.m_suiteFiles = list;
    }

    public List<String> getSuiteFiles() {
        return this.m_suiteFiles;
    }

    public void setListeners(List<String> list) {
        this.m_listeners = list;
    }

    public List<String> getListeners() {
        if (this.m_parentSuite != null) {
            List<String> list = this.m_parentSuite.getListeners();
            for (String string : list) {
                if (this.m_listeners.contains(string)) continue;
                this.m_listeners.add(string);
            }
        }
        return this.m_listeners;
    }

    public void setDataProviderThreadCount(int n) {
        this.m_dataProviderThreadCount = n;
    }

    public int getDataProviderThreadCount() {
        String string = System.getProperty("dataproviderthreadcount");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Parsing System property 'dataproviderthreadcount': " + numberFormatException);
            }
        }
        return this.m_dataProviderThreadCount;
    }

    public void setParentSuite(XmlSuite xmlSuite) {
        this.m_parentSuite = xmlSuite;
        this.updateParameters();
    }

    public XmlSuite getParentSuite() {
        return this.m_parentSuite;
    }

    public List<XmlSuite> getChildSuites() {
        return this.m_childSuites;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_configFailurePolicy == null ? 0 : this.m_configFailurePolicy.hashCode());
        n = 31 * n + this.m_dataProviderThreadCount;
        n = 31 * n + (this.m_expression == null ? 0 : this.m_expression.hashCode());
        n = 31 * n + (this.m_fileName == null ? 0 : this.m_fileName.hashCode());
        n = 31 * n + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        n = 31 * n + (this.m_listeners == null ? 0 : this.m_listeners.hashCode());
        n = 31 * n + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        n = 31 * n + (this.m_objectFactory == null ? 0 : this.m_objectFactory.hashCode());
        n = 31 * n + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        n = 31 * n + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        n = 31 * n + (this.m_suiteFiles == null ? 0 : this.m_suiteFiles.hashCode());
        n = 31 * n + (this.m_test == null ? 0 : this.m_test.hashCode());
        n = 31 * n + (this.m_tests == null ? 0 : this.m_tests.hashCode());
        n = 31 * n + this.m_threadCount;
        n = 31 * n + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        n = 31 * n + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        n = 31 * n + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return n;
    }

    static boolean f() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlSuite xmlSuite = (XmlSuite)object;
        if (this.m_configFailurePolicy == null ? xmlSuite.m_configFailurePolicy != null : !this.m_configFailurePolicy.equals((Object)xmlSuite.m_configFailurePolicy)) {
            return XmlSuite.f();
        }
        if (this.m_dataProviderThreadCount != xmlSuite.m_dataProviderThreadCount) {
            return XmlSuite.f();
        }
        if (this.m_expression == null ? xmlSuite.m_expression != null : !this.m_expression.equals(xmlSuite.m_expression)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? xmlSuite.m_isJUnit != null : !this.m_isJUnit.equals(xmlSuite.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_listeners == null ? xmlSuite.m_listeners != null : !this.m_listeners.equals(xmlSuite.m_listeners)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? xmlSuite.m_methodSelectors != null : !this.m_methodSelectors.equals(xmlSuite.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlSuite.m_name != null : !this.m_name.equals(xmlSuite.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_objectFactory == null ? xmlSuite.m_objectFactory != null : !this.m_objectFactory.equals(xmlSuite.m_objectFactory)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? xmlSuite.m_parallel != null : !this.m_parallel.equals((Object)xmlSuite.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? xmlSuite.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(xmlSuite.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_suiteFiles == null ? xmlSuite.m_suiteFiles != null : !this.m_suiteFiles.equals(xmlSuite.m_suiteFiles)) {
            return XmlSuite.f();
        }
        if (this.m_test == null ? xmlSuite.m_test != null : !this.m_test.equals(xmlSuite.m_test)) {
            return XmlSuite.f();
        }
        if (this.m_tests == null ? xmlSuite.m_tests != null : !this.m_tests.equals(xmlSuite.m_tests)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != xmlSuite.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? xmlSuite.m_timeOut != null : !this.m_timeOut.equals(xmlSuite.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? xmlSuite.m_verbose != null : !this.m_verbose.equals(xmlSuite.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? xmlSuite.m_xmlPackages != null : !this.m_xmlPackages.equals(xmlSuite.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    private boolean eq(String string, String string2, String string3) {
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        } else if (string != null) {
            bl = string.equals(string2) || string3.equals(string) && string2 == null;
        } else if (string2 != null) {
            bl = string2.equals(string) || string3.equals(string2) && string == null;
        }
        return bl;
    }

    @Deprecated
    public void setPreserveOrder(String string) {
        this.setPreserveOrder(Boolean.valueOf(string));
    }

    public void setPreserveOrder(Boolean bl) {
        this.m_preserveOrder = bl;
    }

    public Boolean getPreserveOrder() {
        return this.m_preserveOrder;
    }

    public List<String> getIncludedGroups() {
        if (this.m_parentSuite != null) {
            return this.m_parentSuite.getIncludedGroups();
        }
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            return this.m_xmlGroups.getRun().getIncludes();
        }
        return this.m_includedGroups;
    }

    public void addIncludedGroup(String string) {
        this.m_includedGroups.add(string);
    }

    public void setIncludedGroups(List<String> list) {
        this.m_includedGroups = list;
    }

    public void setExcludedGroups(List<String> list) {
        this.m_excludedGroups = list;
    }

    public List<String> getExcludedGroups() {
        if (this.m_parentSuite != null) {
            return this.m_parentSuite.getExcludedGroups();
        }
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            return this.m_xmlGroups.getRun().getExcludes();
        }
        return this.m_excludedGroups;
    }

    public void addExcludedGroup(String string) {
        this.m_excludedGroups.add(string);
    }

    public Boolean getGroupByInstances() {
        return this.m_groupByInstances;
    }

    public void setGroupByInstances(boolean bl) {
        this.m_groupByInstances = bl;
    }

    public void addListener(String string) {
        this.m_listeners.add(string);
    }

    public Boolean getAllowReturnValues() {
        return this.m_allowReturnValues;
    }

    public void setAllowReturnValues(Boolean bl) {
        this.m_allowReturnValues = bl;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }

    @OnElement(tag="parameter", attributes={"name", "value"})
    public void onParameterElement(String string, String string2) {
        this.getParameters().put(string, string2);
    }

    @OnElementList(tag="listeners", attributes={"class-name"})
    public void onListenerElement(String string) {
        this.addListener(string);
    }

    @OnElementList(tag="suite-files", attributes={"path"})
    public void onSuiteFilesElement(String string) {
        this.getSuiteFiles().add(string);
    }

    @OnElementList(tag="packages", attributes={"name"})
    public void onPackagesElement(String string) {
        this.getPackages().add(new XmlPackage(string));
    }

    public void onMethodSelectorElement(String string, String string2, String string3) {
        System.out.println("Language:" + string);
    }

    public XmlGroups getGroups() {
        return this.m_xmlGroups;
    }

    public void addTest(XmlTest xmlTest) {
        this.getTests().add(xmlTest);
    }

    public Collection<String> getPackageNames() {
        List<String> list = Lists.newArrayList();
        for (XmlPackage xmlPackage : this.getPackages()) {
            list.add(xmlPackage.getName());
        }
        return list;
    }

    public static enum FailurePolicy {
        SKIP("skip"),
        CONTINUE("continue");

        private final String name;

        private FailurePolicy(String string2) {
            this.name = string2;
        }

        public static FailurePolicy getValidPolicy(String string) {
            if (string == null) {
                return null;
            }
            try {
                return FailurePolicy.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ParallelMode {
        TESTS("tests", false),
        METHODS("methods"),
        CLASSES("classes"),
        INSTANCES("instances"),
        NONE("none", false),
        TRUE("true"),
        FALSE("false", false);

        private final String name;
        private final boolean isParallel;

        private ParallelMode(String string2) {
            this(string2, true);
        }

        private ParallelMode(String string2, boolean bl) {
            this.name = string2;
            this.isParallel = bl;
        }

        public static ParallelMode getValidParallel(String string) {
            if (string == null) {
                return null;
            }
            try {
                return ParallelMode.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public static ParallelMode skipDeprecatedValues(ParallelMode parallelMode) {
            if (parallelMode == TRUE) {
                Utils.log("XmlSuite", 1, "[WARN] 'parallel' value 'true' is deprecated, default value will be used instead: '" + (Object)((Object)METHODS) + "'.");
                return METHODS;
            }
            if (parallelMode == FALSE) {
                Utils.log("XmlSuite", 1, "[WARN] 'parallel' value 'false' is deprecated, default value will be used instead: '" + (Object)((Object)NONE) + "'.");
                return NONE;
            }
            return parallelMode;
        }

        public boolean isParallel() {
            return this.isParallel;
        }

        public String toString() {
            return this.name;
        }
    }
}

