/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.HashMap;
import java.util.Map;

public class XMLReporterConfig {
    public static final String TAG_TEST = "test";
    public static final String TAG_TEST_METHOD = "test-method";
    public static final String TAG_EXCEPTION = "exception";
    public static final String TAG_MESSAGE = "message";
    public static final String TAG_SHORT_STACKTRACE = "short-stacktrace";
    public static final String TAG_FULL_STACKTRACE = "full-stacktrace";
    public static final String TAG_TESTNG_RESULTS = "testng-results";
    public static final String TAG_SUITE = "suite";
    public static final String TAG_GROUPS = "groups";
    public static final String TAG_GROUP = "group";
    public static final String TAG_CLASS = "class";
    public static final String TAG_METHOD = "method";
    public static final String TAG_PARAMS = "params";
    public static final String TAG_PARAM = "param";
    public static final String TAG_PARAM_VALUE = "value";
    public static final String TAG_REPORTER_OUTPUT = "reporter-output";
    public static final String TAG_LINE = "line";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String ATTR_URL = "url";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_METHOD_SIG = "signature";
    public static final String ATTR_GROUPS = "groups";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TEST_INSTANCE_NAME = "test-instance-name";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_IS_NULL = "is-null";
    public static final String ATTR_PACKAGE = "package";
    public static final String ATTR_STARTED_AT = "started-at";
    public static final String ATTR_FINISHED_AT = "finished-at";
    public static final String ATTR_DURATION_MS = "duration-ms";
    public static final String ATTR_IS_CONFIG = "is-config";
    public static final String ATTR_DEPENDS_ON_METHODS = "depends-on-methods";
    public static final String ATTR_DEPENDS_ON_GROUPS = "depends-on-groups";
    public static final String ATTR_DATA_PROVIDER = "data-provider";
    public static final String TEST_PASSED = "PASS";
    public static final String TEST_FAILED = "FAIL";
    public static final String TEST_SKIPPED = "SKIP";
    private static Map<String, Integer> STATUSES = new HashMap<String, Integer>(){
        {
            this.put(XMLReporterConfig.TEST_PASSED, 1);
            this.put(XMLReporterConfig.TEST_FAILED, 2);
            this.put(XMLReporterConfig.TEST_SKIPPED, 3);
        }
    };
    public static final int FF_LEVEL_NONE = 1;
    public static final int FF_LEVEL_SUITE = 2;
    public static final int FF_LEVEL_SUITE_RESULT = 3;
    static final String FMT_DEFAULT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private int fileFragmentationLevel = 1;
    private StackTraceLevels stackTraceOutputMethod = StackTraceLevels.FULL;
    private StackTraceLevels stackTraceOutputLevel = StackTraceLevels.parse(System.getProperty("stacktrace.success.output.level", StackTraceLevels.FULL.toString()));
    private String outputDirectory;
    private boolean generateGroupsAttribute = false;
    private boolean splitClassAndPackageNames = false;
    private boolean generateDependsOnMethods = true;
    private boolean generateDependsOnGroups = true;
    private boolean generateTestResultAttributes = false;
    private String timestampFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static Integer getStatus(String string) {
        return STATUSES.get(string);
    }

    public int getFileFragmentationLevel() {
        return this.fileFragmentationLevel;
    }

    public void setFileFragmentationLevel(int n) {
        this.fileFragmentationLevel = n;
    }

    @Deprecated
    public int getStackTraceOutputMethod() {
        return this.stackTraceOutputMethod.getLevel();
    }

    public StackTraceLevels getStackTraceOutput() {
        return this.stackTraceOutputMethod;
    }

    public void setStackTraceOutput(StackTraceLevels stackTraceLevels) {
        this.stackTraceOutputMethod = stackTraceLevels;
    }

    public StackTraceLevels getStackTraceOutputLevelForPassedTests() {
        return this.stackTraceOutputLevel;
    }

    @Deprecated
    public void setStackTraceOutputMethod(int n) {
        this.stackTraceOutputMethod = StackTraceLevels.parse(n);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public boolean isGenerateGroupsAttribute() {
        return this.generateGroupsAttribute;
    }

    public void setGenerateGroupsAttribute(boolean bl) {
        this.generateGroupsAttribute = bl;
    }

    public boolean isSplitClassAndPackageNames() {
        return this.splitClassAndPackageNames;
    }

    public void setSplitClassAndPackageNames(boolean bl) {
        this.splitClassAndPackageNames = bl;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public boolean isGenerateDependsOnMethods() {
        return this.generateDependsOnMethods;
    }

    public void setGenerateDependsOnMethods(boolean bl) {
        this.generateDependsOnMethods = bl;
    }

    public boolean isGenerateDependsOnGroups() {
        return this.generateDependsOnGroups;
    }

    public void setGenerateDependsOnGroups(boolean bl) {
        this.generateDependsOnGroups = bl;
    }

    public void setGenerateTestResultAttributes(boolean bl) {
        this.generateTestResultAttributes = bl;
    }

    public boolean isGenerateTestResultAttributes() {
        return this.generateTestResultAttributes;
    }

    public static enum StackTraceLevels {
        NONE(0),
        SHORT(1),
        FULL(2),
        BOTH(3);

        private int level;

        private StackTraceLevels(int n2) {
            this.level = n2;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return Integer.toString(this.level);
        }

        public static StackTraceLevels parse(int n) {
            for (StackTraceLevels stackTraceLevels : StackTraceLevels.values()) {
                if (stackTraceLevels.getLevel() != n) continue;
                return stackTraceLevels;
            }
            throw new IllegalArgumentException(n + " is not a valid StackTrace level");
        }

        public static StackTraceLevels parse(String string) {
            return StackTraceLevels.parse(Integer.parseInt(string));
        }
    }
}

