/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IParameterizable;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderHolder;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.Nullable;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.internal.collections.ArrayIterator;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Parameters {
    public static final String NULL_VALUE = "null";
    private static Class<?>[] annotationList = new Class[]{BeforeSuite.class, AfterSuite.class, BeforeTest.class, AfterTest.class, BeforeClass.class, AfterClass.class, BeforeGroups.class, AfterGroups.class, BeforeMethod.class, AfterMethod.class};
    private static Map<String, List<Class>> mapping = Maps.newHashMap();

    public static Object[] createInstantiationParameters(Constructor constructor, String string, IAnnotationFinder iAnnotationFinder, String[] stringArray, Map<String, String> map, XmlSuite xmlSuite) {
        return Parameters.createParameters(constructor.toString(), constructor.getParameterTypes(), iAnnotationFinder.findOptionalValues(constructor), string, iAnnotationFinder, stringArray, new MethodParameters(map, Collections.emptyMap()), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method method, Map<String, String> map, Object[] objectArray, @Nullable ITestNGMethod iTestNGMethod, IAnnotationFinder iAnnotationFinder, XmlSuite xmlSuite, ITestContext iTestContext, ITestResult iTestResult) {
        Method method2 = iTestNGMethod != null ? iTestNGMethod.getConstructorOrMethod().getMethod() : null;
        Map<String, String> map2 = iTestNGMethod != null ? iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest()) : Collections.emptyMap();
        return Parameters.createParameters(method, new MethodParameters(map, map2, objectArray, method2, iTestContext, iTestResult), iAnnotationFinder, xmlSuite, IConfigurationAnnotation.class, Parameters.retrieveConfigAnnotation(method));
    }

    private static String retrieveConfigAnnotation(Method method) {
        String string = "@Configuration";
        for (Class<?> clazz : annotationList) {
            if (method.getAnnotation(clazz) == null) continue;
            string = clazz.getSimpleName();
            break;
        }
        return string;
    }

    public static Object getInjectedParameter(Class<?> clazz, Method method, ITestContext iTestContext, ITestResult iTestResult) {
        Object object = null;
        if (Method.class.equals(clazz)) {
            object = method;
        } else if (ITestContext.class.equals(clazz)) {
            object = iTestContext;
        } else if (XmlTest.class.equals(clazz)) {
            object = iTestContext.getCurrentXmlTest();
        } else if (ITestResult.class.equals(clazz)) {
            object = iTestResult;
        }
        return object;
    }

    private static Object[] createParameters(String string, Class[] classArray, String[] stringArray, String string2, IAnnotationFinder iAnnotationFinder, String[] stringArray2, MethodParameters methodParameters, XmlSuite xmlSuite) {
        Object[] objectArray = new Object[]{};
        if (classArray.length > 0) {
            List list = Lists.newArrayList();
            Parameters.checkParameterTypes(string, classArray, string2, stringArray2);
            int n = 0;
            for (int i = 0; i < classArray.length; ++i) {
                Object object = Parameters.getInjectedParameter(classArray[i], methodParameters.currentTestMethod, methodParameters.context, methodParameters.testResult);
                if (object != null) {
                    list.add(object);
                    continue;
                }
                if (n >= stringArray2.length) continue;
                String string3 = stringArray2[n];
                String string4 = (String)methodParameters.xmlParameters.get(string3);
                if (null == string4) {
                    string4 = System.getProperty(string3);
                }
                if (null == string4) {
                    if (stringArray != null) {
                        string4 = stringArray[i];
                    }
                    if (null == string4) {
                        throw new TestNGException("Parameter '" + string3 + "' is required by " + string2 + " on method " + string + " but has not been marked @Optional or defined\n" + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                    }
                }
                list.add(Parameters.convertType(classArray[i], string4, string3));
                ++n;
            }
            objectArray = list.toArray(new Object[list.size()]);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkParameterTypes(String string, Class[] classArray, String string2, String[] stringArray) {
        int n = classArray.length;
        HashSet<Class> hashSet = new HashSet<Class>(){
            private static final long serialVersionUID = -5324894581793435812L;
            {
                this.add(ITestContext.class);
                this.add(ITestResult.class);
                this.add(XmlTest.class);
                this.add(Method.class);
                this.add(Object[].class);
            }
        };
        for (Class clazz : classArray) {
            if (!hashSet.contains(clazz)) continue;
            --n;
        }
        if (stringArray.length == 0 && n != 0) {
            void var6_9;
            String string3 = "Cannot inject " + string2 + " annotated Method [" + string + "] with " + Arrays.toString(classArray);
            if (mapping.containsKey(string2)) {
                String string4 = "Can inject only one of " + Parameters.prettyFormat(mapping.get(string2)) + " into a " + string2 + " annotated " + string;
            }
            throw new TestNGException((String)var6_9 + ".\nFor more information on native dependency injection please refer to http://testng.org/doc/documentation-main.html#native-dependency-injection");
        }
        if (stringArray.length != n) {
            throw new TestNGException("Method " + string + " requires " + classArray.length + " parameters but " + stringArray.length + " were supplied in the " + string2 + " annotation.");
        }
    }

    private static String prettyFormat(List<Class> list) {
        StringBuilder stringBuilder = new StringBuilder("<");
        if (list.size() == 1) {
            stringBuilder.append(list.get(0));
        } else {
            int n = list.size();
            for (int i = 0; i < n - 1; ++i) {
                stringBuilder.append(list.get(i).getSimpleName()).append(", ");
            }
            stringBuilder.append(list.get(n - 1).getSimpleName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public static <T> T convertType(Class<T> clazz, String string, String string2) {
        try {
            if (string == null || NULL_VALUE.equals(string.toLowerCase())) {
                if (clazz.isPrimitive()) {
                    Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + string2 + "'");
                }
                return null;
            }
            if (clazz == String.class) {
                return (T)string;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (T)Integer.valueOf(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (T)Byte.valueOf(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return (T)Double.valueOf(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return (T)Float.valueOf(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return (T)Long.valueOf(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (T)Short.valueOf(string);
            }
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, string);
            }
        }
        catch (Exception exception) {
            throw new TestNGException("Conversion issue on parameter: " + string2, exception);
        }
        throw new TestNGException("Unsupported type parameter : " + clazz);
    }

    private static DataProviderHolder findDataProvider(Object object, ITestClass iTestClass, ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder, ITestContext iTestContext) {
        DataProviderHolder dataProviderHolder = null;
        IDataProvidable iDataProvidable = Parameters.findDataProviderInfo(iTestClass, constructorOrMethod, iAnnotationFinder);
        if (iDataProvidable != null) {
            String string = iDataProvidable.getDataProvider();
            Class<?> clazz = iDataProvidable.getDataProviderClass();
            if (!Utils.isStringEmpty(string) && null == (dataProviderHolder = Parameters.findDataProvider(object, iTestClass, iAnnotationFinder, string, clazz, iTestContext))) {
                throw new TestNGException("Method " + constructorOrMethod + " requires a @DataProvider named : " + string + (clazz != null ? " in class " + clazz.getName() : ""));
            }
        }
        return dataProviderHolder;
    }

    private static IDataProvidable findDataProviderInfo(ITestClass iTestClass, ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder) {
        IDataProvidable iDataProvidable;
        if (constructorOrMethod.getMethod() != null) {
            iDataProvidable = AnnotationHelper.findTest(iAnnotationFinder, constructorOrMethod.getMethod());
            if (iDataProvidable == null) {
                iDataProvidable = AnnotationHelper.findFactory(iAnnotationFinder, constructorOrMethod.getMethod());
            }
            if (iDataProvidable == null) {
                iDataProvidable = AnnotationHelper.findTest(iAnnotationFinder, iTestClass.getRealClass());
            }
        } else {
            iDataProvidable = AnnotationHelper.findFactory(iAnnotationFinder, constructorOrMethod.getConstructor());
        }
        return iDataProvidable;
    }

    private static DataProviderHolder findDataProvider(Object object, ITestClass iTestClass, IAnnotationFinder iAnnotationFinder, String string, Class<?> clazz, ITestContext iTestContext) {
        DataProviderHolder dataProviderHolder = null;
        Class<?> clazz2 = iTestClass.getRealClass();
        boolean bl = false;
        if (clazz != null) {
            clazz2 = clazz;
            bl = true;
        }
        for (Method method : ClassHelper.getAvailableMethods(clazz2)) {
            Injector injector;
            IDataProviderAnnotation iDataProviderAnnotation = iAnnotationFinder.findAnnotation(method, IDataProviderAnnotation.class);
            if (null == iDataProviderAnnotation || !string.equals(Parameters.getDataProviderName(iDataProviderAnnotation, method))) continue;
            Object object2 = bl && (method.getModifiers() & 8) == 0 ? ((injector = iTestContext.getInjector(iTestClass)) != null ? injector.getInstance(clazz) : ClassHelper.newInstance(clazz)) : object;
            if ((method.getModifiers() & 8) == 0 && object2 == null) {
                object2 = ClassHelper.newInstanceOrNull(clazz2);
            }
            if (dataProviderHolder != null) {
                throw new TestNGException("Found two providers called '" + string + "' on " + clazz2);
            }
            dataProviderHolder = new DataProviderHolder(iDataProviderAnnotation, method, object2);
        }
        return dataProviderHolder;
    }

    private static String getDataProviderName(IDataProviderAnnotation iDataProviderAnnotation, Method method) {
        return Strings.isNullOrEmpty(iDataProviderAnnotation.getName()) ? method.getName() : iDataProviderAnnotation.getName();
    }

    private static Object[] createParameters(Method method, MethodParameters methodParameters, IAnnotationFinder iAnnotationFinder, XmlSuite xmlSuite, Class clazz, String string) {
        Object[] objectArray;
        Object object;
        List list = Lists.newArrayList();
        IParametersAnnotation iParametersAnnotation = iAnnotationFinder.findAnnotation(method, IParametersAnnotation.class);
        Class[] classArray = method.getParameterTypes();
        if (null != iParametersAnnotation) {
            object = iParametersAnnotation.getValue();
            objectArray = Parameters.createParameters(method.getName(), classArray, iAnnotationFinder.findOptionalValues(method), string, iAnnotationFinder, (String[])object, methodParameters, xmlSuite);
        } else {
            object = (IParameterizable)iAnnotationFinder.findAnnotation(method, clazz);
            if (null != object && object.getParameters().length > 0) {
                String[] stringArray = object.getParameters();
                objectArray = Parameters.createParameters(method.getName(), classArray, iAnnotationFinder.findOptionalValues(method), string, iAnnotationFinder, stringArray, methodParameters, xmlSuite);
            } else {
                objectArray = Parameters.createParameters(method.getName(), classArray, iAnnotationFinder.findOptionalValues(method), string, iAnnotationFinder, new String[0], methodParameters, xmlSuite);
            }
        }
        Collections.addAll(list, objectArray);
        for (int i = 0; i < classArray.length; ++i) {
            if (!Object[].class.equals((Object)classArray[i])) continue;
            list.add(i, methodParameters.parameterValues);
        }
        return list.toArray(new Object[list.size()]);
    }

    public static ParameterHolder handleParameters(final ITestNGMethod iTestNGMethod, Map<String, String> map, Object object, MethodParameters methodParameters, XmlSuite xmlSuite, IAnnotationFinder iAnnotationFinder, Object object2) {
        final DataProviderHolder dataProviderHolder = Parameters.findDataProvider(object, iTestNGMethod.getTestClass(), iTestNGMethod.getConstructorOrMethod(), iAnnotationFinder, methodParameters.context);
        if (null != dataProviderHolder) {
            Object object3;
            int n = iTestNGMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int i = 0; i < n; ++i) {
                object3 = "param" + i;
                map.put((String)object3, (String)object3);
            }
            final Iterator<Object[]> iterator = MethodInvocationHelper.invokeDataProvider(dataProviderHolder.instance, dataProviderHolder.method, iTestNGMethod, methodParameters.context, object2, iAnnotationFinder);
            object3 = new ArrayList();
            object3.addAll(iTestNGMethod.getInvocationNumbers());
            object3.addAll(dataProviderHolder.annotation.getIndices());
            final Iterator<Object[]> iterator2 = new Iterator<Object[]>((List)object3){
                int index = 0;
                boolean hasWarn = false;
                final /* synthetic */ List val$allIndices;
                {
                    this.val$allIndices = list;
                }

                @Override
                public boolean hasNext() {
                    if (this.index == 0 && !iterator.hasNext() && !this.hasWarn) {
                        this.hasWarn = true;
                        Utils.log("", 2, "Warning: the data provider '" + dataProviderHolder.annotation.getName() + "' returned an empty array or iterator, so this test is not doing anything");
                    }
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    iTestNGMethod.setParameterInvocationCount(this.index);
                    Object[] objectArray = (Object[])iterator.next();
                    if (!this.val$allIndices.isEmpty() && !this.val$allIndices.contains(this.index)) {
                        objectArray = null;
                    }
                    ++this.index;
                    return objectArray;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
            iTestNGMethod.setMoreInvocationChecker(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return iterator2.hasNext();
                }
            });
            return new ParameterHolder(iterator2, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, dataProviderHolder);
        }
        map.putAll(methodParameters.xmlParameters);
        Object[][] objectArray = new Object[][]{Parameters.createParameters(iTestNGMethod.getConstructorOrMethod().getMethod(), methodParameters, iAnnotationFinder, xmlSuite, ITestAnnotation.class, "@Test")};
        iTestNGMethod.setParameterInvocationCount(objectArray.length);
        ArrayIterator arrayIterator = new ArrayIterator(objectArray);
        return new ParameterHolder(arrayIterator, ParameterHolder.ParameterOrigin.ORIGIN_XML, null);
    }

    static {
        List<Class> list = Arrays.asList(ITestContext.class, XmlTest.class);
        List<Class> list2 = Arrays.asList(ITestContext.class, XmlTest.class, Method.class, Object[].class);
        mapping.put(BeforeSuite.class.getSimpleName(), list);
        mapping.put(AfterSuite.class.getSimpleName(), list);
        mapping.put(BeforeTest.class.getSimpleName(), list);
        mapping.put(AfterTest.class.getSimpleName(), list);
        mapping.put(BeforeGroups.class.getSimpleName(), list);
        mapping.put(AfterGroups.class.getSimpleName(), list);
        mapping.put(BeforeClass.class.getSimpleName(), list);
        mapping.put(AfterClass.class.getSimpleName(), list);
        mapping.put(BeforeMethod.class.getSimpleName(), list2);
        mapping.put(AfterMethod.class.getSimpleName(), list2);
    }

    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        public ITestResult testResult;

        public MethodParameters(Map<String, String> map, Map<String, String> map2) {
            this(map, map2, null, null, null, null);
        }

        public MethodParameters(Map<String, String> map, Map<String, String> map2, Object[] objectArray, Method method, ITestContext iTestContext, ITestResult iTestResult) {
            Map<String, String> map3 = Maps.newHashMap();
            map3.putAll(map);
            map3.putAll(map2);
            this.xmlParameters = map3;
            this.currentTestMethod = method;
            this.context = iTestContext;
            this.parameterValues = objectArray;
            this.testResult = iTestResult;
        }
    }
}

