/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.PoolService;
import org.testng.internal.RegexpExpectedExceptionsHolder;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestMethodWithDataProviderMethodWorker;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNgMethodUtils;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.reflect.DataProviderMethodMatcher;
import org.testng.internal.reflect.MethodMatcherContext;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.util.Strings;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Invoker
implements IInvoker {
    private final ITestContext m_testContext;
    private final ITestResultNotifier m_notifier;
    private final IAnnotationFinder m_annotationFinder;
    private final SuiteRunState m_suiteState;
    private final boolean m_skipFailedInvocationCounts;
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    private final boolean m_continueOnFailedConfiguration;
    private final List<IClassListener> m_classListeners;
    private Map<String, Boolean> m_beforegroupsFailures = Maps.newHashtable();
    private Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newHashtable();
    private Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newHashtable();
    private IConfiguration m_configuration;
    private static Predicate<ITestNGMethod, IClass> CAN_RUN_FROM_CLASS = new CanRunFromClassPredicate();
    private static final Predicate<ITestNGMethod, IClass> SAME_CLASS = new SameClassNamePredicate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassInvocationFailure(Class<?> clazz, Object object) {
        Map<Class<?>, Set<Object>> map = this.m_classInvocationResults;
        synchronized (map) {
            Set<Object> set = this.m_classInvocationResults.get(clazz);
            if (set == null) {
                set = Sets.newHashSet();
                this.m_classInvocationResults.put(clazz, set);
            }
            set.add(object);
        }
    }

    private void setMethodInvocationFailure(ITestNGMethod iTestNGMethod, Object object) {
        Set<Object> set = this.m_methodInvocationResults.get(iTestNGMethod);
        if (set == null) {
            set = Sets.newHashSet();
            this.m_methodInvocationResults.put(iTestNGMethod, set);
        }
        set.add(Invoker.getMethodInvocationToken(iTestNGMethod, object));
    }

    public Invoker(IConfiguration iConfiguration, ITestContext iTestContext, ITestResultNotifier iTestResultNotifier, SuiteRunState suiteRunState, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.m_configuration = iConfiguration;
        this.m_testContext = iTestContext;
        this.m_suiteState = suiteRunState;
        this.m_notifier = iTestResultNotifier;
        this.m_annotationFinder = iConfiguration.getAnnotationFinder();
        this.m_skipFailedInvocationCounts = bl;
        this.m_invokedMethodListeners = collection;
        this.m_continueOnFailedConfiguration = iTestContext.getSuite().getXmlSuite().getConfigFailurePolicy() == XmlSuite.FailurePolicy.CONTINUE;
        this.m_classListeners = list;
    }

    @Override
    public void invokeConfigurations(IClass iClass, ITestNGMethod[] iTestNGMethodArray, XmlSuite xmlSuite, Map<String, String> map, Object[] objectArray, Object object) {
        this.invokeConfigurations(iClass, null, iTestNGMethodArray, xmlSuite, map, objectArray, object, null);
    }

    private void invokeConfigurations(IClass iClass, ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, XmlSuite xmlSuite, Map<String, String> map, Object[] objectArray, Object object, ITestResult iTestResult) {
        ITestNGMethod[] iTestNGMethodArray2;
        if (null == iTestNGMethodArray || iTestNGMethodArray.length == 0) {
            this.log(5, "No configuration methods found");
            return;
        }
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray2 = this.filterMethods(iClass, iTestNGMethodArray, SAME_CLASS)) {
            if (null == iClass) {
                iClass = iTestNGMethod2.getTestClass();
            }
            TestResult testResult = new TestResult(iClass, object != null ? object : iTestNGMethod2.getInstance(), iTestNGMethod2, null, System.currentTimeMillis(), System.currentTimeMillis(), this.m_testContext);
            IConfigurationAnnotation iConfigurationAnnotation = null;
            try {
                Object object2 = iTestNGMethod2.getInstance();
                if (object2 == null) {
                    object2 = object;
                }
                Class<?> clazz = object2.getClass();
                ConstructorOrMethod constructorOrMethod = iTestNGMethod2.getConstructorOrMethod();
                iConfigurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, constructorOrMethod);
                boolean bl = this.isAlwaysRun(iConfigurationAnnotation);
                if (MethodHelper.isEnabled(clazz, this.m_annotationFinder) || bl) {
                    if (MethodHelper.isEnabled(iConfigurationAnnotation)) {
                        if (!this.confInvocationPassed(iTestNGMethod2, iTestNGMethod, iClass, object) && !bl) {
                            this.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod2, true));
                            this.handleConfigurationSkip(iTestNGMethod2, testResult, iConfigurationAnnotation, iTestNGMethod, object, xmlSuite);
                            continue;
                        }
                        this.log(3, "Invoking " + Utils.detailedMethodName(iTestNGMethod2, true));
                        Object[] objectArray2 = Parameters.createConfigurationParameters(iTestNGMethod2.getConstructorOrMethod().getMethod(), map, objectArray, iTestNGMethod, this.m_annotationFinder, xmlSuite, this.m_testContext, iTestResult);
                        testResult.setParameters(objectArray2);
                        this.runConfigurationListeners(testResult, true);
                        Object object3 = object == null || !iTestNGMethod2.getConstructorOrMethod().getDeclaringClass().isAssignableFrom(object.getClass()) ? object2 : object;
                        this.invokeConfigurationMethod(object3, iTestNGMethod2, objectArray2, testResult);
                        this.runConfigurationListeners(testResult, false);
                        continue;
                    }
                    this.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod2, true) + " because it is not enabled");
                    continue;
                }
                this.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod2, true) + " because " + clazz.getName() + " is not enabled");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handleConfigurationFailure(invocationTargetException, iTestNGMethod2, testResult, iConfigurationAnnotation, iTestNGMethod, object, xmlSuite);
            }
            catch (Throwable throwable) {
                this.handleConfigurationFailure(throwable, iTestNGMethod2, testResult, iConfigurationAnnotation, iTestNGMethod, object, xmlSuite);
            }
        }
    }

    private void handleConfigurationSkip(ITestNGMethod iTestNGMethod, ITestResult iTestResult, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        this.recordConfigurationInvocationFailed(iTestNGMethod, iTestResult.getTestClass(), iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
        iTestResult.setStatus(3);
        this.runConfigurationListeners(iTestResult, false);
    }

    private boolean isAlwaysRun(IConfigurationAnnotation iConfigurationAnnotation) {
        if (null == iConfigurationAnnotation) {
            return false;
        }
        boolean bl = false;
        if ((iConfigurationAnnotation.getAfterSuite() || iConfigurationAnnotation.getAfterTest() || iConfigurationAnnotation.getAfterTestClass() || iConfigurationAnnotation.getAfterTestMethod() || iConfigurationAnnotation.getBeforeTestMethod() || iConfigurationAnnotation.getBeforeTestClass() || iConfigurationAnnotation.getBeforeTest() || iConfigurationAnnotation.getBeforeSuite()) && iConfigurationAnnotation.getAlwaysRun()) {
            bl = true;
        }
        return bl;
    }

    private void handleConfigurationFailure(Throwable throwable, ITestNGMethod iTestNGMethod, ITestResult iTestResult, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        Throwable throwable2;
        Throwable throwable3 = throwable2 = throwable.getCause() != null ? throwable.getCause() : throwable;
        if (this.isSkipExceptionAndSkip(throwable2)) {
            iTestResult.setThrowable(throwable2);
            this.handleConfigurationSkip(iTestNGMethod, iTestResult, iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
            return;
        }
        Utils.log("", 3, "Failed to invoke configuration method " + iTestNGMethod.getQualifiedName() + ":" + throwable2.getMessage());
        this.handleException(throwable2, iTestNGMethod, iTestResult, 1);
        this.runConfigurationListeners(iTestResult, false);
        if (null != iConfigurationAnnotation) {
            this.recordConfigurationInvocationFailed(iTestNGMethod, iTestResult.getTestClass(), iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
        }
    }

    private XmlClass[] findClassesInSameTest(Class<?> clazz, XmlSuite xmlSuite) {
        Map<String, XmlClass> map = Maps.newHashMap();
        String string = clazz.getName();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                if (!xmlClass.getName().equals(string)) continue;
                for (XmlClass xmlClass2 : xmlTest.getXmlClasses()) {
                    map.put(xmlClass2.getName(), xmlClass2);
                }
            }
        }
        XmlClass[] xmlClassArray = map.values().toArray(new XmlClass[map.size()]);
        return xmlClassArray;
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod iTestNGMethod, IClass iClass, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        Object[] objectArray;
        if (iConfigurationAnnotation.getBeforeTestClass() || iConfigurationAnnotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(iClass.getRealClass(), object);
            } else {
                this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            }
        } else if (iConfigurationAnnotation.getBeforeTestMethod() || iConfigurationAnnotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(iTestNGMethod2, object);
            } else {
                this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            }
        } else if (iConfigurationAnnotation.getBeforeSuite() || iConfigurationAnnotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (iConfigurationAnnotation.getBeforeTest() || iConfigurationAnnotation.getAfterTest()) {
            this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            objectArray = this.findClassesInSameTest(iTestNGMethod.getRealClass(), xmlSuite);
            for (Object object2 : objectArray) {
                this.setClassInvocationFailure(((XmlClass)object2).getSupportClass(), object);
            }
        }
        objectArray = iConfigurationAnnotation.getBeforeGroups();
        if (null != objectArray && objectArray.length > 0) {
            for (Object object2 : objectArray) {
                this.m_beforegroupsFailures.put((String)object2, Boolean.FALSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean classConfigurationFailed(Class<?> clazz) {
        Map<Class<?>, Set<Object>> map = this.m_classInvocationResults;
        synchronized (map) {
            for (Class<?> clazz2 : this.m_classInvocationResults.keySet()) {
                if (clazz2 != clazz && !clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean confInvocationPassed(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2, IClass iClass, Object object) {
        Object object2;
        boolean bl = true;
        Class<?> clazz = iClass.getRealClass();
        if (this.m_suiteState.isFailed()) {
            bl = false;
        } else if (this.classConfigurationFailed(clazz)) {
            if (!this.m_continueOnFailedConfiguration) {
                bl = !this.classConfigurationFailed(clazz);
            } else {
                object2 = this.m_classInvocationResults;
                synchronized (object2) {
                    bl = !this.m_classInvocationResults.get(clazz).contains(object);
                }
            }
        } else if (this.m_continueOnFailedConfiguration && iTestNGMethod2 != null && this.m_methodInvocationResults.containsKey(iTestNGMethod2)) {
            bl = !this.m_methodInvocationResults.get(iTestNGMethod2).contains(Invoker.getMethodInvocationToken(iTestNGMethod2, object));
        } else if (!this.m_continueOnFailedConfiguration) {
            object2 = this.m_classInvocationResults;
            synchronized (object2) {
                for (Class clazz2 : this.m_classInvocationResults.keySet()) {
                    if (!clazz2.isAssignableFrom(clazz)) continue;
                    bl = false;
                    break;
                }
            }
        }
        object2 = iTestNGMethod.getGroups();
        if (null != object2 && ((String[])object2).length > 0) {
            for (String string : object2) {
                if (!this.m_beforegroupsFailures.containsKey(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static Object getMethodInvocationToken(ITestNGMethod iTestNGMethod, Object object) {
        return String.format("%s+%d+%d", object.toString(), iTestNGMethod.getCurrentInvocationCount(), iTestNGMethod.getParameterInvocationCount());
    }

    private void invokeConfigurationMethod(Object object, ITestNGMethod iTestNGMethod, Object[] objectArray, ITestResult iTestResult) throws InvocationTargetException, IllegalAccessException {
        iTestNGMethod.setId(ThreadUtil.currentThreadInfo());
        InvokedMethod invokedMethod = new InvokedMethod(object, iTestNGMethod, System.currentTimeMillis(), iTestResult);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, iTestResult);
        this.m_notifier.addInvokedMethod(invokedMethod);
        try {
            IConfigurable iConfigurable;
            Reporter.setCurrentTestResult(iTestResult);
            ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
            IConfigurable iConfigurable2 = iConfigurable = IConfigurable.class.isAssignableFrom(constructorOrMethod.getDeclaringClass()) ? (IConfigurable)object : this.m_configuration.getConfigurable();
            if (iConfigurable != null) {
                MethodInvocationHelper.invokeConfigurable(object, objectArray, iConfigurable, constructorOrMethod.getMethod(), iTestResult);
            } else if (MethodHelper.calculateTimeOut(iTestNGMethod) <= 0L) {
                MethodInvocationHelper.invokeMethod(constructorOrMethod.getMethod(), object, objectArray);
            } else {
                MethodInvocationHelper.invokeWithTimeout(iTestNGMethod, object, objectArray, iTestResult);
                if (!iTestResult.isSuccess()) {
                    this.throwConfigurationFailure(iTestResult, iTestResult.getThrowable());
                    throw iTestResult.getThrowable();
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            this.throwConfigurationFailure(iTestResult, reflectiveOperationException);
            throw reflectiveOperationException;
        }
        catch (Throwable throwable) {
            this.throwConfigurationFailure(iTestResult, throwable);
            throw new TestNGException(throwable);
        }
        finally {
            iTestResult.setEndMillis(System.currentTimeMillis());
            Reporter.setCurrentTestResult(iTestResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, iTestResult);
            Reporter.setCurrentTestResult(null);
        }
    }

    private void throwConfigurationFailure(ITestResult iTestResult, Throwable throwable) {
        iTestResult.setStatus(2);
        iTestResult.setThrowable(throwable.getCause() == null ? throwable : throwable.getCause());
    }

    private void runInvokedMethodListeners(InvokedMethodListenerMethod invokedMethodListenerMethod, IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invokedMethodListenerInvoker = new InvokedMethodListenerInvoker(invokedMethodListenerMethod, iTestResult, this.m_testContext);
        for (IInvokedMethodListener iInvokedMethodListener : this.m_invokedMethodListeners) {
            invokedMethodListenerInvoker.invokeListener(iInvokedMethodListener, iInvokedMethod);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.size() == 0;
    }

    /*
     * Exception decompiling
     */
    private ITestResult invokeMethod(Object var1_1, ITestNGMethod var2_2, Object[] var3_3, int var4_4, XmlSuite var5_5, Map<String, String> var6_6, ITestClass var7_7, ITestNGMethod[] var8_8, ITestNGMethod[] var9_9, ConfigurationGroupMethods var10_10, FailureContext var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setTestStatus(ITestResult iTestResult, int n) {
        if (iTestResult.getStatus() == 16) {
            iTestResult.setStatus(n);
        }
    }

    private Throwable getExceptionDetails(Object object) {
        Set<ITestResult> set = this.m_testContext.getFailedConfigurations().getAllResults();
        if (set.isEmpty()) {
            set = this.m_testContext.getSkippedConfigurations().getAllResults();
        }
        for (ITestResult iTestResult : set) {
            if (!this.sameInstance(iTestResult, object)) continue;
            return iTestResult.getThrowable();
        }
        if (set.isEmpty()) {
            return this.getConfigFailureException();
        }
        return set.iterator().next().getThrowable();
    }

    private Throwable getConfigFailureException() {
        Throwable throwable = null;
        for (IInvokedMethod iInvokedMethod : this.m_testContext.getSuite().getAllInvokedMethods()) {
            ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
            if (!iTestNGMethod.isBeforeSuiteConfiguration() || iInvokedMethod.getTestResult().isSuccess()) continue;
            throwable = iInvokedMethod.getTestResult().getThrowable();
            break;
        }
        return throwable;
    }

    private boolean sameInstance(ITestResult iTestResult, Object object) {
        return iTestResult.getInstance() != null && iTestResult.getInstance().equals(object);
    }

    void collectResults(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        int n = iTestResult.getStatus();
        if (1 == n) {
            this.m_notifier.addPassedTest(iTestNGMethod, iTestResult);
        } else if (3 == n) {
            this.m_notifier.addSkippedTest(iTestNGMethod, iTestResult);
        } else if (2 == n) {
            this.m_notifier.addFailedTest(iTestNGMethod, iTestResult);
        } else if (4 == n) {
            this.m_notifier.addFailedButWithinSuccessPercentageTest(iTestNGMethod, iTestResult);
        } else assert (false) : "UNKNOWN STATUS:" + n;
    }

    private ITestNGMethod[] filterConfigurationMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, boolean bl) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod2;
            if (bl) {
                if (configurationMethod.isFirstTimeOnly() && (!configurationMethod.isFirstTimeOnly() || iTestNGMethod.getCurrentInvocationCount() != 0)) continue;
                list.add(iTestNGMethod2);
                continue;
            }
            if (configurationMethod.isLastTimeOnly() && (!configurationMethod.isLastTimeOnly() || iTestNGMethod.hasMoreInvocation())) continue;
            list.add(iTestNGMethod2);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    protected ITestResult invokeTestMethod(Object object, ITestNGMethod iTestNGMethod, Object[] objectArray, int n, XmlSuite xmlSuite, Map<String, String> map, ITestClass iTestClass, ITestNGMethod[] iTestNGMethodArray, ITestNGMethod[] iTestNGMethodArray2, ConfigurationGroupMethods configurationGroupMethods, FailureContext failureContext) {
        iTestNGMethod.setId(ThreadUtil.currentThreadInfo());
        ITestResult iTestResult = this.invokeMethod(object, iTestNGMethod, objectArray, n, xmlSuite, map, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, failureContext);
        return iTestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBeforeGroupsConfigurations(ITestClass iTestClass, ITestNGMethod iTestNGMethod, ConfigurationGroupMethods configurationGroupMethods, XmlSuite xmlSuite, Map<String, String> map, Object object) {
        ConfigurationGroupMethods configurationGroupMethods2 = configurationGroupMethods;
        synchronized (configurationGroupMethods2) {
            List list = Lists.newArrayList();
            String[] stringArray = iTestNGMethod.getGroups();
            Map<String, List<ITestNGMethod>> map2 = configurationGroupMethods.getBeforeGroupsMap();
            for (String string : stringArray) {
                List<ITestNGMethod> list2 = map2.get(string);
                if (list2 == null) continue;
                list.addAll(list2);
            }
            Object[] objectArray = list.toArray(new ITestNGMethod[list.size()]);
            if (objectArray.length > 0) {
                this.invokeConfigurations(null, (ITestNGMethod[])objectArray, xmlSuite, map, null, object);
            }
            configurationGroupMethods.removeBeforeGroups(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAfterGroupsConfigurations(ITestClass iTestClass, ITestNGMethod iTestNGMethod, ConfigurationGroupMethods configurationGroupMethods, XmlSuite xmlSuite, Map<String, String> map, Object object) {
        if (iTestNGMethod.getGroups().length == 0) {
            return;
        }
        Map<String, String> map2 = Maps.newHashMap();
        String[] stringArray = iTestNGMethod.getGroups();
        ConfigurationGroupMethods configurationGroupMethods2 = configurationGroupMethods;
        synchronized (configurationGroupMethods2) {
            for (String string : stringArray) {
                if (!configurationGroupMethods.isLastMethodForGroup(string, iTestNGMethod)) continue;
                map2.put(string, string);
            }
            if (map2.isEmpty()) {
                return;
            }
            Map map3 = Maps.newHashMap();
            Map<String, List<ITestNGMethod>> map4 = configurationGroupMethods.getAfterGroupsMap();
            for (String string : map2.values()) {
                List<ITestNGMethod> list = map4.get(string);
                if (list == null) continue;
                for (ITestNGMethod iTestNGMethod2 : list) {
                    map3.put(iTestNGMethod2, iTestNGMethod2);
                }
            }
            ITestNGMethod[] iTestNGMethodArray = map3.keySet().toArray(new ITestNGMethod[map3.size()]);
            this.invokeConfigurations(null, iTestNGMethodArray, xmlSuite, map, null, object);
            configurationGroupMethods.removeAfterGroups(map2.keySet());
        }
    }

    private Object[] getParametersFromIndex(Iterator<Object[]> iterator, int n) {
        while (iterator.hasNext()) {
            Object[] objectArray = iterator.next();
            if (n == 0) {
                return objectArray;
            }
            --n;
        }
        return null;
    }

    int retryFailed(Object object, ITestNGMethod iTestNGMethod, XmlSuite xmlSuite, ITestClass iTestClass, ITestNGMethod[] iTestNGMethodArray, ITestNGMethod[] iTestNGMethodArray2, ConfigurationGroupMethods configurationGroupMethods, List<ITestResult> list, int n, ExpectedExceptionsHolder expectedExceptionsHolder, ITestContext iTestContext, Map<String, String> map, int n2) {
        FailureContext failureContext = new FailureContext();
        failureContext.count = n;
        do {
            failureContext.instances = Lists.newArrayList();
            Map<String, String> map2 = Maps.newHashMap();
            ParameterBag parameterBag = this.createParameters(iTestNGMethod, map, map2, xmlSuite, iTestContext, null);
            Object[] objectArray = this.getParametersFromIndex(parameterBag.parameterHolder.parameters, n2);
            list.add(this.invokeMethod(object, iTestNGMethod, objectArray, n2, xmlSuite, map2, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, failureContext));
        } while (!failureContext.instances.isEmpty());
        return failureContext.count;
    }

    private ParameterBag createParameters(ITestNGMethod iTestNGMethod, Map<String, String> map, Map<String, String> map2, XmlSuite xmlSuite, ITestContext iTestContext, Object object) {
        Object object2 = object != null ? object : iTestNGMethod.getInstance();
        ParameterBag parameterBag = this.handleParameters(iTestNGMethod, object2, map2, map, null, xmlSuite, iTestContext, object, null);
        return parameterBag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod iTestNGMethod, XmlSuite xmlSuite, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, Object object, ITestContext iTestContext) {
        assert (null != iTestNGMethod.getTestClass()) : "COULDN'T FIND TESTCLASS FOR " + iTestNGMethod.getRealClass();
        if (!MethodHelper.isEnabled(iTestNGMethod.getConstructorOrMethod().getMethod(), this.m_annotationFinder)) {
            return Collections.emptyList();
        }
        String string = this.checkDependencies(iTestNGMethod, iTestContext.getAllTestMethods());
        if (string != null) {
            ITestResult iTestResult = this.registerSkippedTestResult(iTestNGMethod, null, System.currentTimeMillis(), new Throwable(string));
            this.m_notifier.addSkippedTest(iTestNGMethod, iTestResult);
            return Collections.singletonList(iTestResult);
        }
        Map<String, String> map2 = iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest());
        if (iTestNGMethod.getInvocationCount() > 1 && iTestNGMethod.getThreadPoolSize() > 1) {
            return this.invokePooledTestMethods(iTestNGMethod, xmlSuite, map2, configurationGroupMethods, iTestContext);
        }
        long l = iTestNGMethod.getInvocationTimeOut();
        boolean bl = iTestNGMethod.getThreadPoolSize() > 1 || l > 0L;
        int n = bl ? 1 : iTestNGMethod.getInvocationCount();
        ExpectedExceptionsHolder expectedExceptionsHolder = new ExpectedExceptionsHolder(this.m_annotationFinder, iTestNGMethod, new RegexpExpectedExceptionsHolder(this.m_annotationFinder, iTestNGMethod));
        ITestClass iTestClass = iTestNGMethod.getTestClass();
        List<ITestResult> list = Lists.newArrayList();
        FailureContext failureContext = new FailureContext();
        ITestNGMethod[] iTestNGMethodArray = this.filterMethods(iTestClass, iTestClass.getBeforeTestMethods(), CAN_RUN_FROM_CLASS);
        ITestNGMethod[] iTestNGMethodArray2 = this.filterMethods(iTestClass, iTestClass.getAfterTestMethods(), CAN_RUN_FROM_CLASS);
        while (n-- > 0) {
            Object object2;
            Object object3;
            long l2 = System.currentTimeMillis();
            Map<String, String> map3 = Maps.newHashMap();
            ParameterBag parameterBag = this.createParameters(iTestNGMethod, map2, map3, xmlSuite, iTestContext, object);
            if (parameterBag.hasErrors()) {
                object3 = parameterBag.errorResult;
                Throwable throwable = object3.getThrowable();
                if (throwable instanceof TestNGException) {
                    object3.setStatus(2);
                    this.m_notifier.addFailedTest(iTestNGMethod, (ITestResult)object3);
                } else {
                    object3.setStatus(3);
                    this.m_notifier.addSkippedTest(iTestNGMethod, (ITestResult)object3);
                }
                this.runTestListeners((ITestResult)object3);
                list.add((ITestResult)object3);
                continue;
            }
            object3 = parameterBag.parameterHolder.parameters;
            int n2 = 0;
            try {
                List<Object> list2;
                Object[] objectArray;
                if (parameterBag.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && parameterBag.parameterHolder.dataProviderHolder.annotation.isParallel()) {
                    objectArray = Lists.newArrayList();
                    while (object3.hasNext()) {
                        object2 = (Object[])object3.next();
                        if (object2 == null) {
                            ++n2;
                            continue;
                        }
                        list2 = this.injectParameters((Object[])object2, iTestNGMethod.getConstructorOrMethod().getMethod(), iTestContext, null);
                        TestMethodWithDataProviderMethodWorker testMethodWithDataProviderMethodWorker = new TestMethodWithDataProviderMethodWorker(this, iTestNGMethod, n2, (Object[])list2, object, xmlSuite, map2, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, expectedExceptionsHolder, iTestContext, this.m_skipFailedInvocationCounts, n, failureContext.count, this.m_notifier);
                        objectArray.add(testMethodWithDataProviderMethodWorker);
                        ++n2;
                    }
                    object2 = new PoolService(xmlSuite.getDataProviderThreadCount());
                    list2 = ((PoolService)object2).submitTasksAndWait(objectArray);
                    for (List list3 : list2) {
                        list.addAll(list3);
                    }
                    continue;
                }
                while (object3.hasNext()) {
                    boolean bl2;
                    block27: {
                        objectArray = (Object[])object3.next();
                        if (objectArray == null) {
                            ++n2;
                            continue;
                        }
                        object2 = this.injectParameters(objectArray, iTestNGMethod.getConstructorOrMethod().getMethod(), iTestContext, null);
                        list2 = Lists.newArrayList();
                        int n3 = -1;
                        try {
                            list2.add(this.invokeTestMethod(object, iTestNGMethod, (Object[])object2, n2, xmlSuite, map2, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, failureContext));
                            bl2 = false;
                            if (++n3 < 0) break block27;
                            boolean bl3 = bl2 = ((ITestResult)list2.get(n3)).getStatus() == 1;
                        }
                        catch (Throwable throwable) {
                            boolean bl4 = false;
                            if (n3 >= 0) {
                                boolean bl5 = bl4 = ((ITestResult)list2.get(n3)).getStatus() == 1;
                            }
                            if (failureContext.instances.isEmpty() || bl4) {
                                list.addAll(list2);
                            } else {
                                List<ITestResult> list4 = Lists.newArrayList();
                                failureContext.count = this.retryFailed(object, iTestNGMethod, xmlSuite, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, list4, failureContext.count, expectedExceptionsHolder, iTestContext, map2, n2);
                                list.addAll(list4);
                            }
                            if (failureContext.count > 0 && (this.m_skipFailedInvocationCounts || iTestNGMethod.skipFailedInvocations())) {
                                while (n-- > 0) {
                                    list.add(this.registerSkippedTestResult(iTestNGMethod, object, System.currentTimeMillis(), null));
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (failureContext.instances.isEmpty() || bl2) {
                        list.addAll(list2);
                    } else {
                        List<ITestResult> list5 = Lists.newArrayList();
                        failureContext.count = this.retryFailed(object, iTestNGMethod, xmlSuite, iTestClass, iTestNGMethodArray, iTestNGMethodArray2, configurationGroupMethods, list5, failureContext.count, expectedExceptionsHolder, iTestContext, map2, n2);
                        list.addAll(list5);
                    }
                    if (failureContext.count > 0 && (this.m_skipFailedInvocationCounts || iTestNGMethod.skipFailedInvocations())) {
                        while (n-- > 0) {
                            list.add(this.registerSkippedTestResult(iTestNGMethod, object, System.currentTimeMillis(), null));
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                object2 = new TestResult(iTestNGMethod.getTestClass(), object, iTestNGMethod, throwable, l2, System.currentTimeMillis(), this.m_testContext);
                object2.setStatus(2);
                list.add((ITestResult)object2);
                this.runTestListeners((ITestResult)object2);
                this.m_notifier.addFailedTest(iTestNGMethod, (ITestResult)object2);
            }
        }
        return list;
    }

    private ITestResult registerSkippedTestResult(ITestNGMethod iTestNGMethod, Object object, long l, Throwable throwable) {
        TestResult testResult = new TestResult(iTestNGMethod.getTestClass(), object, iTestNGMethod, throwable, l, System.currentTimeMillis(), this.m_testContext);
        testResult.setStatus(3);
        Reporter.setCurrentTestResult(testResult);
        this.runTestListeners(testResult);
        return testResult;
    }

    private Object[] injectParameters(Object[] objectArray, Method method, ITestContext iTestContext, ITestResult iTestResult) throws TestNGException {
        DataProviderMethodMatcher dataProviderMethodMatcher = new DataProviderMethodMatcher(new MethodMatcherContext(method, objectArray, iTestContext, iTestResult));
        return dataProviderMethodMatcher.getConformingArguments();
    }

    private ParameterBag handleParameters(ITestNGMethod iTestNGMethod, Object object, Map<String, String> map, Map<String, String> map2, Object[] objectArray, XmlSuite xmlSuite, ITestContext iTestContext, Object object2, ITestResult iTestResult) {
        try {
            return new ParameterBag(Parameters.handleParameters(iTestNGMethod, map, object, new Parameters.MethodParameters(map2, iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest()), objectArray, iTestNGMethod.getConstructorOrMethod().getMethod(), iTestContext, iTestResult), xmlSuite, this.m_annotationFinder, object2));
        }
        catch (Throwable throwable) {
            String string = Utils.longStackTrace(throwable.getCause() != null ? throwable.getCause() : throwable, true);
            if (Strings.isNotNullAndNotEmpty(string)) {
                Utils.error(string);
            }
            return new ParameterBag(new TestResult(iTestNGMethod.getTestClass(), object, iTestNGMethod, throwable, System.currentTimeMillis(), System.currentTimeMillis(), this.m_testContext));
        }
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod iTestNGMethod, XmlSuite xmlSuite, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, ITestContext iTestContext) {
        List<IWorker<ITestNGMethod>> list = Lists.newArrayList();
        for (int i = 0; i < iTestNGMethod.getInvocationCount(); ++i) {
            ITestNGMethod iTestNGMethod2 = iTestNGMethod.clone();
            iTestNGMethod2.setInvocationCount(1);
            iTestNGMethod2.setThreadPoolSize(1);
            MethodInstance methodInstance = new MethodInstance(iTestNGMethod2);
            list.add(new SingleTestMethodWorker(this, methodInstance, xmlSuite, map, iTestContext, this.m_classListeners));
        }
        return this.runWorkers(iTestNGMethod, list, iTestNGMethod.getThreadPoolSize(), configurationGroupMethods, xmlSuite, map);
    }

    void handleInvocationResults(ITestNGMethod iTestNGMethod, List<ITestResult> list, ExpectedExceptionsHolder expectedExceptionsHolder, FailureContext failureContext) {
        List<ITestResult> list2 = Lists.newArrayList();
        for (ITestResult iTestResult : list) {
            boolean bl;
            Object object;
            Throwable throwable = iTestResult.getThrowable();
            int n = iTestResult.getStatus();
            boolean bl2 = false;
            if (n == 2 && throwable != null) {
                if (expectedExceptionsHolder != null) {
                    if (expectedExceptionsHolder.isExpectedException(throwable)) {
                        iTestResult.setStatus(1);
                        n = 1;
                    } else if (this.isSkipExceptionAndSkip(throwable)) {
                        n = 3;
                    } else {
                        iTestResult.setThrowable(expectedExceptionsHolder.wrongException(throwable));
                        n = 2;
                    }
                } else {
                    this.handleException(throwable, iTestNGMethod, iTestResult, failureContext.count++);
                    bl2 = true;
                    n = iTestResult.getStatus();
                }
            } else if (n != 3 && expectedExceptionsHolder != null && (object = expectedExceptionsHolder.noException(iTestNGMethod)) != null) {
                iTestResult.setThrowable((Throwable)object);
                n = 2;
            }
            object = iTestNGMethod.getRetryAnalyzer();
            boolean bl3 = bl = object != null && n == 2 && failureContext.instances != null && object.retry(iTestResult);
            if (bl) {
                list2.add(iTestResult);
                ++failureContext.count;
                Object object2 = iTestResult.getInstance();
                if (!failureContext.instances.contains(object2)) {
                    failureContext.instances.add(object2);
                }
                iTestResult.setStatus(3);
                continue;
            }
            iTestResult.setStatus(n);
            if (n != 2 || bl2) continue;
            this.handleException(throwable, iTestNGMethod, iTestResult, failureContext.count++);
        }
        this.removeResultsToRetryFromResult(list2, list, failureContext);
    }

    private boolean isSkipExceptionAndSkip(Throwable throwable) {
        return SkipException.class.isAssignableFrom(throwable.getClass()) && ((SkipException)throwable).isSkip();
    }

    private void removeResultsToRetryFromResult(List<ITestResult> list, List<ITestResult> list2, FailureContext failureContext) {
        if (list != null) {
            for (ITestResult iTestResult : list) {
                list2.remove(iTestResult);
                --failureContext.count;
            }
        }
    }

    private List<ITestResult> runWorkers(ITestNGMethod iTestNGMethod, List<IWorker<ITestNGMethod>> list, int n, ConfigurationGroupMethods configurationGroupMethods, XmlSuite xmlSuite, Map<String, String> map) {
        Object[] objectArray;
        ITestClass iTestClass = iTestNGMethod.getTestClass();
        for (Object object : objectArray = iTestClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(iTestClass, iTestNGMethod, configurationGroupMethods, xmlSuite, map, object);
        }
        long l = -1L;
        for (IWorker<ITestNGMethod> iWorker : list) {
            long l2 = iWorker.getTimeOut();
            if (l2 <= l) continue;
            l = l2;
        }
        ThreadUtil.execute("methods", list, n, l, true);
        List list2 = Lists.newArrayList();
        for (IWorker<ITestNGMethod> iWorker : list) {
            if (!(iWorker instanceof TestMethodWorker)) continue;
            list2.addAll(((TestMethodWorker)iWorker).getTestResults());
        }
        for (Object object : objectArray) {
            this.invokeAfterGroupsConfigurations(iTestClass, iTestNGMethod, configurationGroupMethods, xmlSuite, map, object);
        }
        return list2;
    }

    private String checkDependencies(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        Object[] objectArray;
        if (iTestNGMethod.isAlwaysRun()) {
            return null;
        }
        if (iTestNGMethod.getMissingGroup() != null && !iTestNGMethod.ignoreMissingDependencies()) {
            return "Method " + iTestNGMethod + " depends on nonexistent group \"" + iTestNGMethod.getMissingGroup() + "\"";
        }
        String[] stringArray = iTestNGMethod.getGroupsDependedUpon();
        if (null != stringArray && stringArray.length > 0) {
            objectArray = stringArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, this.m_testContext.getAllTestMethods(), (String)object);
                if (iTestNGMethodArray2.length == 0 && !iTestNGMethod.ignoreMissingDependencies()) {
                    return "Method " + iTestNGMethod + " depends on nonexistent group \"" + (String)object + "\"";
                }
                if (this.haveBeenRunSuccessfully(iTestNGMethod, iTestNGMethodArray2)) continue;
                return "Method " + iTestNGMethod + " depends on not successfully finished methods in group \"" + (String)object + "\"";
            }
        }
        if (this.dependsOnMethods(iTestNGMethod) && !this.haveBeenRunSuccessfully(iTestNGMethod, (ITestNGMethod[])(objectArray = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray)))) {
            return "Method " + iTestNGMethod + " depends on not successfully finished methods";
        }
        return null;
    }

    private Set<ITestResult> keepSameInstances(ITestNGMethod iTestNGMethod, Set<ITestResult> set) {
        Set<ITestResult> set2 = Sets.newHashSet();
        for (ITestResult iTestResult : set) {
            Object object;
            Object object2 = iTestNGMethod.getInstance();
            Object object3 = object = iTestResult.getInstance() != null ? iTestResult.getInstance() : iTestResult.getMethod().getInstance();
            if (iTestResult.getTestClass() == iTestNGMethod.getTestClass() && object != object2) continue;
            set2.add(iTestResult);
        }
        return set2;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            Set<ITestResult> set = this.keepSameInstances(iTestNGMethod, this.m_notifier.getPassedTests(iTestNGMethod2));
            Set<ITestResult> set2 = Sets.newHashSet();
            set2.addAll(this.m_notifier.getFailedTests(iTestNGMethod2));
            set2.addAll(this.m_notifier.getSkippedTests(iTestNGMethod2));
            Set<ITestResult> set3 = this.keepSameInstances(iTestNGMethod, set2);
            if (set3 != null && set3.size() > 0) {
                return false;
            }
            for (ITestResult iTestResult : set) {
                if (iTestResult.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod iTestNGMethod, ITestResult iTestResult, int n) {
        int n2;
        int n3;
        float f;
        if (throwable != null) {
            iTestResult.setThrowable(throwable);
        }
        if ((float)n < (f = (float)((100 - (n3 = iTestNGMethod.getSuccessPercentage())) * (n2 = iTestNGMethod.getInvocationCount())) / 100.0f)) {
            iTestResult.setStatus(4);
        } else {
            iTestResult.setStatus(2);
        }
    }

    private ITestNGMethod[] filterMethods(IClass iClass, ITestNGMethod[] iTestNGMethodArray, Predicate<ITestNGMethod, IClass> predicate) {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            if (predicate.isTrue(iTestNGMethod, iClass) && !TestNgMethodUtils.containsConfigurationMethod(iTestNGMethod, list)) {
                this.log(10, "Keeping method " + iTestNGMethod + " for class " + iClass);
                list.add(iTestNGMethod);
                continue;
            }
            this.log(10, "Filtering out method " + iTestNGMethod + " for class " + iClass);
        }
        ITestNGMethod[] iTestNGMethodArray2 = list.toArray(new ITestNGMethod[list.size()]);
        return iTestNGMethodArray2;
    }

    private boolean dependsOnMethods(ITestNGMethod iTestNGMethod) {
        String[] stringArray = iTestNGMethod.getMethodsDependedUpon();
        return null != stringArray && stringArray.length > 0;
    }

    private void runConfigurationListeners(ITestResult iTestResult, boolean bl) {
        if (bl) {
            for (IConfigurationListener iConfigurationListener : this.m_notifier.getConfigurationListeners()) {
                if (!(iConfigurationListener instanceof IConfigurationListener2)) continue;
                ((IConfigurationListener2)iConfigurationListener).beforeConfiguration(iTestResult);
            }
        } else {
            block6: for (IConfigurationListener iConfigurationListener : this.m_notifier.getConfigurationListeners()) {
                switch (iTestResult.getStatus()) {
                    case 3: {
                        iConfigurationListener.onConfigurationSkip(iTestResult);
                        continue block6;
                    }
                    case 2: {
                        iConfigurationListener.onConfigurationFailure(iTestResult);
                        continue block6;
                    }
                    case 1: {
                        iConfigurationListener.onConfigurationSuccess(iTestResult);
                        continue block6;
                    }
                }
                throw new AssertionError((Object)("Unexpected value: " + iTestResult.getStatus()));
            }
        }
    }

    void runTestListeners(ITestResult iTestResult) {
        Invoker.runTestListeners(iTestResult, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult iTestResult, List<ITestListener> list) {
        block9: for (ITestListener iTestListener : list) {
            try {
                switch (iTestResult.getStatus()) {
                    case 3: {
                        iTestListener.onTestSkipped(iTestResult);
                        break;
                    }
                    case 4: {
                        iTestListener.onTestFailedButWithinSuccessPercentage(iTestResult);
                        break;
                    }
                    case 2: {
                        iTestListener.onTestFailure(iTestResult);
                        break;
                    }
                    case 1: {
                        iTestListener.onTestSuccess(iTestResult);
                        break;
                    }
                    case 16: {
                        iTestListener.onTestStart(iTestResult);
                        break;
                    }
                    default: {
                        assert (false) : "UNKNOWN STATUS:" + iTestResult;
                        continue block9;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void log(int n, String string) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), n, string);
    }

    private static class ParameterBag {
        final ParameterHolder parameterHolder;
        final ITestResult errorResult;

        public ParameterBag(ParameterHolder parameterHolder) {
            this.parameterHolder = parameterHolder;
            this.errorResult = null;
        }

        public ParameterBag(ITestResult iTestResult) {
            this.parameterHolder = null;
            this.errorResult = iTestResult;
        }

        public boolean hasErrors() {
            return this.errorResult != null;
        }
    }

    static class SameClassNamePredicate
    implements Predicate<ITestNGMethod, IClass> {
        SameClassNamePredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod iTestNGMethod, IClass iClass) {
            return iClass == null || iTestNGMethod.getTestClass().getName().equals(iClass.getName());
        }
    }

    static class CanRunFromClassPredicate
    implements Predicate<ITestNGMethod, IClass> {
        CanRunFromClassPredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod iTestNGMethod, IClass iClass) {
            return iTestNGMethod.canRunFromClass(iClass);
        }
    }

    static interface Predicate<K, T> {
        public boolean isTrue(K var1, T var2);
    }

    static class FailureContext {
        int count = 0;
        List<Object> instances = Lists.newArrayList();

        FailureContext() {
        }
    }
}

