/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IAttributes;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class SuiteRunner
implements ISuite,
Serializable,
IInvokedMethodListener {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> suiteResults = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private transient List<TestRunner> testRunners = Lists.newArrayList();
    private transient Map<Class<? extends ISuiteListener>, ISuiteListener> listeners = Maps.newHashMap();
    private transient TestListenerAdapter textReporter = new TestListenerAdapter();
    private String outputDir;
    private XmlSuite xmlSuite;
    private transient Injector parentInjector;
    private transient List<ITestListener> testListeners = Lists.newArrayList();
    private final transient Map<Class<? extends IClassListener>, IClassListener> classListeners = Maps.newHashMap();
    private transient ITestRunnerFactory tmpRunnerFactory;
    private transient ITestRunnerFactory runnerFactory;
    private transient boolean useDefaultListeners = true;
    private String remoteHost;
    private transient IConfiguration configuration;
    private transient ITestObjectFactory objectFactory;
    private transient Boolean skipFailedInvocationCounts = Boolean.FALSE;
    private transient List<IReporter> reporters = Lists.newArrayList();
    private transient Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> invokedMethodListeners;
    private transient List<IInvokedMethod> invokedMethods = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestNGMethod> allTestMethods = Lists.newArrayList();
    private SuiteRunState suiteState = new SuiteRunState();
    private IAttributes attributes = new Attributes();

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string) {
        this(iConfiguration, xmlSuite, string, null);
    }

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, false);
    }

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, (List<IMethodInterceptor>)new ArrayList<IMethodInterceptor>(), (List<IInvokedMethodListener>)null, (List<ITestListener>)null, (List<IClassListener>)null);
    }

    @Deprecated
    protected SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, List<IInvokedMethodListener> list2, List<ITestListener> list3, List<IClassListener> list4) {
        this.init(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, list, list2, list3, list4);
    }

    protected SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3) {
        this.init(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, list, collection, collection2, collection3);
    }

    private void init(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> arrayList, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3) {
        this.configuration = iConfiguration;
        this.xmlSuite = xmlSuite;
        this.useDefaultListeners = bl;
        this.tmpRunnerFactory = iTestRunnerFactory;
        ArrayList arrayList2 = arrayList != null ? arrayList : new ArrayList();
        this.setOutputDir(string);
        this.objectFactory = this.configuration.getObjectFactory();
        if (this.objectFactory == null) {
            this.objectFactory = xmlSuite.getObjectFactory();
        }
        this.invokedMethodListeners = Maps.newHashMap();
        if (collection != null) {
            for (IInvokedMethodListener object2 : collection) {
                this.invokedMethodListeners.put(object2.getClass(), object2);
            }
        }
        this.invokedMethodListeners.put(this.getClass(), this);
        this.skipFailedInvocationCounts = xmlSuite.skipFailedInvocationCounts();
        if (null != collection2) {
            this.testListeners.addAll(collection2);
        }
        if (null != collection3) {
            for (IClassListener iClassListener : collection3) {
                this.classListeners.put(iClassListener.getClass(), iClassListener);
            }
        }
        this.runnerFactory = this.buildRunnerFactory();
        List<XmlTest> list = this.xmlSuite.getTests();
        Collections.sort(list, new Comparator<XmlTest>(){

            @Override
            public int compare(XmlTest xmlTest, XmlTest xmlTest2) {
                return xmlTest.getIndex() - xmlTest2.getIndex();
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XmlTest xmlTest = (XmlTest)iterator.next();
            TestRunner testRunner = this.runnerFactory.newTestRunner(this, xmlTest, this.invokedMethodListeners.values(), Lists.newArrayList(this.classListeners.values()));
            for (IMethodInterceptor iMethodInterceptor : arrayList2) {
                testRunner.addMethodInterceptor(iMethodInterceptor);
            }
            testRunner.addListener(this.textReporter);
            this.testRunners.add(testRunner);
            this.allTestMethods.addAll(Arrays.asList(testRunner.getAllTestMethods()));
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.xmlSuite;
    }

    @Override
    public String getName() {
        return this.xmlSuite.getName();
    }

    public void setObjectFactory(ITestObjectFactory iTestObjectFactory) {
        this.objectFactory = iTestObjectFactory;
    }

    public void setReportResults(boolean bl) {
        this.useDefaultListeners = bl;
    }

    private void invokeListeners(boolean bl) {
        for (ISuiteListener iSuiteListener : this.listeners.values()) {
            if (bl) {
                iSuiteListener.onStart(this);
                continue;
            }
            iSuiteListener.onFinish(this);
        }
    }

    private void setOutputDir(String string) {
        if (Utils.isStringBlank(string) && this.useDefaultListeners) {
            string = DEFAULT_OUTPUT_DIR;
        }
        this.outputDir = null != string ? new File(string).getAbsolutePath() : null;
    }

    private ITestRunnerFactory buildRunnerFactory() {
        ITestRunnerFactory iTestRunnerFactory = null == this.tmpRunnerFactory ? new DefaultTestRunnerFactory(this.configuration, this.testListeners.toArray(new ITestListener[this.testListeners.size()]), this.useDefaultListeners, this.skipFailedInvocationCounts) : new ProxyTestRunnerFactory(this.testListeners.toArray(new ITestListener[this.testListeners.size()]), this.tmpRunnerFactory);
        return iTestRunnerFactory;
    }

    @Override
    public String getParallel() {
        return this.xmlSuite.getParallel().toString();
    }

    @Override
    public String getParentModule() {
        return this.xmlSuite.getParentModule();
    }

    @Override
    public String getGuiceStage() {
        return this.xmlSuite.getGuiceStage();
    }

    @Override
    public Injector getParentInjector() {
        return this.parentInjector;
    }

    @Override
    public void setParentInjector(Injector injector) {
        this.parentInjector = injector;
    }

    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
        }
        finally {
            this.invokeListeners(false);
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap2 = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker iInvoker = null;
        for (TestRunner testRunner : this.testRunners) {
            iInvoker = testRunner.getInvoker();
            for (ITestNGMethod iTestNGMethod : testRunner.getBeforeSuiteMethods()) {
                linkedHashMap.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
            for (ITestNGMethod iTestNGMethod : testRunner.getAfterSuiteMethods()) {
                linkedHashMap2.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
        }
        if (iInvoker != null) {
            if (!linkedHashMap.values().isEmpty()) {
                iInvoker.invokeConfigurations(null, linkedHashMap.values().toArray(new ITestNGMethod[linkedHashMap.size()]), this.xmlSuite, this.xmlSuite.getParameters(), null, null);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.testRunners.size() + " TestRunners");
            boolean bl = XmlSuite.ParallelMode.TESTS.equals((Object)this.xmlSuite.getParallel());
            if (!bl) {
                this.runSequentially();
            } else {
                this.runInParallelTestMode();
            }
            if (!linkedHashMap2.values().isEmpty()) {
                iInvoker.invokeConfigurations(null, linkedHashMap2.values().toArray(new ITestNGMethod[linkedHashMap2.size()]), this.xmlSuite, this.xmlSuite.getAllParameters(), null, null);
            }
        }
    }

    private void addReporter(IReporter iReporter) {
        this.reporters.add(iReporter);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.configuration.addConfigurationListener(iConfigurationListener);
    }

    public List<IReporter> getReporters() {
        return this.reporters;
    }

    private void runSequentially() {
        for (TestRunner testRunner : this.testRunners) {
            this.runTest(testRunner);
        }
    }

    private void runTest(TestRunner testRunner) {
        testRunner.run();
        SuiteResult suiteResult = new SuiteResult(this.xmlSuite, testRunner);
        this.suiteResults.put(testRunner.getName(), suiteResult);
    }

    private void runInParallelTestMode() {
        List list = Lists.newArrayList(this.testRunners.size());
        for (TestRunner testRunner : this.testRunners) {
            list.add(new SuiteWorker(testRunner));
        }
        ThreadUtil.execute("tests", list, this.xmlSuite.getThreadCount(), this.xmlSuite.getTimeOut(Integer.MAX_VALUE), false);
    }

    protected void addListener(ISuiteListener iSuiteListener) {
        if (!this.listeners.containsKey(iSuiteListener.getClass())) {
            this.listeners.put(iSuiteListener.getClass(), iSuiteListener);
        }
    }

    @Override
    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IInvokedMethodListener) {
            iTestNGListener2 = (IInvokedMethodListener)iTestNGListener;
            this.invokedMethodListeners.put(iTestNGListener2.getClass(), (IInvokedMethodListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IReporter) {
            this.addReporter((IReporter)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.classListeners.put(iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.suiteResults;
    }

    @Override
    public String getParameter(String string) {
        return this.xmlSuite.getParameter(string);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map<String, Collection<ITestNGMethod>> map = Maps.newHashMap();
        for (TestRunner testRunner : this.testRunners) {
            ITestNGMethod[] iTestNGMethodArray;
            for (ITestNGMethod iTestNGMethod : iTestNGMethodArray = testRunner.getAllTestMethods()) {
                String[] stringArray;
                for (String string : stringArray = iTestNGMethod.getGroups()) {
                    Collection<ITestNGMethod> collection = map.get(string);
                    if (null == collection) {
                        collection = Lists.newArrayList();
                        map.put(string, collection);
                    }
                    collection.add(iTestNGMethod);
                }
            }
        }
        return map;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean bl) {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (TestRunner testRunner : this.testRunners) {
            Collection<ITestNGMethod> collection = bl ? testRunner.getInvokedMethods() : testRunner.getExcludedMethods();
            for (ITestNGMethod iTestNGMethod : collection) {
                list.add(iTestNGMethod);
            }
        }
        return list;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.objectFactory instanceof IObjectFactory ? (IObjectFactory)this.objectFactory : null;
    }

    @Override
    public IObjectFactory2 getObjectFactory2() {
        return this.objectFactory instanceof IObjectFactory2 ? (IObjectFactory2)this.objectFactory : null;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.configuration.getAnnotationFinder();
    }

    public static void ppp(String string) {
        System.out.println("[SuiteRunner] " + string);
    }

    public void setHost(String string) {
        this.remoteHost = string;
    }

    @Override
    public String getHost() {
        return this.remoteHost;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean bl) {
        if (bl != null) {
            this.skipFailedInvocationCounts = bl;
        }
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.attributes.removeAttribute(string);
    }

    @Override
    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (iInvokedMethod == null) {
            throw new NullPointerException("Method should not be null");
        }
        this.invokedMethods.add(iInvokedMethod);
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return this.invokedMethods;
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.allTestMethods;
    }

    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] failureGenerators;
        private ITestRunnerFactory target;

        public ProxyTestRunnerFactory(ITestListener[] iTestListenerArray, ITestRunnerFactory iTestRunnerFactory) {
            this.failureGenerators = iTestListenerArray;
            this.target = iTestRunnerFactory;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            TestRunner testRunner = this.target.newTestRunner(iSuite, xmlTest, collection, list);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener iTestListener : this.failureGenerators) {
                testRunner.addListener(iTestListener);
            }
            return testRunner;
        }
    }

    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] failureGenerators;
        private boolean useDefaultListeners;
        private boolean skipFailedInvocationCounts;
        private IConfiguration configuration;

        public DefaultTestRunnerFactory(IConfiguration iConfiguration, ITestListener[] iTestListenerArray, boolean bl, boolean bl2) {
            this.configuration = iConfiguration;
            this.failureGenerators = iTestListenerArray;
            this.useDefaultListeners = bl;
            this.skipFailedInvocationCounts = bl2;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            boolean bl = this.skipFailedInvocationCounts;
            if (!bl) {
                bl = xmlTest.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.configuration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
            if (this.useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener iTestListener : this.failureGenerators) {
                testRunner.addTestListener(iTestListener);
            }
            for (IConfigurationListener iConfigurationListener : this.configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(iConfigurationListener);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner testRunner;

        public SuiteWorker(TestRunner testRunner) {
            this.testRunner = testRunner;
        }

        @Override
        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.testRunner);
        }
    }
}

