/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.XmlMethodSelector;

public class ClassMethodMap {
    private Map<Object, List<ITestNGMethod>> classMap = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> beforeClassMethods = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> afterClassMethods = Maps.newHashMap();

    public ClassMethodMap(List<ITestNGMethod> list, XmlMethodSelector xmlMethodSelector) {
        for (ITestNGMethod iTestNGMethod : list) {
            if (xmlMethodSelector != null && !xmlMethodSelector.includeMethod(null, iTestNGMethod, true)) continue;
            Object object = iTestNGMethod.getInstance();
            List<ITestNGMethod> list2 = this.classMap.get(object);
            if (list2 == null) {
                list2 = Lists.newArrayList();
                this.classMap.put(object, list2);
            }
            list2.add(iTestNGMethod);
        }
    }

    public synchronized boolean removeAndCheckIfLast(ITestNGMethod iTestNGMethod, Object object) {
        List<ITestNGMethod> list = this.classMap.get(object);
        if (list == null) {
            throw new AssertionError((Object)"l should not be null");
        }
        list.remove(iTestNGMethod);
        for (ITestNGMethod iTestNGMethod2 : list) {
            if (!iTestNGMethod2.getEnabled() || !iTestNGMethod2.getTestClass().equals(iTestNGMethod.getTestClass())) continue;
            return false;
        }
        return true;
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.afterClassMethods;
    }

    public void clear() {
        for (Set<Object> set : this.beforeClassMethods.values()) {
            set.clear();
        }
        for (Set<Object> set : this.afterClassMethods.values()) {
            set.clear();
        }
        this.beforeClassMethods.clear();
        this.afterClassMethods.clear();
    }
}

