/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.setting;

import com.atlassian.jira.rest.client.api.domain.User;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.jira.JiraAPIURL;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.entity.JiraIssueType;
import com.kms.katalon.integration.jira.entity.JiraProject;
import com.kms.katalon.integration.jira.setting.StoredJiraObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.GeneralSecurityException;

public class JiraIntegrationSettingStore
extends BundleSettingStore {
    public JiraIntegrationSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.integration.jira", false);
    }

    public boolean isIntegrationEnabled() throws IOException {
        return this.getBoolean("integration.enabled", false);
    }

    public void enableIntegration(boolean enabled) throws IOException {
        this.setProperty("integration.enabled", enabled);
    }

    public String getUsername(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("auth.username", "", encryptionEnabled);
    }

    public void saveUsername(String username, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("auth.username", username, encryptionEnabled);
    }

    public String getPassword(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("auth.password", "", encryptionEnabled);
    }

    public void savePassword(String rawPassword, boolean encryptEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("auth.password", rawPassword, encryptEnabled);
    }

    public boolean isEncryptionEnabled() throws IOException {
        return this.getBoolean("auth.encryptionEnabled", false);
    }

    public void enableEncryption(boolean enabled) throws IOException {
        this.setProperty("auth.encryptionEnabled", enabled);
    }

    public String getServerUrl(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        String decryptedServerUrl = this.getStringProperty("auth.serverUrl", "", encryptionEnabled);
        return JiraAPIURL.removeLastSplash(decryptedServerUrl);
    }

    public void saveServerUrl(String serverUrl, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("auth.serverUrl", serverUrl, encryptionEnabled);
    }

    public boolean isUseTestCaseNameAsSummaryEnabled() throws IOException {
        return this.getBoolean("submit.useTestCaseNameAsSummary", true);
    }

    public void enableUseTestCaseNameAsSummary(boolean enabled) throws IOException {
        this.setProperty("submit.useTestCaseNameAsSummary", enabled);
    }

    public boolean isAttachScreenshotEnabled() throws IOException {
        return this.getBoolean("submit.attachScreenshot", true);
    }

    public void enableAttachScreenshot(boolean enabled) throws IOException {
        this.setProperty("submit.attachScreenshot", enabled);
    }

    public boolean isSubmitTestResultAutomatically() throws IOException {
        return this.getBoolean("submit.submitTestResultAutomatically", true);
    }

    public void enableSubmitTestResultAutomatically(boolean enabled) throws IOException {
        this.setProperty("submit.submitTestResultAutomatically", enabled);
    }

    public boolean isAttachLogEnabled() throws IOException {
        return this.getBoolean("submit.attachLog", true);
    }

    public void enableAttachLog(boolean enabled) throws IOException {
        this.setProperty("submit.attachLog", enabled);
    }

    public StoredJiraObject<JiraProject> getStoredJiraProject() throws IOException {
        StoredJiraObject instance = new StoredJiraObject(null, null);
        String objectAsString = this.getString("submit.jiraProject", "");
        try {
            Type collectionType = new TypeToken<StoredJiraObject<JiraProject>>(){}.getType();
            StoredJiraObject storedObject = (StoredJiraObject)JsonUtil.fromJson((String)objectAsString, (Type)collectionType);
            return storedObject != null ? storedObject : instance;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return instance;
        }
    }

    public void saveStoredJiraProject(StoredJiraObject<JiraProject> storedJiraProject) throws IOException {
        this.setProperty("submit.jiraProject", JsonUtil.toJson(storedJiraProject, (boolean)false));
    }

    public StoredJiraObject<JiraIssueType> getStoredJiraIssueType() throws IOException {
        StoredJiraObject instance = new StoredJiraObject(null, null);
        String objectAsString = this.getString("submit.jiraIssueType", "");
        try {
            Type collectionType = new TypeToken<StoredJiraObject<JiraIssueType>>(){}.getType();
            StoredJiraObject storedObject = (StoredJiraObject)JsonUtil.fromJson((String)objectAsString, (Type)collectionType);
            return storedObject != null ? storedObject : instance;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return instance;
        }
    }

    public void saveStoredJiraIssueType(StoredJiraObject<JiraIssueType> storedJiraIssueType) throws IOException {
        this.setProperty("submit.jiraIssueType", JsonUtil.toJson(storedJiraIssueType, (boolean)false));
    }

    public User getJiraUser() throws IOException {
        return (User)JsonUtil.fromJson((String)this.getString("auth.user", ""), User.class);
    }

    public void saveJiraUser(User user) throws IOException {
        this.setProperty("auth.user", JsonUtil.toJson((Object)user, (boolean)false));
    }

    public JiraCredential getJiraCredential() throws IOException, GeneralSecurityException {
        JiraCredential credential = new JiraCredential();
        boolean authenticationEncrypted = this.isEncryptionEnabled();
        credential.setServerUrl(this.getServerUrl(authenticationEncrypted));
        credential.setUsername(this.getUsername(authenticationEncrypted));
        credential.setPassword(this.getPassword(authenticationEncrypted));
        return credential;
    }
}

