/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.JiraInvalidURLException;
import com.kms.katalon.integration.jira.constant.JiraIntegrationMessageConstants;
import com.kms.katalon.integration.jira.entity.ImprovedIssue;
import com.kms.katalon.integration.jira.util.ImprovedIssueDeserializer;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;

public class JiraIntegrationRequest {
    public String getJiraResponse(JiraCredential credential, String url) throws JiraIntegrationException {
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (CloseableHttpClient client = HttpClientBuilder.create().setSSLContext(this.getTrustedSSLContext()).build();){
                HttpGet request = new HttpGet(url);
                this.addAuthenticationHeader(credential, (HttpRequestBase)request);
                request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                return this.getResultFromRequest(client, (HttpRequestBase)request);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JiraInvalidURLException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
        }
        catch (GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        catch (JiraIntegrationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JiraIntegrationException(e);
        }
        return null;
    }

    protected <T> T getJiraObject(JiraCredential credential, String url, Class<T> clazz) throws JiraIntegrationException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ImprovedIssue.class, (Object)new ImprovedIssueDeserializer()).create();
        return (T)gson.fromJson(this.getJiraResponse(credential, url), clazz);
    }

    public void sendPutRequest(JiraCredential credential, String url, String content) throws JiraIntegrationException {
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (CloseableHttpClient httpClient = this.getClientBuilder();){
                HttpPut put = new HttpPut(url);
                this.addAuthenticationHeader(credential, (HttpRequestBase)put);
                put.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                put.setEntity((HttpEntity)new StringEntity(content));
                this.getResultFromRequest(httpClient, (HttpRequestBase)put);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JiraInvalidURLException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
        }
        catch (GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        catch (JiraIntegrationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JiraIntegrationException(e);
        }
    }

    public void sendPostRequest(JiraCredential credential, String url, String content) throws JiraIntegrationException {
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (CloseableHttpClient httpClient = this.getClientBuilder();){
                HttpPost post = new HttpPost(url);
                this.addAuthenticationHeader(credential, (HttpRequestBase)post);
                post.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                post.setEntity((HttpEntity)new StringEntity(content));
                this.getResultFromRequest(httpClient, (HttpRequestBase)post);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JiraInvalidURLException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
        }
        catch (GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        catch (JiraIntegrationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JiraIntegrationException(e);
        }
    }

    public String sendUploadRequest(JiraCredential credential, String url, String filePath) throws JiraIntegrationException {
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (CloseableHttpClient httpClient = this.getClientBuilder();){
                HttpPost post = new HttpPost(url);
                this.addAuthenticationHeader(credential, (HttpRequestBase)post);
                HttpEntity fileEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)new FileBody(new File(filePath))).build();
                post.setEntity(fileEntity);
                return this.getResultFromRequest(httpClient, (HttpRequestBase)post);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JiraInvalidURLException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
        }
        catch (GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        catch (JiraIntegrationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JiraIntegrationException(e);
        }
        return "";
    }

    protected <T> T[] getJiraArrayObjects(JiraCredential credential, String url, Class<T[]> clazz) throws JiraIntegrationException {
        T[] result = this.getJiraObject(credential, url, clazz);
        return result != null ? result : clazz.cast(Array.newInstance(clazz.getComponentType(), 0));
    }

    protected CloseableHttpClient getClientBuilder() throws GeneralSecurityException {
        return HttpClientBuilder.create().setSSLContext(this.getTrustedSSLContext()).build();
    }

    protected void addAuthenticationHeader(JiraCredential credential, HttpRequestBase request) {
        String authEncoded = new Base64().encodeAsString((String.valueOf(credential.getUsername()) + ":" + credential.getPassword()).getBytes());
        request.setHeader("Authorization", "Basic " + authEncoded);
        request.setHeader("X-Atlassian-Token", "no-check");
    }

    protected String getBodyString(CloseableHttpResponse response) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    protected SSLContext getTrustedSSLContext() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        }).build();
        return sslContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResultFromRequest(CloseableHttpClient client, HttpRequestBase request) throws JiraIntegrationException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 201: 
                    case 202: 
                    case 204: {
                        return "";
                    }
                    case 200: {
                        return this.getBodyString(response);
                    }
                    case 401: {
                        throw new JiraIntegrationException(JiraIntegrationMessageConstants.MSG_INVALID_ACCOUNT);
                    }
                    case 403: {
                        throw new JiraIntegrationException(MessageFormat.format(JiraIntegrationMessageConstants.MSG_INVALID_PERMISSION, this.getBodyString(response)));
                    }
                    case 404: {
                        throw new JiraInvalidURLException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
                    }
                }
                throw new JiraIntegrationException(MessageFormat.format(JiraIntegrationMessageConstants.MSG_INVALID_REQUEST, request.getURI().toString()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new JiraIntegrationException(JiraIntegrationMessageConstants.MSG_INVALID_SERVER_URL);
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new JiraIntegrationException(MessageFormat.format(JiraIntegrationMessageConstants.MSG_INVALID_REQUEST, request.getURI().toString()));
        }
        catch (IOException ex) {
            throw new JiraIntegrationException(ex);
        }
    }
}

