/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.report;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.integration.jira.JiraComponent;
import com.kms.katalon.integration.jira.JiraIntegrationAuthenticationHandler;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.JiraObjectToEntityConverter;
import com.kms.katalon.integration.jira.entity.JiraAttachment;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.entity.JiraTestResult;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

public class JiraReportService
implements JiraComponent {
    public void uploadTestCaseLog(TestCaseLogRecord logRecord, JiraIssue issue) throws IOException, JiraIntegrationException {
        TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)logRecord.getParentLogRecord();
        String logFolder = testSuiteLogRecord.getLogFolder();
        JiraIntegrationAuthenticationHandler handler = new JiraIntegrationAuthenticationHandler();
        ArrayList<JiraAttachment> jiraAttachments = new ArrayList<JiraAttachment>();
        if (this.getSettingStore().isAttachScreenshotEnabled()) {
            String[] stringArray = logRecord.getAttachments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String screenshot = stringArray[n2];
                jiraAttachments.addAll(handler.uploadAttachment(this.getCredential(), issue, PathUtil.relativeToAbsolutePath((String)screenshot, (String)logFolder)));
                ++n2;
            }
        }
        if (this.getSettingStore().isAttachLogEnabled()) {
            for (String logFile : testSuiteLogRecord.getLogFiles()) {
                jiraAttachments.addAll(handler.uploadAttachment(this.getCredential(), issue, PathUtil.relativeToAbsolutePath((String)logFile, (String)logFolder)));
            }
        }
    }

    public void uploadTestCaseReport(TestCaseLogRecord logRecord, JiraIssue issue, File zipFile) throws IOException, JiraIntegrationException {
        JiraIntegrationAuthenticationHandler handler = new JiraIntegrationAuthenticationHandler();
        ArrayList<JiraAttachment> jiraAttachments = new ArrayList<JiraAttachment>();
        jiraAttachments.addAll(handler.uploadAttachment(this.getCredential(), issue, zipFile.getAbsolutePath()));
        List<Long> jiraAttachmentIds = jiraAttachments.stream().map(attachment -> attachment.getId()).collect(Collectors.toList());
        String testStatus = logRecord.getStatus().getStatusValue().name();
        JiraTestResult testResult = JiraTestResult.from(testStatus, ArrayUtils.toPrimitive((Long[])jiraAttachmentIds.toArray(new Long[jiraAttachmentIds.size()])));
        handler.sendKatalonIntegrationProperty(this.getCredential(), issue, testResult);
    }

    public File zipReportFolder(final File folderToZip) throws ZipException, IOException {
        File filteredTempFolder = new File(this.getJiraZipTempFolder(), folderToZip.getName());
        FileUtils.copyDirectory((File)folderToZip, (File)filteredTempFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getAbsolutePath().startsWith(new File(folderToZip, "videos").getAbsolutePath());
            }
        });
        File zipTempFile = new File(this.getJiraZipTempFolder(), String.valueOf(folderToZip.getName()) + ".zip");
        if (zipTempFile.exists()) {
            FileUtils.deleteQuietly((File)zipTempFile);
        }
        ZipFile returnedZipFile = new ZipFile(zipTempFile);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        returnedZipFile.addFolder(filteredTempFolder.getAbsolutePath(), parameters);
        FileUtils.deleteDirectory((File)filteredTempFolder);
        return zipTempFile;
    }

    private File getJiraZipTempFolder() {
        File zipTempFolder = new File(ProjectController.getInstance().getTempDir(), "zip/com.kms.katalon.integration.jira");
        if (!zipTempFolder.exists()) {
            zipTempFolder.mkdirs();
        }
        return zipTempFolder;
    }

    public void linkIssues(TestCaseLogRecord logRecord, JiraIssue inwardIssue) throws JiraIntegrationException, IOException {
        JiraIssue outwardIssue = null;
        try {
            outwardIssue = JiraObjectToEntityConverter.getJiraIssue(TestCaseController.getInstance().getTestCaseByDisplayId(logRecord.getId()));
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        if (outwardIssue == null) {
            return;
        }
        JiraIntegrationAuthenticationHandler handler = new JiraIntegrationAuthenticationHandler();
        handler.linkJiraIssues(this.getCredential(), inwardIssue, outwardIssue);
    }
}

