/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.report;

import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.integration.jira.JiraComponent;
import com.kms.katalon.integration.jira.JiraObjectToEntityConverter;
import com.kms.katalon.integration.jira.constant.JiraIntegrationMessageConstants;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.report.JiraReportService;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class JiraReportIntegration
implements ReportIntegrationContribution,
JiraComponent {
    private JiraReportService reportService = new JiraReportService();

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Collections.emptyList();
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        try {
            return !this.isJiraPluginEnabled() && this.getSettingStore().isIntegrationEnabled() && this.getSettingStore().isSubmitTestResultAutomatically();
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void uploadTestSuiteResult(TestSuiteEntity testSuite, TestSuiteLogRecord suiteLog) throws Exception {
        LogUtil.printOutputLine((String)JiraIntegrationMessageConstants.MSG_SEND_TEST_RESULT);
        ILogRecord[] childRecords = suiteLog.getChildRecords();
        File reportZipFile = null;
        int index = 0;
        while (index < childRecords.length) {
            ILogRecord child = childRecords[index];
            if (child instanceof TestCaseLogRecord) {
                TestCaseLogRecord logRecord = (TestCaseLogRecord)child;
                try {
                    JiraIssue issue = JiraObjectToEntityConverter.getJiraIssue(TestCaseController.getInstance().getTestCaseByDisplayId(logRecord.getId()));
                    if (issue != null) {
                        if (reportZipFile == null || !reportZipFile.exists()) {
                            reportZipFile = this.reportService.zipReportFolder(new File(suiteLog.getLogFolder()));
                        }
                        this.reportService.uploadTestCaseReport(logRecord, issue, reportZipFile);
                        LogUtil.printOutputLine((String)MessageFormat.format(JiraIntegrationMessageConstants.MSG_SEND_TEST_RESULT_SENT, issue.getKey()));
                    }
                }
                catch (Exception e) {
                    LogUtil.printAndLogError((Throwable)e);
                }
            }
            ++index;
        }
        if (reportZipFile != null && reportZipFile.exists()) {
            FileUtils.deleteQuietly((File)reportZipFile);
        }
    }
}

