/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.issue;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.integration.jira.constant.JiraIntegrationMessageConstants;
import com.kms.katalon.integration.jira.entity.JiraEdittingIssue;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IssueMetaDataProvider {
    protected TestCaseLogRecord logRecord;
    private int endStepIndex;

    public IssueMetaDataProvider(TestCaseLogRecord logRecord) {
        this(logRecord, logRecord.getChildRecords().length);
    }

    public IssueMetaDataProvider(TestCaseLogRecord logRecord, int endStepIndex) {
        this.logRecord = logRecord;
        this.endStepIndex = endStepIndex;
    }

    public String getDescription() {
        return String.valueOf(this.getStepDescription()) + this.getErrorMessage();
    }

    private String getStepDescription() {
        StringBuilder builder = new StringBuilder();
        if (this.endStepIndex > 0) {
            builder.append(String.valueOf(JiraIntegrationMessageConstants.MSG_TEST_STEPS) + "\n");
            ILogRecord[] childRecords = this.logRecord.getChildRecords();
            int i = 0;
            while (i < this.endStepIndex) {
                ILogRecord stepRecord = childRecords[i];
                builder.append(Integer.toString(i + 1)).append(". ").append(StringUtils.defaultString((String)stepRecord.getName())).append("\n");
                ++i;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private String getErrorMessage() {
        if (!this.logRecord.getStatus().getStatusValue().isError()) {
            return "";
        }
        String message = this.logRecord.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        return MessageFormat.format(JiraIntegrationMessageConstants.MSG_ERROR_LOG, message);
    }

    public String getSummary() {
        String testCaseId = this.logRecord.getName();
        return testCaseId.substring(testCaseId.lastIndexOf("/") + 1, testCaseId.length());
    }

    public String getEnvironment() {
        StringBuilder builder = new StringBuilder();
        TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)this.logRecord.getParentLogRecord();
        for (Map.Entry runDataEntry : testSuiteLogRecord.getRunData().entrySet()) {
            builder.append("- ").append((String)runDataEntry.getKey()).append(": ").append((String)runDataEntry.getValue()).append("\n");
        }
        return builder.toString();
    }

    public JiraEdittingIssue toEdittingIssue(JiraIssue jiraIssue) {
        return new JiraEdittingIssue(this.updateDescriptionForJiraIssue(jiraIssue));
    }

    private String updateDescriptionForJiraIssue(JiraIssue jiraIssue) {
        StringBuilder descriptionBuilder = new StringBuilder();
        String oldDescription = jiraIssue.getFields().getDescription();
        if (StringUtils.isNotEmpty((CharSequence)oldDescription)) {
            descriptionBuilder.append(oldDescription).append("\n");
        }
        descriptionBuilder.append(this.getDescription());
        return descriptionBuilder.toString();
    }
}

