/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira.issue;

import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.jira.issue.IssueHTMLLinkProvider;
import com.kms.katalon.integration.jira.issue.IssueMetaDataProvider;
import com.kms.katalon.integration.jira.setting.JiraIntegrationSettingStore;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public abstract class DefaultIssueHTMLLinkProvider
implements IssueHTMLLinkProvider {
    protected IssueMetaDataProvider issueMetaData;
    protected JiraIntegrationSettingStore settingStore;

    public IssueMetaDataProvider getIssueMetaData() {
        return this.issueMetaData;
    }

    protected DefaultIssueHTMLLinkProvider(TestCaseLogRecord logRecord, JiraIntegrationSettingStore settingStore) {
        this.settingStore = settingStore;
        this.issueMetaData = new IssueMetaDataProvider(logRecord);
    }

    protected DefaultIssueHTMLLinkProvider(TestCaseLogRecord logRecord, int endStepIndex, JiraIntegrationSettingStore settingStore) {
        this.settingStore = settingStore;
        this.issueMetaData = new IssueMetaDataProvider(logRecord, endStepIndex);
    }

    @Override
    public final String getHTMLLink() throws IOException, URISyntaxException, GeneralSecurityException {
        return new URIBuilder(this.getIssueUrl()).addParameters(this.getIssueParameters()).build().toString();
    }

    protected List<NameValuePair> getIssueParameters() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public String getLoginHTMLLink() throws IOException, URISyntaxException, GeneralSecurityException {
        return String.valueOf(this.settingStore.getServerUrl(this.settingStore.isEncryptionEnabled())) + "/login.jsp";
    }

    @Override
    public String getDashboardHTMLLink() throws IOException, URISyntaxException, GeneralSecurityException {
        return String.valueOf(this.settingStore.getServerUrl(this.settingStore.isEncryptionEnabled())) + "/secure/Dashboard.jspa";
    }
}

