/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira;

import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.jira.JiraAPIURL;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.ImprovedIssue;
import com.kms.katalon.integration.jira.entity.JiraAttachment;
import com.kms.katalon.integration.jira.entity.JiraFilter;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.entity.JiraIssueLink;
import com.kms.katalon.integration.jira.entity.JiraIssueType;
import com.kms.katalon.integration.jira.entity.JiraProject;
import com.kms.katalon.integration.jira.entity.JiraTestResult;
import com.kms.katalon.integration.jira.issue.IssueMetaDataProvider;
import com.kms.katalon.integration.jira.request.JiraIntegrationRequest;
import com.kms.katalon.integration.jira.util.ImprovedIssueDeserializer;
import com.kms.katalon.integration.jira.util.JiraDateDeserializer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class JiraIntegrationAuthenticationHandler
extends JiraIntegrationRequest {
    private static final String UTF_8 = "utf-8";

    public User authenticate(JiraCredential credential) throws JiraIntegrationException {
        return this.getJiraObject(credential, JiraAPIURL.getUserAPIUrl(credential), User.class);
    }

    public JiraIssue getJiraIssue(JiraCredential credential, String issueKey) throws JiraIntegrationException {
        return this.getJiraObject(credential, String.valueOf(JiraAPIURL.getIssueAPIUrl(credential)) + "/" + issueKey, JiraIssue.class);
    }

    public JiraIssueType[] getJiraIssuesTypes(JiraCredential credential) throws JiraIntegrationException {
        return (JiraIssueType[])this.getJiraArrayObjects(credential, JiraAPIURL.getIssueTypeAPIUrl(credential), JiraIssueType[].class);
    }

    public JiraProject[] getJiraProjects(JiraCredential credential) throws JiraIntegrationException {
        return (JiraProject[])this.getJiraArrayObjects(credential, JiraAPIURL.getProjectAPIUrl(credential), JiraProject[].class);
    }

    public List<JiraAttachment> uploadAttachment(JiraCredential credential, JiraIssue issue, String logFilePath) throws JiraIntegrationException {
        String result = this.sendUploadRequest(credential, JiraAPIURL.getIssueAttachmentsAPIUrl(credential, issue.getKey()), logFilePath);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return Collections.emptyList();
        }
        return Arrays.asList((JiraAttachment[])JsonUtil.fromJson((String)result, JiraAttachment[].class));
    }

    public void updateIssue(JiraCredential credential, JiraIssue jiraIssue, TestCaseLogRecord logRecord) throws JiraIntegrationException {
        IssueMetaDataProvider metaDataProvider = new IssueMetaDataProvider(logRecord);
        this.sendPutRequest(credential, String.valueOf(JiraAPIURL.getIssueAPIUrl(credential)) + "/" + jiraIssue.getKey(), JsonUtil.toJson((Object)metaDataProvider.toEdittingIssue(jiraIssue), (boolean)false));
    }

    public JiraFilter getJiraFilterByJql(JiraCredential credential, String jql) throws JiraIntegrationException, UnsupportedEncodingException {
        String result = this.getJiraResponse(credential, String.valueOf(JiraAPIURL.getFilterByJqlUrl(credential)) + URLEncoder.encode(jql, UTF_8));
        Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JiraDateDeserializer()).registerTypeAdapter(ImprovedIssue.class, (Object)new ImprovedIssueDeserializer()).create();
        return (JiraFilter)gson.fromJson(result, JiraFilter.class);
    }

    public void sendKatalonIntegrationProperty(JiraCredential credential, JiraIssue issue, JiraTestResult testResult) throws JiraIntegrationException {
        this.sendPutRequest(credential, JiraAPIURL.getKatalonIssuePropertyUrl(credential, Long.toString(issue.getId())), JsonUtil.toJson((Object)testResult));
    }

    public void linkJiraIssues(JiraCredential credential, JiraIssue inwardIssue, JiraIssue outwardIssue) throws JiraIntegrationException {
        JiraIssueLink issueLink = new JiraIssueLink("Relates", inwardIssue.getKey(), outwardIssue.getKey());
        this.sendPostRequest(credential, JiraAPIURL.getIssueLinkUrl(credential), issueLink.toJson());
    }

    public Optional<Field> getKatalonCustomField(JiraCredential credential) throws JiraIntegrationException {
        Field[] fields = (Field[])this.getJiraArrayObjects(credential, JiraAPIURL.getFieldAPIUrl(credential), Field[].class);
        if (fields == null) {
            return Optional.empty();
        }
        return Arrays.asList(fields).stream().filter(field -> field.getSchema() != null && "com.katalon.katalon-jira-plugin:com.katalon.jiraplugin.gherkin".equals(field.getSchema().getCustom())).findFirst();
    }
}

