/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.jira;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.JiraObjectToEntityConverter;
import com.kms.katalon.integration.jira.entity.JiraIssueCollection;
import com.kms.katalon.integration.jira.entity.JiraReport;
import com.kms.katalon.integration.jira.setting.JiraIntegrationSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.Platform;

public interface JiraComponent {
    default public boolean isJiraPluginEnabled() {
        return Platform.getBundle((String)"com.katalon.katalon-studio-jira-plugin") != null;
    }

    default public ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    default public JiraIntegrationSettingStore getSettingStore() {
        return new JiraIntegrationSettingStore(this.getCurrentProject().getFolderLocation());
    }

    default public JiraCredential getCredential() throws IOException, JiraIntegrationException {
        try {
            return this.getSettingStore().getJiraCredential();
        }
        catch (GeneralSecurityException e) {
            throw new JiraIntegrationException(e);
        }
    }

    default public void updateJiraReport(int index, TestCaseLogRecord logRecord, JiraIssueCollection jiraIssueCollection, ReportEntity reportEntity) throws JiraIntegrationException {
        JiraReport jiraReport = JiraObjectToEntityConverter.getJiraReport(reportEntity);
        jiraReport.getIssueCollectionMap().put(index, jiraIssueCollection);
        JiraObjectToEntityConverter.updateJiraReport(jiraReport, reportEntity);
    }

    default public JiraIssueCollection getJiraIssueCollection(int index, TestCaseLogRecord logRecord, ReportEntity reportEntity) {
        return JiraObjectToEntityConverter.getOptionalJiraIssueCollection(reportEntity, index).map(jiraIssue -> jiraIssue).orElse(new JiraIssueCollection(logRecord.getId()));
    }
}

