/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.frameworkadapter.util;

import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SpecifiedVersion {
    _16(1, 6, "16"),
    _17(1, 7, "17"),
    _18(1, 8, "18"),
    _19(1, 9, "19"),
    _20(2, 0, "20"),
    _21(2, 1, "21"),
    _22(2, 2, "22"),
    _23(2, 3, "23"),
    _24(2, 4, "24"),
    DONT_CARE(0, 0, "-1"),
    UNSPECIFIED(0, 0, "0");

    public final int majorVersion;
    public final int minorVersion;
    public final String versionName;

    private SpecifiedVersion(int majorVersion, int minorVersion, String versionName) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.versionName = versionName;
    }

    public String toVersionString() {
        return "[" + this.majorVersion + "." + this.minorVersion + "." + 0 + "," + this.majorVersion + "." + this.minorVersion + "." + 99 + ")";
    }

    public String toReadableVersionString() {
        if (this == UNSPECIFIED) {
            return "unspecified";
        }
        if (this == DONT_CARE) {
            return "I don't care";
        }
        return String.valueOf(this.majorVersion) + "." + this.minorVersion;
    }

    public static SpecifiedVersion parseVersion(String jarName) {
        boolean groovyAllStart;
        int verstionStart;
        String[] splits;
        boolean groovyStart = jarName.startsWith("groovy-");
        if (groovyStart && jarName.endsWith(".jar") && (splits = jarName.substring(verstionStart = (groovyAllStart = jarName.startsWith("groovy-all-")) ? "groovy-all-".length() : "groovy-".length()).split("\\.")).length > 1) {
            try {
                int major = Integer.valueOf(splits[0]);
                int minor = Integer.valueOf(splits[1]);
                switch (major) {
                    case 1: {
                        switch (minor) {
                            case 6: {
                                return _16;
                            }
                            case 7: {
                                return _17;
                            }
                            case 8: {
                                return _18;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (minor) {
                            case 0: {
                                return _20;
                            }
                            case 1: {
                                return _21;
                            }
                            case 2: {
                                return _22;
                            }
                            case 3: {
                                return _23;
                            }
                            case 4: {
                                return _24;
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return UNSPECIFIED;
    }

    public static SpecifiedVersion findVersionFromString(String compilerLevel) {
        if (compilerLevel == null) {
            return UNSPECIFIED;
        }
        if ("16".equals(compilerLevel) || "1.6".equals(compilerLevel)) {
            return _16;
        }
        if ("17".equals(compilerLevel) || "1.7".equals(compilerLevel)) {
            return _17;
        }
        if ("18".equals(compilerLevel) || "1.8".equals(compilerLevel)) {
            return _18;
        }
        if ("19".equals(compilerLevel) || "1.9".equals(compilerLevel)) {
            return _19;
        }
        if ("20".equals(compilerLevel) || "2.0".equals(compilerLevel)) {
            return _20;
        }
        if ("21".equals(compilerLevel) || "2.1".equals(compilerLevel)) {
            return _21;
        }
        if ("22".equals(compilerLevel) || "2.2".equals(compilerLevel)) {
            return _22;
        }
        if ("23".equals(compilerLevel) || "2.3".equals(compilerLevel)) {
            return _23;
        }
        if ("24".equals(compilerLevel) || "2.4".equals(compilerLevel)) {
            return _24;
        }
        if ("0".equals(compilerLevel)) {
            return UNSPECIFIED;
        }
        if ("-1".equals(compilerLevel)) {
            return DONT_CARE;
        }
        System.out.println("Invalid Groovy compiler level specified: " + compilerLevel + "\nMust be one of 16, 1.6, 17, 1.7, 18, 1.8, 19, 1.9, 20, 2.0, 21, 2.1, 22, 2.2, 23, 2.3, 24 or 2.4");
        return UNSPECIFIED;
    }

    public static SpecifiedVersion findVersion(Version ver) {
        switch (ver.getMajor()) {
            case 1: {
                switch (ver.getMinor()) {
                    case 6: {
                        return _16;
                    }
                    case 7: {
                        return _17;
                    }
                    case 8: {
                        return _18;
                    }
                }
                break;
            }
            case 2: {
                switch (ver.getMinor()) {
                    case 0: {
                        return _20;
                    }
                    case 1: {
                        return _21;
                    }
                    case 2: {
                        return _22;
                    }
                    case 3: {
                        return _23;
                    }
                    case 4: {
                        return _24;
                    }
                }
            }
        }
        return UNSPECIFIED;
    }
}

